/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.codeInsight.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.HamlBundle;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.impl.HAMLTagImpl;

public class HamlNestedTagContentInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            HamlNestedTagContentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            HamlNestedTagContentInspection.$$$reportNull$$$0(1);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (!(tag instanceof HAMLTagImpl) || ((HAMLTagImpl)tag).isTagNameEmpty()) {
                    return;
                }
                boolean firstLine = true;
                boolean textOnFirstLine = false;
                for (PsiElement element : tag.getChildren()) {
                    if (element.getNode().getElementType() == HAMLTokenTypes.TEXT && firstLine) {
                        textOnFirstLine = true;
                        continue;
                    }
                    if (element.getNode().getElementType() == HAMLTokenTypes.EOL) {
                        firstLine = false;
                        continue;
                    }
                    if (firstLine || !textOnFirstLine || element instanceof PsiComment || element.getText().trim().length() <= 0) continue;
                    holder.registerProblem((PsiElement)tag, HamlBundle.message("inspection.illegal.nesting.message", tag.getName()), new LocalQuickFix[0]);
                    return;
                }
            }
        };
        if (xmlElementVisitor == null) {
            HamlNestedTagContentInspection.$$$reportNull$$$0(2);
        }
        return xmlElementVisitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = HamlBundle.message("inspection.illegal.nesting.name");
        if (string == null) {
            HamlNestedTagContentInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/haml/codeInsight/inspections/HamlNestedTagContentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/haml/codeInsight/inspections/HamlNestedTagContentInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

