/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSelection {
    private final int[] myRows;
    private final int[] myColumns;
    private int[] myAdditionalColumns;
    private int[] myAdditionalRows;

    private GridSelection(int[] rows, int[] columns) {
        this.myRows = rows;
        this.myColumns = columns;
    }

    @NotNull
    public static GridSelection store(@NotNull JTable table) {
        if (table == null) {
            GridSelection.$$$reportNull$$$0(0);
        }
        GridSelection gridSelection = new GridSelection(GridSelection.convert(table.getRowCount(), table::convertRowIndexToModel, table.getSelectedRows()), GridSelection.convert(table.getColumnCount(), table::convertColumnIndexToModel, table.getSelectedColumns()));
        if (gridSelection == null) {
            GridSelection.$$$reportNull$$$0(1);
        }
        return gridSelection;
    }

    public void restore(@NotNull JTable table) {
        if (table == null) {
            GridSelection.$$$reportNull$$$0(2);
        }
        table.clearSelection();
        GridSelection.setColumnSelection(table, GridSelection.convert(table.getModel().getColumnCount(), table::convertColumnIndexToView, this.getColumns()));
        GridSelection.setRowSelection(table, GridSelection.convert(table.getModel().getRowCount(), table::convertRowIndexToView, this.getRows()));
    }

    @NotNull
    public GridSelection fit(@NotNull JTable table) {
        if (table == null) {
            GridSelection.$$$reportNull$$$0(3);
        }
        int rowCount = table.getRowCount();
        int columnCount = table.getColumnCount();
        GridSelection.fit(this.myRows, rowCount);
        GridSelection.fit(this.myColumns, columnCount);
        GridSelection.fit(this.myAdditionalRows, rowCount);
        GridSelection.fit(this.myAdditionalColumns, columnCount);
        GridSelection gridSelection = this;
        if (gridSelection == null) {
            GridSelection.$$$reportNull$$$0(4);
        }
        return gridSelection;
    }

    public GridSelection transpose() {
        return new GridSelection(this.myColumns, this.myRows);
    }

    public void addSelectedColumns(int ... additionalColumns) {
        this.myAdditionalColumns = additionalColumns;
    }

    public void addSelectedRows(int ... additionalRows) {
        this.myAdditionalRows = additionalRows;
    }

    public static void setColumnSelection(@NotNull JTable table, int ... selection) {
        if (table == null) {
            GridSelection.$$$reportNull$$$0(5);
        }
        GridSelection.setSelection(table.getColumnModel().getSelectionModel(), false, table.getColumnCount() - 1, selection);
    }

    public static void setRowSelection(@NotNull JTable table, int ... selection) {
        if (table == null) {
            GridSelection.$$$reportNull$$$0(6);
        }
        GridSelection.setSelection(table.getSelectionModel(), false, table.getRowCount() - 1, selection);
    }

    public static void addRowSelection(@NotNull JTable table, int ... selection) {
        if (table == null) {
            GridSelection.$$$reportNull$$$0(7);
        }
        GridSelection.setSelection(table.getSelectionModel(), true, table.getRowCount() - 1, selection);
    }

    private static void setSelection(ListSelectionModel selectionModel, boolean add, int maxSelectionIdx, int ... selection) {
        if (maxSelectionIdx < 0) {
            return;
        }
        if (!add) {
            selectionModel.clearSelection();
        }
        for (int index2 : selection) {
            GridSelection.setSelectionInterval(selectionModel, true, maxSelectionIdx, index2, index2);
        }
    }

    public static void setColumnSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            GridSelection.$$$reportNull$$$0(8);
        }
        GridSelection.setSelectionInterval(table.getColumnModel().getSelectionModel(), false, table.getColumnCount() - 1, idx0, idx1);
    }

    public static void addColumnSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            GridSelection.$$$reportNull$$$0(9);
        }
        GridSelection.setSelectionInterval(table.getColumnModel().getSelectionModel(), true, table.getColumnCount() - 1, idx0, idx1);
    }

    public static void setRowSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            GridSelection.$$$reportNull$$$0(10);
        }
        GridSelection.setSelectionInterval(table.getSelectionModel(), false, table.getRowCount() - 1, idx0, idx1);
    }

    public static void addRowSelectionInterval(@NotNull JTable table, int idx0, int idx1) {
        if (table == null) {
            GridSelection.$$$reportNull$$$0(11);
        }
        GridSelection.setSelectionInterval(table.getSelectionModel(), true, table.getRowCount() - 1, idx0, idx1);
    }

    private static void fit(@Nullable int[] indices, int max) {
        if (indices == null) {
            return;
        }
        for (int i2 = 0; i2 < indices.length; ++i2) {
            if (indices[i2] < max) continue;
            indices[i2] = max - 1;
        }
    }

    private static void setSelectionInterval(ListSelectionModel selectionModel, boolean add, int maxSelectionIdx, int idx0, int idx1) {
        if (maxSelectionIdx < 0) {
            return;
        }
        idx0 = GridSelection.index(idx0, maxSelectionIdx);
        idx1 = GridSelection.index(idx1, maxSelectionIdx);
        if (add) {
            selectionModel.addSelectionInterval(idx0, idx1);
        } else {
            selectionModel.setSelectionInterval(idx0, idx1);
        }
    }

    private static int index(int idx, int maxIdx) {
        return Math.max(0, Math.min(idx, maxIdx));
    }

    private int[] getColumns() {
        return this.myAdditionalColumns != null ? ArrayUtil.mergeArrays((int[])this.myColumns, (int[])this.myAdditionalColumns) : this.myColumns;
    }

    private int[] getRows() {
        return this.myAdditionalRows != null ? ArrayUtil.mergeArrays((int[])this.myRows, (int[])this.myAdditionalRows) : this.myRows;
    }

    private static int[] convert(int maxIndex, IntUnaryOperator function2, int[] indices) {
        return Arrays.stream(indices).filter(index2 -> index2 < maxIndex && index2 >= 0).map(function2).filter(index2 -> index2 != -1).toArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridSelection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "store";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setColumnSelection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setRowSelection";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addRowSelection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setColumnSelectionInterval";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addColumnSelectionInterval";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRowSelectionInterval";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addRowSelectionInterval";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

