/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunConfigurationProducerService;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ConfigurationFromContextImpl;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationProducer<T extends RunConfiguration> {
    public static final ExtensionPointName<RunConfigurationProducer> EP_NAME = ExtensionPointName.create((String)"com.intellij.runConfigurationProducer");
    private static final Logger LOG = Logger.getInstance(RunConfigurationProducer.class);
    private final ConfigurationFactory myConfigurationFactory;

    @NotNull
    public static List<RunConfigurationProducer<?>> getProducers(@NotNull Project project) {
        if (project == null) {
            RunConfigurationProducer.$$$reportNull$$$0(0);
        }
        RunConfigurationProducerService runConfigurationProducerService = RunConfigurationProducerService.getInstance(project);
        List allProducers = EP_NAME.getExtensionList();
        ArrayList result2 = new ArrayList(allProducers.size());
        for (RunConfigurationProducer producer : allProducers) {
            if (runConfigurationProducerService.isIgnored(producer)) continue;
            result2.add(producer);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            RunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    protected RunConfigurationProducer(@NotNull ConfigurationFactory configurationFactory) {
        if (configurationFactory == null) {
            RunConfigurationProducer.$$$reportNull$$$0(2);
        }
        this.myConfigurationFactory = configurationFactory;
    }

    protected RunConfigurationProducer(@NotNull Class<? extends ConfigurationType> type) {
        if (type == null) {
            RunConfigurationProducer.$$$reportNull$$$0(3);
        }
        this(ConfigurationTypeUtil.findConfigurationType(type));
    }

    protected RunConfigurationProducer(@NotNull ConfigurationType configurationType) {
        if (configurationType == null) {
            RunConfigurationProducer.$$$reportNull$$$0(4);
        }
        this.myConfigurationFactory = configurationType.getConfigurationFactories()[0];
    }

    public ConfigurationFactory getConfigurationFactory() {
        return this.myConfigurationFactory;
    }

    public ConfigurationType getConfigurationType() {
        return this.myConfigurationFactory.getType();
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(ConfigurationContext context) {
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context);
        Ref ref = new Ref((Object)context.getPsiLocation());
        try {
            if (!this.setupConfigurationFromContext(settings.getConfiguration(), context, (Ref<PsiElement>)ref)) {
                return null;
            }
        }
        catch (ClassCastException e) {
            LOG.error(this.myConfigurationFactory + " produced wrong type", (Throwable)e);
            return null;
        }
        return new ConfigurationFromContextImpl(this, settings, (PsiElement)ref.get());
    }

    protected abstract boolean setupConfigurationFromContext(T var1, ConfigurationContext var2, Ref<PsiElement> var3);

    public abstract boolean isConfigurationFromContext(T var1, ConfigurationContext var2);

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return true;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            RunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (other == null) {
            RunConfigurationProducer.$$$reportNull$$$0(6);
        }
        return false;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext context, @NotNull Runnable startRunnable) {
        if (configuration == null) {
            RunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (context == null) {
            RunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (startRunnable == null) {
            RunConfigurationProducer.$$$reportNull$$$0(9);
        }
        startRunnable.run();
    }

    @Nullable
    public ConfigurationFromContext findOrCreateConfigurationFromContext(ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        ConfigurationFromContext fromContext = this.createConfigurationFromContext(context);
        if (fromContext == null) {
            return null;
        }
        PsiElement psiElement = fromContext.getSourceElement();
        Location<PsiElement> _location = PsiLocation.fromPsiElement(psiElement, location.getModule());
        if (_location != null) {
            RunnerAndConfigurationSettings settings = this.findExistingConfiguration(context);
            if (settings == null) {
                RunManager.getInstance(context.getProject()).setUniqueNameIfNeed(fromContext.getConfiguration());
            } else {
                fromContext.setConfigurationSettings(settings);
            }
        }
        return fromContext;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(ConfigurationContext context) {
        RunManager runManager = RunManager.getInstance(context.getProject());
        List<RunnerAndConfigurationSettings> configurations = this.getConfigurationSettingsList(runManager);
        for (RunnerAndConfigurationSettings configurationSettings : configurations) {
            if (!this.isConfigurationFromContext(configurationSettings.getConfiguration(), context)) continue;
            return configurationSettings;
        }
        return null;
    }

    @NotNull
    protected List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull RunManager runManager) {
        if (runManager == null) {
            RunConfigurationProducer.$$$reportNull$$$0(10);
        }
        List<RunnerAndConfigurationSettings> list = runManager.getConfigurationSettingsList(this.myConfigurationFactory.getType());
        if (list == null) {
            RunConfigurationProducer.$$$reportNull$$$0(11);
        }
        return list;
    }

    protected RunnerAndConfigurationSettings cloneTemplateConfiguration(@NotNull ConfigurationContext context) {
        if (context == null) {
            RunConfigurationProducer.$$$reportNull$$$0(12);
        }
        return RunConfigurationProducer.cloneTemplateConfigurationStatic(context, this.myConfigurationFactory);
    }

    @NotNull
    protected static RunnerAndConfigurationSettings cloneTemplateConfigurationStatic(@NotNull ConfigurationContext context, @NotNull ConfigurationFactory configurationFactory) {
        RunConfiguration original;
        if (context == null) {
            RunConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (configurationFactory == null) {
            RunConfigurationProducer.$$$reportNull$$$0(14);
        }
        if ((original = context.getOriginalConfiguration(configurationFactory.getType())) != null) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance(context.getProject()).createConfiguration(original.clone(), configurationFactory);
            if (runnerAndConfigurationSettings == null) {
                RunConfigurationProducer.$$$reportNull$$$0(15);
            }
            return runnerAndConfigurationSettings;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance(context.getProject()).createConfiguration("", configurationFactory);
        if (runnerAndConfigurationSettings == null) {
            RunConfigurationProducer.$$$reportNull$$$0(16);
        }
        return runnerAndConfigurationSettings;
    }

    @NotNull
    public static <T extends RunConfigurationProducer> T getInstance(Class<? extends T> aClass) {
        for (RunConfigurationProducer producer : EP_NAME.getExtensionList()) {
            if (!aClass.isInstance(producer)) continue;
            RunConfigurationProducer runConfigurationProducer = producer;
            if (runConfigurationProducer == null) {
                RunConfigurationProducer.$$$reportNull$$$0(17);
            }
            return (T)runConfigurationProducer;
        }
        assert (false) : aClass;
        if (null == null) {
            RunConfigurationProducer.$$$reportNull$$$0(18);
        }
        return null;
    }

    @Nullable
    public RunConfiguration createLightConfiguration(@NotNull ConfigurationContext context) {
        if (context == null) {
            RunConfigurationProducer.$$$reportNull$$$0(19);
        }
        RunConfiguration configuration = this.myConfigurationFactory.createTemplateConfiguration(context.getProject());
        Ref ref = new Ref((Object)context.getPsiLocation());
        try {
            if (!this.setupConfigurationFromContext(configuration, context, (Ref<PsiElement>)ref)) {
                return null;
            }
        }
        catch (ClassCastException e) {
            LOG.error(this.myConfigurationFactory + " produced wrong type", (Throwable)e);
            return null;
        }
        return configuration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/RunConfigurationProducer";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRunnable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/RunConfigurationProducer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationSettingsList";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneTemplateConfigurationStatic";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProducers";
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onFirstRun";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationSettingsList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cloneTemplateConfiguration";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cloneTemplateConfigurationStatic";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createLightConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

