/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;

public class BegListUI
extends BasicListUI {
    @Override
    protected MouseInputListener createMouseInputListener() {
        return new PatchedInputHandler(this.list);
    }

    public class PatchedInputHandler
    extends BasicListUI.MouseInputHandler {
        private final JList myList;

        PatchedInputHandler(JList list2) {
            super(BegListUI.this);
            this.myList = list2;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row2;
            if (!this.myList.isEnabled()) {
                return;
            }
            if (!this.myList.hasFocus()) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myList, true));
            }
            if ((row2 = BegListUI.this.convertYToRow(e.getY())) != -1) {
                this.myList.setValueIsAdjusting(true);
                int anchorIndex = this.myList.getAnchorSelectionIndex();
                if (e.isControlDown()) {
                    if (this.myList.isSelectedIndex(row2)) {
                        this.myList.removeSelectionInterval(row2, row2);
                    } else {
                        this.myList.addSelectionInterval(row2, row2);
                    }
                } else if (e.isShiftDown() && anchorIndex != -1) {
                    this.myList.setSelectionInterval(anchorIndex, row2);
                } else {
                    this.myList.setSelectionInterval(row2, row2);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.myList.setValueIsAdjusting(false);
        }
    }
}

