/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

public class BMPFileHeader {
    private static final short bfType = 16973;
    public static final int SIZE = 14;
    private long bfSize;
    private long bfOffBits;

    public void write(OutputStream out) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(14);
        buf.putShort(0, (short)16973);
        buf.putInt(2, (int)(this.bfSize & (long)-1));
        buf.putInt(6, 0);
        buf.putInt(2, (int)(this.bfOffBits & (long)-1));
        out.write(buf.array());
    }

    public void setSize(long size) {
        this.bfSize = size;
    }

    public void setOffset(long offset) {
        this.bfOffBits = offset;
    }

    public long getSize() {
        return this.bfSize;
    }

    public long getOffset() {
        return this.bfOffBits;
    }

    public BMPFileHeader(ImageInputStream in) throws IOException, BMPException {
        byte[] data = new byte[14];
        if (in.read(data) != 14) {
            throw new IOException("Couldn't read header.");
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        if (buf.getShort(0) != 16973) {
            throw new BMPException("Not a BMP file.");
        }
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.bfSize = (long)buf.getInt(2) & (long)-1;
        this.bfOffBits = (long)buf.getInt(10) & (long)-1;
    }
}

