/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.schemainfo;

import java.io.Serializable;
import java.util.HashMap;

public class CaseInsensitiveString
implements Comparable<CaseInsensitiveString>,
Serializable {
    private static final long serialVersionUID = -4625230597578277614L;
    private char[] value = new char[0];
    private int offset = 0;
    private int count = 0;
    private int hash = 0;
    private boolean _isMutable;
    private static HashMap<Character, Character> upChars;
    private static HashMap<Character, Character> lcChars;

    public CaseInsensitiveString(String s) {
        this.value = new char[s.length()];
        s.getChars(0, s.length(), this.value, 0);
        this.offset = 0;
        this.count = s.length();
        this.hash = 0;
        this._isMutable = false;
    }

    public CaseInsensitiveString() {
        this._isMutable = true;
    }

    public void setCharBuffer(char[] buffer, int beginIndex, int len) {
        if (!this._isMutable) {
            throw new UnsupportedOperationException("This CaseInsensitiveString is immutable");
        }
        this.value = buffer;
        this.offset = beginIndex;
        this.count = len;
        this.hash = 0;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int off = this.offset;
            char[] val = this.value;
            int len = this.count;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + this.toUpperCase(val[off++]);
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            String other = (String)obj;
            if (other.length() != this.count) {
                return false;
            }
            for (int i = 0; i < this.count; ++i) {
                char u2;
                char c1 = this.value[this.offset + i];
                char c2 = other.charAt(i);
                char u1 = this.toUpperCase(c1);
                if (u1 == (u2 = this.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
                return false;
            }
            return true;
        }
        if (obj.getClass() == this.getClass()) {
            CaseInsensitiveString other = (CaseInsensitiveString)obj;
            if (other.count != this.count) {
                return false;
            }
            for (int i = 0; i < this.count; ++i) {
                char u2;
                char c1 = this.value[this.offset + i];
                char c2 = other.value[other.offset + i];
                char u1 = Character.toUpperCase(c1);
                if (u1 == (u2 = Character.toUpperCase(c2)) || this.toLowerCase(u1) == this.toLowerCase(u2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return new String(this.value, this.offset, this.count);
    }

    @Override
    public int compareTo(CaseInsensitiveString anotherString) {
        int len1 = this.count;
        int len2 = anotherString.count;
        int n = Math.min(len1, len2);
        char[] v1 = this.value;
        char[] v2 = anotherString.value;
        int i = this.offset;
        int j = anotherString.offset;
        if (i == j) {
            int lim = n + i;
            for (int k = i; k < lim; ++k) {
                char c1 = v1[k];
                char c2 = v2[k];
                if (this.toLowerCase(c1) == this.toLowerCase(c2)) continue;
                return this.toLowerCase(c1) - this.toLowerCase(c2);
            }
        } else {
            while (n-- != 0) {
                char c1 = v1[i++];
                char c2 = v2[j++];
                if (this.toLowerCase(c1) == this.toLowerCase(c2)) continue;
                return this.toLowerCase(c1) - this.toLowerCase(c2);
            }
        }
        return len1 - len2;
    }

    private char toLowerCase(char c) {
        char result = c;
        Character key = Character.valueOf(c);
        if (lcChars.containsKey(key)) {
            return lcChars.get(key).charValue();
        }
        if (Character.isUpperCase(c)) {
            result = Character.toLowerCase(c);
        }
        lcChars.put(key, Character.valueOf(result));
        return result;
    }

    private char toUpperCase(char c) {
        char result = c;
        Character key = Character.valueOf(c);
        if (upChars.containsKey(key)) {
            return upChars.get(key).charValue();
        }
        if (Character.isLowerCase(c)) {
            result = Character.toUpperCase(c);
        }
        upChars.put(key, Character.valueOf(result));
        return result;
    }

    static {
        if (upChars == null) {
            upChars = new HashMap();
        }
        if (lcChars == null) {
            lcChars = new HashMap();
        }
    }
}

