/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class HiFiBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return HiFiBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ScrollPaneBorder();
        }
        return scrollPaneBorder;
    }

    public static Border getTableScrollPaneBorder() {
        if (tableScrollPaneBorder == null) {
            tableScrollPaneBorder = new ScrollPaneBorder();
        }
        return tableScrollPaneBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getToolBarBorder() {
        if (toolBarBorder == null) {
            toolBarBorder = new ToolBarBorder();
        }
        return toolBarBorder;
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        private static final LazyImageIcon HOR_RUBBER_ICON = new LazyImageIcon("hifi/icons/HorRubber.gif");
        private static final LazyImageIcon VER_RUBBER_ICON = new LazyImageIcon("hifi/icons/VerRubber.gif");

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    int x1 = 4;
                    int y1 = (h - HOR_RUBBER_ICON.getIconHeight()) / 2;
                    HOR_RUBBER_ICON.paintIcon(c, g, x1, y1);
                } else {
                    int x1 = (w - VER_RUBBER_ICON.getIconWidth()) / 2 + 2;
                    int y1 = 4;
                    VER_RUBBER_ICON.paintIcon(c, g, x1, y1);
                }
            }
        }

        public Insets getBorderInsets(Component c) {
            Insets margin;
            Insets insets = new Insets(2, 2, 2, 2);
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    if (JTattooUtilities.isLeftToRight(c)) {
                        insets.left = 15;
                    } else {
                        insets.right = 15;
                    }
                } else {
                    insets.top = 15;
                }
            }
            if ((margin = ((JToolBar)c).getMargin()) != null) {
                insets.left += margin.left;
                insets.top += margin.top;
                insets.right += margin.right;
                insets.bottom += margin.bottom;
            }
            return insets;
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            Insets insets = this.getBorderInsets(c);
            borderInsets.left = insets.left;
            borderInsets.top = insets.top;
            borderInsets.right = insets.right;
            borderInsets.bottom = insets.bottom;
            return borderInsets;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public InternalFrameBorder() {
            this.insets.top = 3;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean active = this.isActive(c);
            int th = this.getTitleHeight(c);
            Color titleColor = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors()[0];
            ColorUIResource borderColor = AbstractLookAndFeel.getWindowInactiveTitleColorDark();
            ColorUIResource frameColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
            if (active) {
                titleColor = AbstractLookAndFeel.getTheme().getWindowTitleColors()[0];
                borderColor = AbstractLookAndFeel.getWindowTitleColorDark();
                frameColor = AbstractLookAndFeel.getWindowBorderColor();
            }
            g.setColor(titleColor);
            g.fillRect(x, y + 1, w, this.insets.top - 1);
            g.setColor(borderColor);
            g.fillRect(x + 1, y + h - 5, w - 2, 4);
            if (active) {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top, 5, th + 1);
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w - 5, this.insets.top, 5, th + 1);
            } else {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top, 4, th + 1);
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w - 5, this.insets.top, 4, th + 1);
            }
            g.setColor(borderColor);
            g.fillRect(1, this.insets.top + th + 1, 4, h - th - 5);
            g.fillRect(w - 5, this.insets.top + th + 1, 4, h - th - 5);
            g.setColor(frameColor);
            g.drawRect(x, y, w - 1, h - 1);
        }
    }

    public static class TabbedPaneBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource frameColor = AbstractLookAndFeel.getTheme().getFrameColor();
            JTattooUtilities.draw3DBorder(g, frameColor, ColorHelper.brighter(frameColor, 10.0), x, y, w, h);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(TabbedPaneBorder.insets.top, TabbedPaneBorder.insets.left, TabbedPaneBorder.insets.bottom, TabbedPaneBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = TabbedPaneBorder.insets.left;
            borderInsets.top = TabbedPaneBorder.insets.top;
            borderInsets.right = TabbedPaneBorder.insets.right;
            borderInsets.bottom = TabbedPaneBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ScrollPaneBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource frameColor = AbstractLookAndFeel.getTheme().getFrameColor();
            JTattooUtilities.draw3DBorder(g, frameColor, ColorHelper.brighter(frameColor, 10.0), x, y, w, h);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(ScrollPaneBorder.insets.top, ScrollPaneBorder.insets.left, ScrollPaneBorder.insets.bottom, ScrollPaneBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ScrollPaneBorder.insets.left;
            borderInsets.top = ScrollPaneBorder.insets.top;
            borderInsets.right = ScrollPaneBorder.insets.right;
            borderInsets.bottom = ScrollPaneBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Graphics2D g2D = (Graphics2D)g;
            Composite composite = g2D.getComposite();
            Color c1 = null;
            Color c2 = null;
            if (JTattooUtilities.isActive((JComponent)c)) {
                c1 = ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 60.0);
                c2 = AbstractLookAndFeel.getFrameColor();
            } else {
                c1 = AbstractLookAndFeel.getFrameColor();
                c2 = ColorHelper.darker(AbstractLookAndFeel.getFrameColor(), 20.0);
            }
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
            g2D.setComposite(alpha);
            JTattooUtilities.draw3DBorder(g, c1, c2, 0, 0, w, h);
            alpha = AlphaComposite.getInstance(3, 0.2f);
            g2D.setComposite(alpha);
            JTattooUtilities.draw3DBorder(g, c2, c1, 1, 1, w - 2, h - 2);
            g2D.setComposite(composite);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(4, 8, 4, 8);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Graphics2D g2D = (Graphics2D)g;
            g.translate(x, y);
            Color hiFrameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getButtonBackgroundColor(), 14.0);
            Color frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getButtonBackgroundColor(), 6.0);
            Color loFrameColor = ColorHelper.darker(AbstractLookAndFeel.getTheme().getButtonBackgroundColor(), 50.0);
            g.setColor(hiFrameColor);
            g.drawLine(1, 0, w - 3, 0);
            g.drawLine(0, 1, 0, h - 3);
            g.setColor(frameColor);
            g.drawLine(w - 2, 0, w - 2, h - 2);
            g.drawLine(1, h - 2, w - 3, h - 2);
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
            g2D.setComposite(alpha);
            g2D.setColor(loFrameColor);
            g.drawLine(1, 1, w - 3, 1);
            g.drawLine(1, 2, 1, h - 3);
            g.setColor(Color.black);
            g.drawLine(w - 1, 1, w - 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            alpha = AlphaComposite.getInstance(3, 0.2f);
            g2D.setComposite(alpha);
            g.drawLine(1, h - 2, 2, h - 1);
            g2D.setComposite(composite);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return insets;
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

