/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import net.sourceforge.napkinlaf.NapkinTitlePane;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinRootPaneUI
extends BasicRootPaneUI
implements NapkinPainter {
    private Window window;
    private JComponent titlePane;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private static final String[] BORDER_KEYS = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private static final int[] CURSOR_MAP = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent c) {
        return new NapkinRootPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.root = (JRootPane)c;
        if (this.root.getWindowDecorationStyle() != 0) {
            this.installClientDecorations(this.root);
        }
        NapkinUtil.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        super.uninstallUI(c);
        this.uninstallClientDecorations(this.root);
    }

    static void installBorder(JRootPane rootPane) {
        int style = rootPane.getWindowDecorationStyle();
        if (style != 0) {
            rootPane.setBorder((Border)UIManager.getDefaults().get(BORDER_KEYS[style]));
        }
    }

    private static void uninstallBorder(JComponent rootPane) {
        LookAndFeel.uninstallBorder(rootPane);
    }

    private void installWindowListeners(Component parent) {
        Window window = this.window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener();
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallWindowListeners() {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installLayout(Container rootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = NapkinRootPaneUI.createLayoutManager();
        }
        this.savedOldLayout = rootPane.getLayout();
        rootPane.setLayout(this.layoutManager);
    }

    private void uninstallLayout(Container rootPane) {
        if (this.savedOldLayout != null) {
            rootPane.setLayout(this.savedOldLayout);
        }
    }

    private void installClientDecorations(JRootPane rootPane) {
        NapkinRootPaneUI.installBorder(rootPane);
        this.setTitlePane(rootPane, NapkinRootPaneUI.createTitlePane(rootPane));
        this.installWindowListeners(rootPane.getParent());
        this.installLayout(rootPane);
        if (this.window != null) {
            rootPane.revalidate();
            rootPane.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane rootPane) {
        NapkinRootPaneUI.uninstallBorder(rootPane);
        this.uninstallWindowListeners();
        this.setTitlePane(rootPane, null);
        this.uninstallLayout(rootPane);
        int style = rootPane.getWindowDecorationStyle();
        if (style == 0) {
            rootPane.repaint();
            rootPane.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private static JComponent createTitlePane(JRootPane rootPane) {
        return new NapkinTitlePane(rootPane);
    }

    private MouseInputListener createWindowMouseInputListener() {
        return new MouseInputHandler();
    }

    private static LayoutManager createLayoutManager() {
        return new NapkinRootLayout();
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this.titlePane = titlePane;
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        super.propertyChange(ev);
        String propertyName = ev.getPropertyName();
        if (propertyName != null) {
            if (propertyName.equals("windowDecorationStyle")) {
                JRootPane pane = (JRootPane)ev.getSource();
                int style = pane.getWindowDecorationStyle();
                this.uninstallClientDecorations(pane);
                if (style != 0) {
                    this.installClientDecorations(pane);
                }
            } else if (propertyName.equals("ancestor")) {
                this.uninstallWindowListeners();
                if (((JRootPane)ev.getSource()).getWindowDecorationStyle() != 0) {
                    this.installWindowListeners(this.root.getParent());
                }
            }
        }
    }

    public void update(Graphics g, JComponent c) {
        NapkinUtil.update(g, c, this);
    }

    public void superPaint(Graphics g, JComponent c) {
        super.update(g, c);
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;
        private final PrivilegedExceptionAction<Point> getLocationAction = new PrivilegedExceptionAction<Point>(){

            @Override
            public Point run() throws HeadlessException {
                return MouseInfo.getPointerInfo().getLocation();
            }
        };

        private MouseInputHandler() {
        }

        public void mousePressed(MouseEvent ev) {
            JRootPane rootPane = NapkinRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() != 0) {
                int frameState;
                Point dragWindowOffset = ev.getPoint();
                Window w = (Window)ev.getSource();
                if (w != null) {
                    w.toFront();
                }
                Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, NapkinRootPaneUI.this.getTitlePane());
                Frame f = null;
                Dialog d = null;
                if (w instanceof Frame) {
                    f = (Frame)w;
                } else if (w instanceof Dialog) {
                    d = (Dialog)w;
                }
                int n = frameState = f != null ? f.getExtendedState() : 0;
                if (NapkinRootPaneUI.this.getTitlePane() != null && NapkinRootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset)) {
                    if ((f != null && (frameState & 6) == 0 || d != null) && dragWindowOffset.y >= 5 && dragWindowOffset.x >= 5 && dragWindowOffset.x < w.getWidth() - 5) {
                        this.isMovingWindow = true;
                        this.dragOffsetX = dragWindowOffset.x;
                        this.dragOffsetY = dragWindowOffset.y;
                    }
                } else if (f != null && f.isResizable() && (frameState & 6) == 0 || d != null && d.isResizable()) {
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                    this.dragWidth = w.getWidth();
                    this.dragHeight = w.getHeight();
                    this.dragCursor = this.getCursor(this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
                }
            }
        }

        public void mouseReleased(MouseEvent ev) {
            if (this.dragCursor != 0 && NapkinRootPaneUI.this.window != null && !NapkinRootPaneUI.this.window.isValid()) {
                NapkinRootPaneUI.this.window.validate();
                NapkinRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        public void mouseMoved(MouseEvent ev) {
            JRootPane root = NapkinRootPaneUI.this.getRootPane();
            if (root.getWindowDecorationStyle() != 0) {
                Window w = (Window)ev.getSource();
                Frame f = null;
                Dialog d = null;
                if (w instanceof Frame) {
                    f = (Frame)w;
                } else if (w instanceof Dialog) {
                    d = (Dialog)w;
                }
                int cursor = this.getCursor(this.calculateCorner(w, ev.getX(), ev.getY()));
                ((Component)w).setCursor(cursor != 0 && (f != null && f.isResizable() && (f.getExtendedState() & 6) == 0 || d != null && d.isResizable()) ? Cursor.getPredefinedCursor(cursor) : NapkinRootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                if (bounds.width < min.width) {
                    if (deltaX != 0) {
                        bounds.x -= min.width - bounds.width;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    if (deltaY != 0) {
                        bounds.y -= min.height - bounds.height;
                    }
                    bounds.height = min.height;
                }
            }
        }

        public void mouseDragged(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Point pt = ev.getPoint();
            if (this.isMovingWindow) {
                try {
                    Point windowPt = AccessController.doPrivileged(this.getLocationAction);
                    windowPt.x -= this.dragOffsetX;
                    windowPt.y -= this.dragOffsetY;
                    ((Component)w).setLocation(windowPt);
                }
                catch (PrivilegedActionException e) {}
            } else if (this.dragCursor != 0) {
                Rectangle r = w.getBounds();
                Rectangle startBounds = new Rectangle(r);
                Dimension min = ((Component)w).getMinimumSize();
                int dragY = this.dragWidth - this.dragOffsetX;
                int dragX = this.dragHeight - this.dragOffsetY;
                int offX = pt.x - this.dragOffsetX;
                int offY = pt.y - this.dragOffsetY;
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(r, min, 0, 0, pt.x + dragY - r.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(r, min, 0, 0, 0, pt.y + dragX - r.height);
                        break;
                    }
                    case 8: {
                        this.adjust(r, min, 0, offY, 0, -offY);
                        break;
                    }
                    case 10: {
                        this.adjust(r, min, offX, 0, -offX, 0);
                        break;
                    }
                    case 7: {
                        this.adjust(r, min, 0, offY, pt.x + dragY - r.width, -offY);
                        break;
                    }
                    case 5: {
                        this.adjust(r, min, 0, 0, pt.x + dragY - r.width, pt.y + dragX - r.height);
                        break;
                    }
                    case 6: {
                        this.adjust(r, min, offX, offY, -offX, -offY);
                        break;
                    }
                    case 4: {
                        this.adjust(r, min, offX, 0, -offX, pt.y + dragX - r.height);
                        break;
                    }
                }
                if (!r.equals(startBounds)) {
                    ((Component)w).setBounds(r);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        ((Component)w).validate();
                        NapkinRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent ev) {
            NapkinRootPaneUI.this.lastCursor = ((Component)ev.getSource()).getCursor();
            this.mouseMoved(ev);
        }

        public void mouseExited(MouseEvent ev) {
            ((Component)ev.getSource()).setCursor(NapkinRootPaneUI.this.lastCursor);
        }

        public void mouseClicked(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            if (w instanceof Frame) {
                Frame f = (Frame)w;
                JComponent titlePane = NapkinRootPaneUI.this.getTitlePane();
                Point convertedPoint = SwingUtilities.convertPoint(w, ev.getPoint(), titlePane);
                int state = f.getExtendedState();
                if (titlePane != null && titlePane.contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && f.isResizable()) {
                    f.setExtendedState((state & 6) != 0 ? state & 0xFFFFFFF9 : state | 6);
                }
            }
        }

        private int calculateCorner(Container w, int x, int y) {
            Insets insets = w.getInsets();
            int xPosition = this.calculatePosition(x - insets.left, w.getWidth() - insets.left - insets.right);
            int yPosition = this.calculatePosition(y - insets.top, w.getHeight() - insets.top - insets.bottom);
            return xPosition == -1 || yPosition == -1 ? -1 : yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            return corner == -1 ? 0 : CURSOR_MAP[corner];
        }

        private int calculatePosition(int spot, int width) {
            return spot < 5 ? 0 : (spot < 16 ? 1 : (spot >= width - 5 ? 4 : (spot >= width - 16 ? 3 : 2)));
        }
    }

    private static class NapkinRootLayout
    implements LayoutManager2 {
        private NapkinRootLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return NapkinRootLayout.layoutSize(parent, new SizeAccessor(){

                public Dimension size(Component c) {
                    return c.getPreferredSize();
                }
            });
        }

        public Dimension minimumLayoutSize(Container parent) {
            return NapkinRootLayout.layoutSize(parent, new SizeAccessor(){

                public Dimension size(Component c) {
                    return c.getMinimumSize();
                }
            });
        }

        private static Dimension layoutSize(Container parent, SizeAccessor sizer) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() == null ? root.getSize() : sizer.size(root.getContentPane());
            int cpWidth = 0;
            int cpHeight = 0;
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            int mbWidth = 0;
            int mbHeight = 0;
            if (root.getJMenuBar() != null && (mbd = sizer.size(root.getJMenuBar())) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            int tpWidth = 0;
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof NapkinRootPaneUI && (titlePane = ((NapkinRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = sizer.size(titlePane)) != null) {
                tpWidth = tpd.width;
            }
            int maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth);
            int width = maxWidth + i.left + i.right;
            int height = cpHeight + mbHeight + tpWidth + i.top + i.bottom;
            return new Dimension(width, height);
        }

        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            Insets i = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof NapkinRootPaneUI && (titlePane = ((NapkinRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i.left + i.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h);
            }
            int nextY = 0;
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof NapkinRootPaneUI && (titlePane = ((NapkinRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }

        static interface SizeAccessor {
            public Dimension size(Component var1);
        }
    }
}

