/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.StringTokenizer;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.JarPathname;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.LogicalPathname;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.URLPathname;
import org.armedbear.lisp.Utilities;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public class Pathname
extends LispObject
implements Serializable {
    protected LispObject host = Lisp.NIL;
    protected LispObject device = Lisp.NIL;
    protected LispObject directory = Lisp.NIL;
    protected LispObject name = Lisp.NIL;
    protected LispObject type = Lisp.NIL;
    protected LispObject version = Lisp.NIL;
    public static final char directoryDelimiter = '/';
    private static final Primitive _PATHNAME_HOST = new pf_pathname_host();
    private static final Primitive _PATHNAME_DEVICE = new pf_pathname_device();
    private static final Primitive _PATHNAME_DIRECTORY = new pf_pathname_directory();
    private static final Primitive _PATHNAME_NAME = new pf_pathname_name();
    private static final Primitive _PATHNAME_TYPE = new pf_pathname_type();
    private static final Primitive PATHNAME_VERSION = new pf_pathname_version();
    private static final Primitive NAMESTRING = new pf_namestring();
    private static final Primitive DIRECTORY_NAMESTRING = new pf_directory_namestring();
    private static final Primitive PATHNAME = new pf_pathname();
    private static final Primitive _PARSE_NAMESTRING = new pf_parse_namestring();
    private static final Primitive MAKE_PATHNAME = new pf_make_pathname();
    private static final Primitive PATHNAMEP = new pf_pathnamep();
    private static final Primitive LOGICAL_PATHNAME_P = new pf_logical_pathname_p();
    private static final Primitive USER_HOMEDIR_PATHNAME = new pf_user_homedir_pathname();
    private static final Primitive LIST_DIRECTORY = new pf_list_directory();
    @DocString(name="pathname-jar-p", args="pathname", returns="generalized-boolean", doc="Predicate functionfor whether PATHNAME references a jar.")
    private static final Primitive PATHNAME_JAR_P = new pf_pathname_jar_p();
    @DocString(name="pathname-url-p", args="pathname", returns="generalized-boolean", doc="Predicate function for whether PATHNAME references a jaurl.")
    private static final Primitive PATHNAME_URL_P = new pf_pathname_url_p();
    private static final Primitive _WILD_PATHNAME_P = new pf_wild_pathname_p();
    static final Primitive MERGE_PATHNAMES = new pf_merge_pathnames();
    public static final Primitive GET_INPUT_STREAM = new pf_get_input_stream();
    private static final Primitive MKDIR = new pf_mkdir();
    private static final Primitive RENAME_FILE = new pf_rename_file();
    private static final Primitive FILE_NAMESTRING = new pf_file_namestring();
    private static final Primitive HOST_NAMESTRING = new pf_host_namestring();

    protected static Pathname create() {
        return new Pathname();
    }

    public static Pathname create(Pathname p) {
        if (p instanceof JarPathname) {
            return JarPathname.create((JarPathname)p);
        }
        if (p instanceof URLPathname) {
            return URLPathname.create((URLPathname)p);
        }
        if (p instanceof LogicalPathname) {
            return LogicalPathname.create((LogicalPathname)p);
        }
        return new Pathname(p);
    }

    public static Pathname create(String s) {
        if (s.startsWith("jar:")) {
            return JarPathname.create(s);
        }
        if (Pathname.isValidURL(s)) {
            return URLPathname.create(s);
        }
        if (LogicalPathname.isValidLogicalPathname(s)) {
            return LogicalPathname.create(s);
        }
        Pathname result = Pathname.init(s);
        return result;
    }

    public static Pathname create(String s, String host) {
        return LogicalPathname.create(s, host);
    }

    public LispObject getHost() {
        return this.host;
    }

    public Pathname setHost(LispObject host) {
        this.host = host;
        return this;
    }

    public final LispObject getDevice() {
        return this.device;
    }

    public Pathname setDevice(LispObject device) {
        this.device = device;
        return this;
    }

    public LispObject getDirectory() {
        return this.directory;
    }

    public Pathname setDirectory(LispObject directory) {
        this.directory = directory;
        return this;
    }

    public LispObject getName() {
        return this.name;
    }

    public Pathname setName(LispObject name) {
        this.name = name;
        return this;
    }

    public LispObject getType() {
        return this.type;
    }

    public Pathname setType(LispObject type) {
        this.type = type;
        return this;
    }

    public LispObject getVersion() {
        return this.version;
    }

    public Pathname setVersion(LispObject version) {
        this.version = version;
        return this;
    }

    protected Pathname() {
    }

    private Pathname(Pathname p) {
        this.copyFrom(p);
    }

    public static LispObject ncoerce(Pathname orig, Pathname dest) {
        return dest.copyFrom(orig);
    }

    Pathname copyFrom(Pathname p) {
        if (p.host != Lisp.NIL) {
            LispObject pHost = p.getHost();
            if (pHost instanceof SimpleString) {
                this.setHost(new SimpleString(pHost.getStringValue()));
            } else if (pHost instanceof Symbol) {
                this.setHost(pHost);
            } else if (pHost instanceof Cons) {
                LispObject newHost = Lisp.NIL;
                LispObject components = pHost.reverse();
                while (!components.car().equals(Lisp.NIL)) {
                    LispObject copy = components.car();
                    newHost = newHost.push(copy);
                    components = components.cdr();
                }
                this.setHost(newHost);
            } else {
                Lisp.simple_error("Failed to copy host in pathname ~a", p);
            }
        }
        if (p.device != Lisp.NIL) {
            if (p.device instanceof SimpleString) {
                this.device = new SimpleString(((SimpleString)p.getDevice()).getStringValue());
            } else if (p.getDevice() instanceof Cons) {
                LispObject jars = p.getDevice();
                this.setDevice(Lisp.NIL);
                URLPathname root = null;
                Pathname rootPathname = (Pathname)jars.car();
                root = rootPathname instanceof URLPathname ? URLPathname.create((URLPathname)rootPathname) : URLPathname.create(rootPathname);
                this.device = this.device.push(root);
                jars = jars.cdr();
                while (jars.car() != Lisp.NIL) {
                    Pathname jar = Pathname.create(((Pathname)jars.car()).getNamestring());
                    this.device = this.device.push(jar);
                    jars = jars.cdr();
                }
                this.device.nreverse();
            } else if (p.device instanceof Symbol) {
                this.device = p.device;
            } else {
                Lisp.simple_error("Failed to copy device in pathname ~a", p);
            }
        }
        if (p.directory != Lisp.NIL) {
            if (p.directory instanceof Cons) {
                this.directory = Lisp.NIL;
                for (LispObject list = p.directory; list != Lisp.NIL; list = list.cdr()) {
                    LispObject o = list.car();
                    if (o instanceof Symbol) {
                        this.directory = this.directory.push(o);
                        continue;
                    }
                    if (o instanceof SimpleString) {
                        this.directory = this.directory.push(new SimpleString(((SimpleString)o).getStringValue()));
                        continue;
                    }
                    Debug.assertTrue(false);
                }
                this.directory.nreverse();
            } else {
                Lisp.simple_error("Failed to copy directory in pathname ~a", p);
            }
        }
        if (p.name != Lisp.NIL) {
            if (p.name instanceof SimpleString) {
                this.name = new SimpleString(((SimpleString)p.getName()).getStringValue());
            } else if (p.name instanceof Symbol) {
                this.name = p.name;
            } else {
                Lisp.simple_error("Failed to copy name in pathname ~a", p);
            }
        }
        if (p.type != Lisp.NIL) {
            if (p.type instanceof SimpleString) {
                this.type = new SimpleString(((SimpleString)p.getType()).getStringValue());
            } else if (p.type instanceof Symbol) {
                this.type = p.type;
            } else {
                Lisp.simple_error("Failed to copy type in pathname ~a", p);
            }
        }
        if (p.version != Lisp.NIL) {
            if (p.version instanceof Symbol) {
                this.version = p.version;
            } else if (p.version instanceof LispInteger) {
                this.version = p.version;
            } else {
                Lisp.simple_error("Failed to copy version in pathname ~a", p);
            }
        }
        return this;
    }

    public static boolean isSupportedProtocol(String protocol) {
        if ("jar".equals(protocol) || "file".equals(protocol)) {
            return true;
        }
        try {
            new URL(protocol, "example.org", "foo");
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private static final Pathname init(String s) {
        Pathname result = new Pathname();
        if (s == null) {
            return (Pathname)Lisp.parse_error("Refusing to create a PATHNAME for the null reference.");
        }
        if (s.equals(".") || s.equals("./") || Utilities.isPlatformWindows && s.equals(".\\")) {
            result.setDirectory(new Cons(Keyword.RELATIVE));
            return result;
        }
        if (s.startsWith("./")) {
            s = s.substring(2);
        }
        if (s.equals("..") || s.equals("../")) {
            result.setDirectory(Lisp.list(Keyword.RELATIVE, Keyword.UP));
            return result;
        }
        if (Utilities.isPlatformWindows && (s.startsWith("\\\\") || s.startsWith("//"))) {
            int dirIndex;
            int shareIndex;
            if (s.startsWith("\\\\")) {
                shareIndex = s.indexOf(92, 2);
                dirIndex = s.indexOf(92, shareIndex + 1);
            } else {
                shareIndex = s.indexOf(47, 2);
                dirIndex = s.indexOf(47, shareIndex + 1);
            }
            if (shareIndex == -1 || dirIndex == -1) {
                return (Pathname)Lisp.parse_error("Unsupported UNC path format: \"" + s + '\"');
            }
            result.setHost(new SimpleString(s.substring(2, shareIndex))).setDevice(new SimpleString(s.substring(shareIndex + 1, dirIndex)));
            Pathname p = Pathname.create(s.substring(dirIndex));
            result.setDirectory(p.getDirectory()).setName(p.getName()).setType(p.getType()).setVersion(p.getVersion());
            return result;
        }
        if (s.startsWith("jar:") && s.endsWith("!/")) {
            return JarPathname.create(s);
        }
        int separatorIndex = s.lastIndexOf("!/");
        if (separatorIndex > 0 && s.startsWith("jar:")) {
            return JarPathname.create(s);
        }
        if (Pathname.isValidURL(s)) {
            return URLPathname.create(s);
        }
        if (Utilities.isPlatformWindows && s.contains("\\")) {
            s = s.replace("\\", "/");
        }
        if (Utilities.isPlatformUnix) {
            if (s.equals("~")) {
                s = System.getProperty("user.home").concat("/");
            } else if (s.startsWith("~/")) {
                s = System.getProperty("user.home").concat(s.substring(1));
            }
        }
        if (Utilities.isPlatformWindows && s.length() >= 2 && s.charAt(1) == ':') {
            result.setDevice(new SimpleString(s.charAt(0)));
            s = s.substring(2);
        }
        String d = null;
        int i = s.length();
        while (i-- > 0) {
            if (s.charAt(i) != '/') continue;
            d = s.substring(0, i + 1);
            s = s.substring(i + 1);
            break;
        }
        if (d != null) {
            if (s.equals("..")) {
                d = d.concat(s);
                s = "";
            }
            result.setDirectory(Pathname.parseDirectory(d));
        }
        int index = s.lastIndexOf(46);
        String name = null;
        String type = null;
        if (index > 0) {
            name = s.substring(0, index);
            type = s.substring(index + 1);
        } else if (s.length() > 0) {
            name = s;
        }
        if (name != null) {
            if (name.equals("*")) {
                result.setName(Keyword.WILD);
            } else {
                result.setName(new SimpleString(name));
            }
        }
        if (type != null) {
            if (type.equals("*")) {
                result.setType(Keyword.WILD);
            } else {
                result.setType(new SimpleString(type));
            }
        }
        return result;
    }

    private static final LispObject parseDirectory(String d) {
        if (d.equals("/") || Utilities.isPlatformWindows && d.equals("\\")) {
            return new Cons(Keyword.ABSOLUTE);
        }
        LispObject result = d.startsWith("/") || Utilities.isPlatformWindows && d.startsWith("\\") ? new Cons(Keyword.ABSOLUTE) : new Cons(Keyword.RELATIVE);
        StringTokenizer st = new StringTokenizer(d, "/\\");
        while (st.hasMoreTokens()) {
            LispObject obj;
            String token = st.nextToken();
            if (token.equals("*")) {
                obj = Keyword.WILD;
            } else if (token.equals("**")) {
                obj = Keyword.WILD_INFERIORS;
            } else if (token.equals("..")) {
                if (result.car() instanceof AbstractString) {
                    result = result.cdr();
                    continue;
                }
                obj = Keyword.UP;
            } else {
                obj = new SimpleString(token);
            }
            result = new Cons(obj, result);
        }
        return ((LispObject)result).nreverse();
    }

    @Override
    public LispObject getParts() {
        Cons parts = Lisp.list(new Cons("HOST", this.getHost()), new Cons("DEVICE", this.getDevice()), new Cons("DIRECTORY", this.getDirectory()), new Cons("NAME", this.getName()), new Cons("TYPE", this.getType()), new Cons("VERSION", this.getVersion()));
        return parts;
    }

    @Override
    public LispObject typeOf() {
        if (this.isJar()) {
            return Symbol.JAR_PATHNAME;
        }
        if (this.isURL()) {
            return Symbol.URL_PATHNAME;
        }
        return Symbol.PATHNAME;
    }

    @Override
    public LispObject classOf() {
        if (this.isJar()) {
            return BuiltInClass.JAR_PATHNAME;
        }
        if (this.isURL()) {
            return BuiltInClass.URL_PATHNAME;
        }
        return BuiltInClass.PATHNAME;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.PATHNAME) {
            return Lisp.T;
        }
        if (type == Symbol.JAR_PATHNAME && this.isJar()) {
            return Lisp.T;
        }
        if (type == Symbol.URL_PATHNAME && this.isURL()) {
            return Lisp.T;
        }
        if (type == BuiltInClass.PATHNAME) {
            return Lisp.T;
        }
        if (type == BuiltInClass.JAR_PATHNAME && this.isJar()) {
            return Lisp.T;
        }
        if (type == BuiltInClass.URL_PATHNAME && this.isURL()) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public String getNamestring() {
        if (this.getDirectory() instanceof AbstractString) {
            Debug.assertTrue(false);
        }
        StringBuilder sb = new StringBuilder();
        if (this.getHost() != Lisp.NIL) {
            Debug.assertTrue(this.getHost() instanceof AbstractString || this.isURL());
            if (this.isURL()) {
                LispObject scheme = Symbol.GETF.execute(this.getHost(), URLPathname.SCHEME, Lisp.NIL);
                LispObject authority = Symbol.GETF.execute(this.getHost(), URLPathname.AUTHORITY, Lisp.NIL);
                Debug.assertTrue(scheme != Lisp.NIL);
                sb.append(scheme.getStringValue());
                sb.append(":");
                if (authority != Lisp.NIL) {
                    sb.append("//");
                    sb.append(authority.getStringValue());
                }
            } else if (this instanceof LogicalPathname) {
                sb.append(this.getHost().getStringValue());
                sb.append(':');
            } else {
                sb.append("//").append(this.getHost().getStringValue()).append("/");
            }
        }
        if (!this.getDevice().equals(Lisp.NIL) && !this.getDevice().equals(Keyword.UNSPECIFIC)) {
            if (this.getDevice() instanceof AbstractString) {
                sb.append(this.getDevice().getStringValue());
                if (this instanceof LogicalPathname || this.getHost() == Lisp.NIL) {
                    sb.append(':');
                }
            } else {
                Lisp.simple_error("Transitional error in pathname: should be a JAR-PATHNAME", this);
            }
        }
        String directoryNamestring = this.getDirectoryNamestring();
        sb.append(directoryNamestring);
        if (this.getName() instanceof AbstractString) {
            String n = this.getName().getStringValue();
            if (n.indexOf(47) >= 0) {
                return null;
            }
            sb.append(n);
        } else if (this.getName() == Keyword.WILD) {
            sb.append('*');
        }
        if (this.getType() != Lisp.NIL && this.getType() != Keyword.UNSPECIFIC) {
            sb.append('.');
            if (this.getType() instanceof AbstractString) {
                String t = this.getType().getStringValue();
                if (!(t.endsWith(".lnk") && Utilities.isPlatformWindows || t.indexOf(46) < 0)) {
                    return null;
                }
                sb.append(t);
            } else if (this.getType() == Keyword.WILD) {
                sb.append('*');
            } else {
                Debug.assertTrue(false);
            }
        }
        if (this instanceof LogicalPathname) {
            if (this.getVersion().integerp()) {
                sb.append('.');
                int base = Fixnum.getValue(Symbol.PRINT_BASE.symbolValue());
                if (this.getVersion() instanceof Fixnum) {
                    sb.append(Integer.toString(((Fixnum)this.getVersion()).value, base).toUpperCase());
                } else if (this.getVersion() instanceof Bignum) {
                    sb.append(((Bignum)this.getVersion()).value.toString(base).toUpperCase());
                }
            } else if (this.getVersion() == Keyword.WILD) {
                sb.append(".*");
            } else if (this.getVersion() == Keyword.NEWEST) {
                sb.append(".NEWEST");
            }
        }
        return sb.toString();
    }

    protected String getDirectoryNamestring() {
        this.validateDirectory(true);
        StringBuilder sb = new StringBuilder();
        if (this.getDirectory() != Lisp.NIL && this.getDirectory() != Keyword.UNSPECIFIC) {
            LispObject temp = this.getDirectory();
            LispObject part = temp.car();
            temp = temp.cdr();
            if (part == Keyword.ABSOLUTE) {
                sb.append('/');
            } else if (part == Keyword.RELATIVE) {
                if (temp == Lisp.NIL) {
                    sb.append('.');
                    sb.append('/');
                }
            } else {
                Lisp.error(new FileError("Unsupported directory component " + part.printObject() + ".", this));
            }
            while (temp != Lisp.NIL) {
                part = temp.car();
                if (part instanceof AbstractString) {
                    sb.append(part.getStringValue());
                } else if (part == Keyword.WILD) {
                    sb.append('*');
                } else if (part == Keyword.WILD_INFERIORS) {
                    sb.append("**");
                } else if (part == Keyword.UP) {
                    sb.append("..");
                }
                sb.append('/');
                temp = temp.cdr();
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pathname) {
            Pathname p = (Pathname)obj;
            if (Utilities.isPlatformWindows) {
                if (!this.host.equalp(p.host)) {
                    return false;
                }
                if (!this.device.equalp(p.device)) {
                    return false;
                }
                if (!this.directory.equalp(p.directory)) {
                    return false;
                }
                if (!this.name.equalp(p.name)) {
                    return false;
                }
                if (!this.type.equalp(p.type)) {
                    return false;
                }
            } else {
                if (!this.host.equal(p.host)) {
                    return false;
                }
                if (!this.device.equal(p.device)) {
                    return false;
                }
                if (!this.directory.equal(p.directory)) {
                    return false;
                }
                if (!this.name.equal(p.name)) {
                    return false;
                }
                if (!this.type.equal(p.type)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalp(LispObject obj) {
        return this.equal(obj);
    }

    public boolean equals(Object o) {
        if (!this.getClass().isAssignableFrom(o.getClass())) {
            return super.equals(o);
        }
        return this.equal((Pathname)o);
    }

    public int hashCode() {
        return this.sxhash();
    }

    @Override
    public int sxhash() {
        return (this.getHost().sxhash() ^ this.getDevice().sxhash() ^ this.getDirectory().sxhash() ^ this.getName().sxhash() ^ this.getType().sxhash()) & Integer.MAX_VALUE;
    }

    @Override
    public String printObject() {
        boolean useNamestring;
        LispThread thread = LispThread.currentThread();
        boolean printReadably = Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL;
        boolean printEscape = Symbol.PRINT_ESCAPE.symbolValue(thread) != Lisp.NIL;
        String s = null;
        s = this.getNamestring();
        if (s != null) {
            useNamestring = true;
            if (printReadably) {
                if (this.getHost() != Lisp.NIL && !this.isURL() || this.getVersion() != Lisp.NIL) {
                    useNamestring = false;
                } else if (this.getName() instanceof AbstractString) {
                    String n = this.getName().getStringValue();
                    if (n.equals(".") || n.equals("..")) {
                        useNamestring = false;
                    } else if (n.indexOf(File.separatorChar) >= 0) {
                        useNamestring = false;
                    }
                }
            }
        } else {
            useNamestring = false;
        }
        StringBuilder sb = new StringBuilder();
        if (useNamestring) {
            if (printReadably || printEscape) {
                sb.append("#P\"");
            }
            int limit = s.length();
            for (int i = 0; i < limit; ++i) {
                char c = s.charAt(i);
                if ((printReadably || printEscape) && (c == '\"' || c == '\\')) {
                    sb.append('\\');
                }
                sb.append(c);
            }
            if (printReadably || printEscape) {
                sb.append('\"');
            }
            return sb.toString();
        }
        sb.append("PATHNAME (with no namestring) ");
        if (this.getHost() != Lisp.NIL) {
            sb.append(":HOST ").append(this.getHost().printObject()).append(" ");
        }
        if (this.getDevice() != Lisp.NIL) {
            sb.append(":DEVICE ").append(this.getDevice().printObject()).append(" ");
        }
        if (this.getDirectory() != Lisp.NIL) {
            sb.append(":DIRECTORY ").append(this.getDirectory().printObject()).append(" ");
        }
        if (this.getName() != Lisp.NIL) {
            sb.append(":NAME ").append(this.getName().printObject()).append(" ");
        }
        if (this.getType() != Lisp.NIL) {
            sb.append(":TYPE ").append(this.getType().printObject()).append(" ");
        }
        if (this.getVersion() != Lisp.NIL) {
            sb.append(":VERSION ").append(this.getVersion().printObject()).append(" ");
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.setLength(sb.length() - 1);
        }
        return this.unreadableString(sb.toString());
    }

    public static Pathname parseNamestring(String s) {
        return Pathname.create(s);
    }

    public static boolean isValidURL(String s) {
        if (Utilities.isPlatformWindows && s.length() >= 2 && s.charAt(1) == ':') {
            char c = s.charAt(0);
            if ('A' <= s.charAt(0) && s.charAt(0) <= 'Z' || 'a' <= s.charAt(0) && s.charAt(0) <= 'z') {
                return false;
            }
        }
        if (s.indexOf(58) == -1) {
            return false;
        }
        try {
            URL c = new URL(s);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static LispObject parseNamestring(AbstractString namestring) {
        String h;
        String s = namestring.getStringValue();
        if (!Pathname.isValidURL(s) && (h = LogicalPathname.getHostString(s)) != null && LogicalPathname.TRANSLATIONS.get(new SimpleString(h)) != null) {
            return LogicalPathname.create(h, s.substring(s.indexOf(58) + 1));
        }
        return Pathname.create(s);
    }

    public static LogicalPathname parseNamestring(AbstractString namestring, AbstractString host) {
        String s = namestring.getStringValue();
        String h = LogicalPathname.getHostString(s);
        if (h != null) {
            if (!h.equals(host.getStringValue())) {
                Lisp.error(new LispError("Host in " + s + " does not match requested host " + host.getStringValue()));
                return null;
            }
            s = s.substring(s.indexOf(58) + 1);
        }
        if (LogicalPathname.TRANSLATIONS.get(host) != null) {
            return LogicalPathname.create(host.getStringValue(), s);
        }
        Lisp.error(new LispError(host.princToString() + " is not defined as a logical pathname host."));
        return null;
    }

    static final void checkCaseArgument(LispObject arg) {
        if (arg != Keyword.COMMON && arg != Keyword.LOCAL) {
            Lisp.type_error(arg, Lisp.list(Symbol.MEMBER, Keyword.COMMON, Keyword.LOCAL));
        }
    }

    public static final Pathname makePathname(LispObject args) {
        return (Pathname)Pathname._makePathname(args.copyToArray());
    }

    public static final Pathname makePathname(File file) {
        String namestring = null;
        try {
            namestring = file.getCanonicalPath();
        }
        catch (IOException e) {
            Debug.trace("Failed to make a Pathname from ." + file + "'");
            return null;
        }
        return Pathname.create(namestring);
    }

    static final LispObject _makePathname(LispObject[] args) {
        URLPathname result;
        Pathname p;
        if (args.length % 2 != 0) {
            Lisp.program_error("Odd number of keyword arguments.");
        }
        LispObject host = Lisp.NIL;
        LispObject device = Lisp.NIL;
        LispObject directory = Lisp.NIL;
        LispObject name = Lisp.NIL;
        LispObject type = Lisp.NIL;
        LispObject version = Lisp.NIL;
        Pathname defaults = null;
        boolean hostSupplied = false;
        boolean deviceSupplied = false;
        boolean nameSupplied = false;
        boolean typeSupplied = false;
        boolean directorySupplied = false;
        boolean versionSupplied = false;
        for (int i = 0; i < args.length; i += 2) {
            LispObject key = args[i];
            LispObject value = args[i + 1];
            if (key == Keyword.HOST) {
                host = value;
                hostSupplied = true;
                continue;
            }
            if (key == Keyword.DEVICE) {
                device = value;
                deviceSupplied = true;
                if (value instanceof AbstractString || value.equals(Keyword.UNSPECIFIC) || value.equals(Lisp.NIL) || value instanceof Cons) continue;
                return Lisp.type_error("DEVICE is not a string, :UNSPECIFIC, NIL, or a list.", value, Lisp.list(Symbol.OR, Symbol.STRING, Keyword.UNSPECIFIC, Lisp.NIL, Symbol.CONS));
            }
            if (key == Keyword.DIRECTORY) {
                directorySupplied = true;
                if (value instanceof AbstractString) {
                    directory = Lisp.list(Keyword.ABSOLUTE, value);
                    continue;
                }
                if (value == Keyword.WILD) {
                    directory = Lisp.list(Keyword.ABSOLUTE, Keyword.WILD);
                    continue;
                }
                if (value instanceof Cons || value == Keyword.UNSPECIFIC || value.equals(Lisp.NIL)) {
                    directory = value;
                    continue;
                }
                return Lisp.type_error("DIRECTORY argument not a string, list of strings, nil, :WILD, or :UNSPECIFIC.", value, Lisp.list(Symbol.OR, Lisp.NIL, Symbol.STRING, Symbol.CONS, Keyword.WILD, Keyword.UNSPECIFIC));
            }
            if (key == Keyword.NAME) {
                name = value;
                nameSupplied = true;
                continue;
            }
            if (key == Keyword.TYPE) {
                type = value;
                typeSupplied = true;
                continue;
            }
            if (key == Keyword.VERSION) {
                version = value;
                versionSupplied = true;
                continue;
            }
            if (key == Keyword.DEFAULTS) {
                defaults = Lisp.coerceToPathname(value);
                continue;
            }
            if (key != Keyword.CASE) continue;
        }
        if (defaults != null) {
            if (!hostSupplied) {
                host = defaults.getHost();
            }
            if (!directorySupplied) {
                directory = defaults.getDirectory();
            }
            if (!deviceSupplied) {
                device = defaults.getDevice();
            }
            if (!nameSupplied) {
                name = defaults.getName();
            }
            if (!typeSupplied) {
                type = defaults.getType();
            }
            if (!versionSupplied) {
                version = defaults.getVersion();
            }
        }
        LispObject logicalHost = Lisp.NIL;
        if (host != Lisp.NIL) {
            if (host instanceof AbstractString) {
                logicalHost = LogicalPathname.canonicalizeStringComponent((AbstractString)host);
            }
            if (LogicalPathname.TRANSLATIONS.get(logicalHost) == null) {
                p = Pathname.create();
                p.setHost(host);
            } else {
                p = LogicalPathname.create();
                p.setHost(logicalHost);
            }
            if (!Utilities.isPlatformWindows) {
                p.setDevice(Keyword.UNSPECIFIC);
            }
        } else {
            p = Pathname.create();
        }
        if (device != Lisp.NIL) {
            if (p instanceof LogicalPathname) {
                if (device != Keyword.UNSPECIFIC) {
                    return Lisp.type_error("The device component of a logical pathname must be :UNSPECIFIC.", p.getDevice(), Keyword.UNSPECIFIC);
                }
            } else if (device instanceof Cons) {
                LispObject normalizedDevice = Lisp.NIL;
                if (device.car() instanceof SimpleString) {
                    String rootNamestring = device.car().getStringValue();
                    URLPathname root = new URLPathname();
                    if (!Pathname.isValidURL(rootNamestring)) {
                        Pathname rootPathname = Pathname.create(rootNamestring);
                        root = URLPathname.createFromFile(rootPathname);
                    } else {
                        root = URLPathname.create(rootNamestring);
                    }
                    normalizedDevice = normalizedDevice.push(root);
                } else {
                    normalizedDevice = normalizedDevice.push(device.car());
                }
                LispObject o = device.cdr();
                while (!o.car().equals(Lisp.NIL)) {
                    Pathname next = Lisp.coerceToPathname(o.car());
                    normalizedDevice = normalizedDevice.push(next);
                    o = o.cdr();
                }
                normalizedDevice = normalizedDevice.nreverse();
                p.setDevice(normalizedDevice);
            } else {
                p.setDevice(device);
            }
        }
        if (directory != Lisp.NIL) {
            if (p instanceof LogicalPathname) {
                if (directory.listp()) {
                    LispObject d = Lisp.NIL;
                    while (directory != Lisp.NIL) {
                        LispObject component = directory.car();
                        d = component instanceof AbstractString ? d.push(LogicalPathname.canonicalizeStringComponent((AbstractString)component)) : d.push(component);
                        directory = directory.cdr();
                    }
                    p.setDirectory(d.nreverse());
                } else if (directory == Keyword.WILD || directory == Keyword.WILD_INFERIORS) {
                    p.setDirectory(directory);
                } else {
                    Lisp.error(new LispError("Invalid directory component for logical pathname: " + directory.princToString()));
                }
            } else {
                p.setDirectory(directory);
            }
        }
        if (name != Lisp.NIL) {
            if (p instanceof LogicalPathname && name instanceof AbstractString) {
                p.setName(LogicalPathname.canonicalizeStringComponent((AbstractString)name));
            } else if (name instanceof AbstractString) {
                p.setName(Pathname.validateStringComponent((AbstractString)name));
            } else {
                p.setName(name);
            }
        }
        if (type != Lisp.NIL) {
            if (p instanceof LogicalPathname && type instanceof AbstractString) {
                p.setType(LogicalPathname.canonicalizeStringComponent((AbstractString)type));
            } else {
                p.setType(type);
            }
        }
        p.setVersion(version);
        p.validateDirectory(true);
        if (p.getDevice() instanceof Cons) {
            result = new JarPathname();
            result.copyFrom(p);
            Pathname root = (Pathname)result.getDevice().car();
            URLPathname rootDevice = null;
            rootDevice = root instanceof URLPathname ? URLPathname.create((URLPathname)root) : URLPathname.create(root);
            result.setDevice(new Cons(rootDevice, result.getDevice().cdr()));
            if (!(!result.getDirectory().equals(Lisp.NIL) || result.getName().equals(Lisp.NIL) && result.getType().equals(Lisp.NIL))) {
                result.setDirectory(Lisp.NIL.push(Keyword.ABSOLUTE));
            }
            ((JarPathname)result).validateComponents();
            return result;
        }
        if (p.isURL()) {
            result = new URLPathname();
            result.copyFrom(p);
            return result;
        }
        return p;
    }

    private static final AbstractString validateStringComponent(AbstractString s) {
        int limit = s.length();
        for (int i = 0; i < limit; ++i) {
            char c = s.charAt(i);
            if (c != '/' && (c != '\\' || !Utilities.isPlatformWindows)) continue;
            Lisp.error(new LispError("Invalid character #\\" + c + " in pathname component \"" + s + '\"'));
            return null;
        }
        return s;
    }

    private final boolean validateDirectory(boolean signalError) {
        LispObject temp = this.getDirectory();
        if (temp == Keyword.UNSPECIFIC) {
            return true;
        }
        while (temp != Lisp.NIL) {
            LispObject first = temp.car();
            temp = temp.cdr();
            if (first == Keyword.ABSOLUTE || first == Keyword.WILD_INFERIORS) {
                LispObject second = temp.car();
                if (second != Keyword.UP && second != Keyword.BACK) continue;
                if (signalError) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(first.printObject());
                    sb.append(" may not be followed immediately by ");
                    sb.append(second.printObject());
                    sb.append('.');
                    Lisp.error(new FileError(sb.toString(), this));
                }
                return false;
            }
            if (first == Keyword.RELATIVE || first == Keyword.WILD || first == Keyword.UP || first == Keyword.BACK || first instanceof AbstractString) continue;
            if (signalError) {
                Lisp.error(new FileError("Unsupported directory component " + first.princToString() + ".", this));
            }
            return false;
        }
        return true;
    }

    public boolean isAbsolute() {
        return (!this.directory.equals(Lisp.NIL) || this.directory != null) && this.getDirectory() instanceof Cons && ((Cons)this.getDirectory()).car().equals(Keyword.ABSOLUTE);
    }

    public boolean isJar() {
        return this.getDevice() instanceof Cons;
    }

    public boolean isURL() {
        return this.getHost() instanceof Cons;
    }

    public boolean isWild() {
        if (this.getHost() == Keyword.WILD || this.getHost() == Keyword.WILD_INFERIORS) {
            return true;
        }
        if (this.getDevice() == Keyword.WILD || this.getDevice() == Keyword.WILD_INFERIORS) {
            return true;
        }
        if (this.getDirectory() instanceof Cons) {
            if (Lisp.memq(Keyword.WILD, this.getDirectory())) {
                return true;
            }
            if (Lisp.memq(Keyword.WILD_INFERIORS, this.getDirectory())) {
                return true;
            }
            Cons d = (Cons)this.getDirectory();
            while (true) {
                String s;
                if (d.car() instanceof AbstractString && (s = d.car().printObject()).contains("*")) {
                    return true;
                }
                if (d.cdr() == Lisp.NIL || !(d.cdr() instanceof Cons)) break;
                d = (Cons)d.cdr();
            }
        }
        if (this.getName() == Keyword.WILD || this.getName() == Keyword.WILD_INFERIORS) {
            return true;
        }
        if (this.getName() instanceof AbstractString && this.getName().printObject().contains("*")) {
            return true;
        }
        if (this.getType() == Keyword.WILD || this.getType() == Keyword.WILD_INFERIORS) {
            return true;
        }
        if (this.getType() instanceof AbstractString && this.getType().printObject().contains("*")) {
            return true;
        }
        return this.getVersion() == Keyword.WILD || this.getVersion() == Keyword.WILD_INFERIORS;
    }

    public static final Pathname mergePathnames(Pathname pathname, Pathname defaultPathname) {
        return Pathname.mergePathnames(pathname, defaultPathname, Keyword.NEWEST);
    }

    public static final Pathname mergePathnames(Pathname pathname, Pathname defaultPathname, LispObject defaultVersion) {
        Pathname d;
        Pathname result;
        Pathname p = Pathname.create(pathname);
        if (pathname instanceof LogicalPathname) {
            result = LogicalPathname.create();
            d = Pathname.create(defaultPathname);
        } else {
            result = pathname instanceof JarPathname || defaultPathname instanceof JarPathname && !(pathname instanceof JarPathname) && pathname.getHost().equals(Lisp.NIL) && pathname.getDevice().equals(Lisp.NIL) && (pathname.getDirectory().equals(Lisp.NIL) || pathname.getDirectory().car().equals(Keyword.RELATIVE)) ? JarPathname.create() : (pathname instanceof URLPathname ? URLPathname.create() : Pathname.create());
            d = defaultPathname instanceof LogicalPathname ? LogicalPathname.translateLogicalPathname((LogicalPathname)defaultPathname) : (defaultPathname instanceof JarPathname ? JarPathname.create((JarPathname)defaultPathname) : (defaultPathname instanceof URLPathname ? URLPathname.create(defaultPathname) : Pathname.create(defaultPathname)));
        }
        if (pathname.getHost().equals(Lisp.NIL)) {
            result.setHost(d.getHost());
        } else {
            result.setHost(p.getHost());
        }
        if (!pathname.getDevice().equals(Lisp.NIL)) {
            if (!Utilities.isPlatformWindows) {
                result.setDevice(p.getDevice());
            } else if (d instanceof JarPathname && p instanceof JarPathname) {
                result.setDevice(d.getDevice());
            } else {
                result.setDevice(p.getDevice());
            }
        } else if (d instanceof JarPathname && !(result instanceof JarPathname)) {
            if (!Utilities.isPlatformWindows) {
                result.setDevice(Keyword.UNSPECIFIC);
            } else {
                result.setDevice(d.getDevice());
            }
        } else if (p.isLocalFile()) {
            result.setDevice(d.getDevice());
        } else {
            result.setDevice(p.getDevice());
        }
        if (pathname.isJar()) {
            result.setDirectory(p.getDirectory());
        } else {
            LispObject directories;
            result.setDirectory(Pathname.mergeDirectories(p.getDirectory(), d.getDirectory()));
            if (result instanceof JarPathname && !(directories = result.getDirectory()).car().equals(Lisp.NIL) && directories.car().equals(Keyword.RELATIVE)) {
                directories = directories.cdr().push(Keyword.ABSOLUTE);
                result.setDirectory(directories);
            }
        }
        if (pathname.getName() != Lisp.NIL) {
            result.setName(p.getName());
        } else {
            result.setName(d.getName());
        }
        if (pathname.getType() != Lisp.NIL) {
            result.setType(p.getType());
        } else {
            result.setType(d.getType());
        }
        if (result instanceof JarPathname && (!result.getName().equals(Lisp.NIL) || !result.getType().equals(Lisp.NIL)) && result.getDirectory().equals(Lisp.NIL)) {
            result.setDirectory(Lisp.NIL.push(Keyword.ABSOLUTE));
        }
        if (p.getVersion() != Lisp.NIL) {
            result.setVersion(p.getVersion());
        } else if (p.getName() == Lisp.NIL) {
            if (defaultPathname.getVersion() == Lisp.NIL) {
                result.setVersion(defaultVersion);
            } else {
                result.setVersion(defaultPathname.getVersion());
            }
        } else if (defaultVersion == Lisp.NIL) {
            result.setVersion(p.getVersion());
        }
        if (result.getVersion() == Lisp.NIL) {
            result.setVersion(defaultVersion);
        }
        if (pathname instanceof LogicalPathname) {
            result.setDevice(Keyword.UNSPECIFIC);
            if (result.getDirectory().listp()) {
                LispObject canonical = Lisp.NIL;
                for (LispObject original = result.getDirectory(); original != Lisp.NIL; original = original.cdr()) {
                    LispObject component = original.car();
                    if (component instanceof AbstractString) {
                        component = LogicalPathname.canonicalizeStringComponent((AbstractString)component);
                    }
                    canonical = canonical.push(component);
                }
                result.setDirectory(canonical.nreverse());
            }
            if (result.getName() instanceof AbstractString) {
                result.setName(LogicalPathname.canonicalizeStringComponent((AbstractString)result.getName()));
            }
            if (result.getType() instanceof AbstractString) {
                result.setType(LogicalPathname.canonicalizeStringComponent((AbstractString)result.getType()));
            }
        }
        if (result instanceof Pathname && URLPathname.hasExplicitFile(result)) {
            URLPathname downcastResult = new URLPathname();
            downcastResult.copyFrom(result);
            result = downcastResult;
        }
        return result;
    }

    private static final LispObject mergeDirectories(LispObject dir, LispObject defaultDir) {
        if (dir == Lisp.NIL) {
            return defaultDir;
        }
        if (dir.car() == Keyword.RELATIVE && defaultDir != Lisp.NIL) {
            int i;
            LispObject result = Lisp.NIL;
            while (defaultDir != Lisp.NIL) {
                result = new Cons(defaultDir.car(), result);
                defaultDir = defaultDir.cdr();
            }
            for (dir = dir.cdr(); dir != Lisp.NIL; dir = dir.cdr()) {
                result = new Cons(dir.car(), result);
            }
            LispObject[] array = result.copyToArray();
            for (i = 0; i < array.length - 1; ++i) {
                if (array[i] != Keyword.BACK || !(array[i + 1] instanceof AbstractString) && array[i + 1] != Keyword.WILD) continue;
                array[i] = null;
                array[i + 1] = null;
            }
            result = Lisp.NIL;
            for (i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                result = new Cons(array[i], result);
            }
            return result;
        }
        return dir;
    }

    public static LispObject truename(Pathname pathname) {
        return Pathname.truename(pathname, false);
    }

    public static LispObject truename(LispObject arg) {
        return Pathname.truename(arg, false);
    }

    public static LispObject truename(LispObject arg, boolean errorIfDoesNotExist) {
        Pathname pathname = Lisp.coerceToPathname(arg);
        return Pathname.truename(pathname, errorIfDoesNotExist);
    }

    public static LispObject truename(Pathname pathname, boolean errorIfDoesNotExist) {
        if (pathname == null || pathname.equals(Lisp.NIL)) {
            return Pathname.doTruenameExit(pathname, errorIfDoesNotExist);
        }
        if (pathname instanceof LogicalPathname) {
            pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
        }
        if (pathname.isWild()) {
            return Lisp.error(new FileError("Fundamentally unable to find a truename for any wild pathname.", pathname));
        }
        Pathname result = Pathname.mergePathnames(pathname, Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()), Lisp.NIL);
        File file = result.getFile();
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                result = Pathname.getDirectoryPathname(file);
            } else {
                try {
                    result = Pathname.create(file.getCanonicalPath());
                }
                catch (IOException e) {
                    return Lisp.error(new FileError(e.getMessage(), pathname));
                }
            }
            if (Utilities.isPlatformUnix) {
                result.setDevice(Keyword.UNSPECIFIC);
            }
            return result;
        }
        return Pathname.doTruenameExit(pathname, errorIfDoesNotExist);
    }

    static LispObject doTruenameExit(Pathname pathname, boolean errorIfDoesNotExist) {
        if (errorIfDoesNotExist) {
            StringBuilder sb = new StringBuilder("The file ");
            sb.append(pathname.princToString());
            sb.append(" does not exist.");
            return Lisp.error(new FileError(sb.toString(), pathname));
        }
        return Lisp.NIL;
    }

    public InputStream getInputStream() {
        FileInputStream result = null;
        File file = this.getFile();
        try {
            result = new FileInputStream(file);
        }
        catch (IOException e) {
            Lisp.simple_error("Failed to get InputStream from ~a because ~a", this, e);
        }
        return result;
    }

    public long getLastModified() {
        File f = this.getFile();
        return f.lastModified();
    }

    File getFile() {
        String namestring = this.getNamestring();
        if (namestring != null) {
            try {
                URI uri = new URI(namestring);
                return new File(uri);
            }
            catch (URISyntaxException ex) {
                return new File(namestring);
            }
            catch (IllegalArgumentException e) {
                return new File(namestring);
            }
        }
        Lisp.error(new FileError("Pathname has no namestring: " + this.princToString(), this));
        return (File)Lisp.UNREACHED;
    }

    public static Pathname getDirectoryPathname(File file) {
        try {
            String namestring = file.getCanonicalPath();
            if (namestring != null && namestring.length() > 0 && namestring.charAt(namestring.length() - 1) != File.separatorChar) {
                namestring = namestring.concat(File.separator);
            }
            return Pathname.create(namestring);
        }
        catch (IOException e) {
            Lisp.error(new LispError(e.getMessage()));
            return null;
        }
    }

    public boolean isLocalFile() {
        return this.getHost().equals(Lisp.NIL) || Symbol.GETF.execute(this.getHost(), URLPathname.SCHEME, Lisp.NIL).equals(URLPathname.FILE);
    }

    Pathname getEntryPath() {
        return Pathname.create(this.asEntryPath());
    }

    String asEntryPath() {
        Pathname p = Pathname.create();
        p.setDirectory(this.getDirectory()).setName(this.getName()).setType(this.getType());
        String path = p.getNamestring();
        StringBuilder result = new StringBuilder();
        result.append(path);
        if (result.length() > 1 && result.substring(0, 1).equals("/")) {
            return result.substring(1);
        }
        return result.toString();
    }

    boolean isRemote() {
        if (this instanceof URLPathname) {
            URLPathname p = (URLPathname)this;
            LispObject scheme = Symbol.GETF.execute(p.getHost(), URLPathname.SCHEME, Lisp.NIL);
            return !scheme.equals(Lisp.NIL) && !p.getHost().getStringValue().equals("file");
        }
        if (this instanceof JarPathname) {
            Pathname root = (Pathname)((JarPathname)this).getRootJar();
            return root.isRemote();
        }
        return false;
    }

    static {
        LispObject obj = Symbol.DEFAULT_PATHNAME_DEFAULTS.getSymbolValue();
        Symbol.DEFAULT_PATHNAME_DEFAULTS.setSymbolValue(Lisp.coerceToPathname(obj));
    }

    @DocString(name="host-namestring", args="pathname", returns="namestring", doc="Returns the host name of PATHNAME.")
    private static class pf_host_namestring
    extends Primitive {
        pf_host_namestring() {
            super("host-namestring", "pathname");
        }

        @Override
        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPathname(arg).getHost();
        }
    }

    @DocString(name="file-namestring", args="pathname", returns="namestring", doc="Returns just the name, type, and version components of PATHNAME.")
    private static class pf_file_namestring
    extends Primitive {
        pf_file_namestring() {
            super(Symbol.FILE_NAMESTRING, "pathname");
        }

        @Override
        public LispObject execute(LispObject arg) {
            Pathname p = Lisp.coerceToPathname(arg);
            StringBuilder sb = new StringBuilder();
            if (p.getName() instanceof AbstractString) {
                sb.append(p.getName().getStringValue());
            } else if (p.getName() == Keyword.WILD) {
                sb.append('*');
            } else {
                return Lisp.NIL;
            }
            if (p.getType() instanceof AbstractString) {
                sb.append('.');
                sb.append(p.getType().getStringValue());
            } else if (p.getType() == Keyword.WILD) {
                sb.append(".*");
            }
            return new SimpleString(sb);
        }
    }

    @DocString(name="rename-file", args="filespec new-name", returns="defaulted-new-name, old-truename, new-truename", doc="Modifies the file system in such a way that the file indicated by FILESPEC is renamed to DEFAULTED-NEW-NAME.\n\nReturns three values if successful. The primary value, DEFAULTED-NEW-NAME, is \nthe resulting name which is composed of NEW-NAME with any missing components filled in by \nperforming a merge-pathnames operation using filespec as the defaults. The secondary \nvalue, OLD-TRUENAME, is the truename of the file before it was renamed. The tertiary \nvalue, NEW-TRUENAME, is the truename of the file after it was renamed.\n")
    private static class pf_rename_file
    extends Primitive {
        pf_rename_file() {
            super("rename-file", "filespec new-name");
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Pathname oldPathname = Lisp.coerceToPathname(first);
            Pathname oldTruename = (Pathname)Symbol.TRUENAME.execute(oldPathname);
            Pathname newName = Lisp.coerceToPathname(second);
            if (newName.isWild()) {
                Lisp.error(new FileError("Bad place for a wild pathname.", newName));
            }
            if (oldTruename.isJar()) {
                Lisp.error(new FileError("Bad place for a jar pathname.", oldTruename));
            }
            if (newName.isJar()) {
                Lisp.error(new FileError("Bad place for a jar pathname.", newName));
            }
            if (oldTruename.isURL()) {
                Lisp.error(new FileError("Bad place for a URL pathname.", oldTruename));
            }
            if (newName.isURL()) {
                Lisp.error(new FileError("Bad place for a jar pathname.", newName));
            }
            Pathname defaultedNewName = Pathname.mergePathnames(newName, oldTruename, Lisp.NIL);
            File source2 = oldTruename.getFile();
            File destination = null;
            destination = defaultedNewName instanceof LogicalPathname ? LogicalPathname.translateLogicalPathname((LogicalPathname)defaultedNewName).getFile() : defaultedNewName.getFile();
            if (Utilities.isPlatformWindows && destination.isFile()) {
                destination.delete();
            }
            if (source2.renameTo(destination)) {
                Pathname newTruename = (Pathname)Pathname.truename(defaultedNewName, true);
                return LispThread.currentThread().setValues(defaultedNewName, oldTruename, newTruename);
            }
            return Lisp.error(new FileError("Unable to rename " + oldTruename.princToString() + " to " + newName.princToString() + ".", oldTruename));
        }
    }

    @DocString(name="mkdir", args="pathname", returns="generalized-boolean", doc="Attempts to create directory at PATHNAME returning the success or failure.")
    private static class pf_mkdir
    extends Primitive {
        pf_mkdir() {
            super("mkdir", Lisp.PACKAGE_SYS, false, "pathname");
        }

        @Override
        public LispObject execute(LispObject arg) {
            Pathname defaultedPathname;
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname.isWild()) {
                Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
            }
            if ((defaultedPathname = Pathname.mergePathnames(pathname, Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue()), Lisp.NIL)).isURL() || defaultedPathname.isJar()) {
                return new FileError("Cannot mkdir with a " + (defaultedPathname.isURL() ? "URL" : "jar") + " Pathname.", defaultedPathname);
            }
            File file = defaultedPathname.getFile();
            return file.mkdir() ? Lisp.T : Lisp.NIL;
        }
    }

    @DocString(name="get-input-stream", args="pathname", doc="Returns a java.io.InputStream for resource denoted by PATHNAME.")
    private static final class pf_get_input_stream
    extends Primitive {
        pf_get_input_stream() {
            super(Symbol.GET_INPUT_STREAM, "pathname");
        }

        @Override
        public LispObject execute(LispObject pathname) {
            Pathname p = Lisp.coerceToPathname(pathname);
            return new JavaObject(p.getInputStream());
        }
    }

    @DocString(name="merge-pathnames", args="pathname &optional default-pathname default-version", returns="pathname", doc="Constructs a pathname from PATHNAME by filling in any unsupplied components\nwith the corresponding values from DEFAULT-PATHNAME and DEFAULT-VERSION.")
    static final class pf_merge_pathnames
    extends Primitive {
        pf_merge_pathnames() {
            super(Symbol.MERGE_PATHNAMES, "pathname &optional default-pathname default-version");
        }

        @Override
        public LispObject execute(LispObject arg) {
            Pathname pathname = Lisp.coerceToPathname(arg);
            Pathname defaultPathname = Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue());
            Symbol defaultVersion = Keyword.NEWEST;
            return Pathname.mergePathnames(pathname, defaultPathname, defaultVersion);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Pathname pathname = Lisp.coerceToPathname(first);
            Pathname defaultPathname = Lisp.coerceToPathname(second);
            Symbol defaultVersion = Keyword.NEWEST;
            return Pathname.mergePathnames(pathname, defaultPathname, defaultVersion);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Pathname pathname = Lisp.coerceToPathname(first);
            Pathname defaultPathname = Lisp.coerceToPathname(second);
            LispObject defaultVersion = third;
            return Pathname.mergePathnames(pathname, defaultPathname, defaultVersion);
        }
    }

    @DocString(name="%wild-pathname-p", args="pathname keyword", returns="generalized-boolean", doc="Predicate for determing whether PATHNAME contains wild components.\nKEYWORD, if non-nil, should be one of :directory, :host, :device,\n:name, :type, or :version indicating that only the specified component\nshould be checked for wildness.")
    static final class pf_wild_pathname_p
    extends Primitive {
        pf_wild_pathname_p() {
            super("%wild-pathname-p", Lisp.PACKAGE_SYS, true);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            LispObject value;
            Pathname pathname = Lisp.coerceToPathname(first);
            if (second == Lisp.NIL) {
                return pathname.isWild() ? Lisp.T : Lisp.NIL;
            }
            if (second == Keyword.DIRECTORY) {
                if (pathname.getDirectory() instanceof Cons) {
                    if (Lisp.memq(Keyword.WILD, pathname.getDirectory())) {
                        return Lisp.T;
                    }
                    if (Lisp.memq(Keyword.WILD_INFERIORS, pathname.getDirectory())) {
                        return Lisp.T;
                    }
                }
                return Lisp.NIL;
            }
            if (second == Keyword.HOST) {
                value = pathname.getHost();
            } else if (second == Keyword.DEVICE) {
                value = pathname.getDevice();
            } else if (second == Keyword.NAME) {
                value = pathname.getName();
            } else if (second == Keyword.TYPE) {
                value = pathname.getType();
            } else if (second == Keyword.VERSION) {
                value = pathname.getVersion();
            } else {
                return Lisp.program_error("Unrecognized keyword " + second.princToString() + ".");
            }
            if (value == Keyword.WILD || value == Keyword.WILD_INFERIORS) {
                return Lisp.T;
            }
            return Lisp.NIL;
        }
    }

    private static class pf_pathname_url_p
    extends Primitive {
        pf_pathname_url_p() {
            super("pathname-url-p", Lisp.PACKAGE_EXT, true, "pathname", "Predicate for whether PATHNAME references a URL.");
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof Pathname) {
                Pathname p = Lisp.coerceToPathname(arg);
                return p.isURL() ? Lisp.T : Lisp.NIL;
            }
            return Lisp.NIL;
        }
    }

    private static class pf_pathname_jar_p
    extends Primitive {
        pf_pathname_jar_p() {
            super("pathname-jar-p", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof Pathname) {
                Pathname p = Lisp.coerceToPathname(arg);
                return p.isJar() ? Lisp.T : Lisp.NIL;
            }
            return Lisp.NIL;
        }
    }

    @DocString(name="list-directory", args="directory &optional (resolve-symlinks nil)", returns="pathnames", doc="Lists the contents of DIRECTORY, optionally resolving symbolic links.")
    private static class pf_list_directory
    extends Primitive {
        pf_list_directory() {
            super("list-directory", Lisp.PACKAGE_SYS, true, "directory &optional (resolve-symlinks t)");
        }

        @Override
        public LispObject execute(LispObject arg) {
            return this.execute(arg, Lisp.T);
        }

        @Override
        public LispObject execute(LispObject arg, LispObject resolveSymlinks) {
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname instanceof LogicalPathname) {
                pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
            }
            LispObject result = Lisp.NIL;
            if (pathname.isJar()) {
                return JarPathname.listDirectory((JarPathname)pathname);
            }
            File f = pathname.getFile();
            if (f.isDirectory()) {
                try {
                    File[] files = f.listFiles();
                    if (files == null) {
                        return Lisp.error(new FileError("Unable to list directory " + pathname.princToString() + ".", pathname));
                    }
                    int i = files.length;
                    while (i-- > 0) {
                        File file = files[i];
                        String path = resolveSymlinks == Lisp.NIL ? file.getAbsolutePath() : file.getCanonicalPath();
                        if (file.isDirectory() && !path.endsWith("/")) {
                            path = path + "/";
                        }
                        Pathname p = Pathname.create(path);
                        result = new Cons(p, result);
                    }
                }
                catch (IOException e) {
                    return Lisp.error(new FileError("Unable to list directory " + pathname.princToString() + ".", pathname));
                }
                catch (SecurityException e) {
                    return Lisp.error(new FileError("Unable to list directory: " + e, pathname));
                }
            }
            return result;
        }
    }

    @DocString(name="user-homedir-pathname", args="&optional host", returns="pathname", doc="Determines the pathname that corresponds to the user's home directory.\nThe value returned is obtained from the JVM system propoerty 'user.home'.\nIf HOST is specified, returns NIL.")
    private static class pf_user_homedir_pathname
    extends Primitive {
        pf_user_homedir_pathname() {
            super("user-homedir-pathname", "&optional host");
        }

        @Override
        public LispObject execute(LispObject[] args) {
            switch (args.length) {
                case 0: {
                    String s = System.getProperty("user.home");
                    if (!s.endsWith(File.separator)) {
                        s = s.concat(File.separator);
                    }
                    return Pathname.create(s);
                }
                case 1: {
                    return Lisp.NIL;
                }
            }
            return Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 0, 1));
        }
    }

    @DocString(name="logical-pathname-p", args="object", returns="generalized-boolean", doc="Returns true if OBJECT is of type logical-pathname; otherwise, returns false.")
    private static class pf_logical_pathname_p
    extends Primitive {
        pf_logical_pathname_p() {
            super("logical-pathname-p", Lisp.PACKAGE_SYS, true, "object");
        }

        @Override
        public LispObject execute(LispObject arg) {
            return arg instanceof LogicalPathname ? Lisp.T : Lisp.NIL;
        }
    }

    @DocString(name="pathnamep", args="object", returns="generalized-boolean", doc="Returns true if OBJECT is of type pathname; otherwise, returns false.")
    private static class pf_pathnamep
    extends Primitive {
        pf_pathnamep() {
            super("pathnamep", "object");
        }

        @Override
        public LispObject execute(LispObject arg) {
            return arg instanceof Pathname ? Lisp.T : Lisp.NIL;
        }
    }

    @DocString(name="make-pathname", args="&key host device directory name type version defaults case", returns="pathname", doc="Constructs and returns a pathname from the supplied keyword arguments.")
    private static class pf_make_pathname
    extends Primitive {
        pf_make_pathname() {
            super("make-pathname", "&key host device directory name type version defaults case");
        }

        @Override
        public LispObject execute(LispObject[] args) {
            LispObject result = Pathname._makePathname(args);
            return result;
        }
    }

    @DocString(name="%parse-namestring", args="namestring host default-pathname", returns="pathname, position")
    private static class pf_parse_namestring
    extends Primitive {
        pf_parse_namestring() {
            super("%parse-namestring", Lisp.PACKAGE_SYS, false, "namestring host default-pathname");
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            LispThread thread = LispThread.currentThread();
            AbstractString namestring = Lisp.checkString(first);
            if (second == Lisp.NIL) {
                if ((third = Lisp.coerceToPathname(third)) instanceof LogicalPathname) {
                    second = ((LogicalPathname)third).getHost();
                } else {
                    return thread.setValues(Pathname.parseNamestring(namestring), namestring.LENGTH());
                }
            }
            Debug.assertTrue(second != Lisp.NIL);
            AbstractString host = Lisp.checkString(second);
            return thread.setValues(Pathname.parseNamestring(namestring, host), namestring.LENGTH());
        }
    }

    @DocString(name="pathname", args="pathspec", returns="pathname", doc="Returns the PATHNAME denoted by PATHSPEC.")
    private static class pf_pathname
    extends Primitive {
        pf_pathname() {
            super("pathname", "pathspec");
        }

        @Override
        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPathname(arg);
        }
    }

    @DocString(name="directory-namestring", args="pathname", returns="namestring", doc="Returns the NAMESTRING of directory porition of PATHNAME if it has one.")
    private static class pf_directory_namestring
    extends Primitive {
        pf_directory_namestring() {
            super("directory-namestring", "pathname");
        }

        @Override
        public LispObject execute(LispObject arg) {
            return new SimpleString(Lisp.coerceToPathname(arg).getDirectoryNamestring());
        }
    }

    @DocString(name="namestring", args="pathname", returns="namestring", doc="Returns the NAMESTRING of PATHNAME if it has one.\n\nIf PATHNAME is of type url-pathname or jar-pathname the NAMESTRING is encoded\naccording to the uri percent escape rules.\n\nSignals an error if PATHNAME lacks a printable NAMESTRING representation.\n")
    private static class pf_namestring
    extends Primitive {
        pf_namestring() {
            super("namestring", "pathname");
        }

        @Override
        public LispObject execute(LispObject arg) {
            Pathname pathname = Lisp.coerceToPathname(arg);
            String namestring = pathname.getNamestring();
            if (namestring == null) {
                Lisp.error(new SimpleError("Pathname has no namestring: " + pathname.princToString()));
            }
            return new SimpleString(namestring);
        }
    }

    @DocString(name="pathname-version", args="pathname", returns="version", doc="Return the version component of PATHNAME.")
    private static class pf_pathname_version
    extends Primitive {
        pf_pathname_version() {
            super("pathname-version", "pathname");
        }

        @Override
        public LispObject execute(LispObject arg) {
            return Lisp.coerceToPathname(arg).getVersion();
        }
    }

    @DocString(name="%pathname-type")
    private static class pf_pathname_type
    extends Primitive {
        pf_pathname_type() {
            super("%pathname-type", Lisp.PACKAGE_SYS, false);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname(first).getType();
        }
    }

    @DocString(name="%pathname-name")
    private static class pf_pathname_name
    extends Primitive {
        pf_pathname_name() {
            super("%pathname-name", Lisp.PACKAGE_SYS, false);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname(first).getName();
        }
    }

    @DocString(name="%pathname-directory")
    private static class pf_pathname_directory
    extends Primitive {
        pf_pathname_directory() {
            super("%pathname-directory", Lisp.PACKAGE_SYS, false);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname(first).getDirectory();
        }
    }

    @DocString(name="%pathname-device")
    private static class pf_pathname_device
    extends Primitive {
        pf_pathname_device() {
            super("%pathname-device", Lisp.PACKAGE_SYS, false);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname(first).getDevice();
        }
    }

    @DocString(name="%pathname-host")
    private static class pf_pathname_host
    extends Primitive {
        pf_pathname_host() {
            super("%pathname-host", Lisp.PACKAGE_SYS, false);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Pathname.checkCaseArgument(second);
            return Lisp.coerceToPathname(first).getHost();
        }
    }
}

