/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Base;
import org.apache.tools.ant.taskdefs.optional.perforce.SimpleP4OutputHandler;
import org.apache.tools.ant.types.FileSet;

public class P4Add
extends P4Base {
    private int changelist;
    private String addCmd = "";
    private Vector filesets = new Vector();
    private int cmdLength = 450;

    public void setCommandlength(int len) throws BuildException {
        if (len <= 0) {
            throw new BuildException("P4Add: Commandlength should be a positive number");
        }
        this.cmdLength = len;
    }

    public void setChangelist(int changelist) throws BuildException {
        if (changelist <= 0) {
            throw new BuildException("P4Add: Changelist# should be a positive number");
        }
        this.changelist = changelist;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void execute() throws BuildException {
        if (this.P4View != null) {
            this.addCmd = this.P4View;
        }
        this.P4CmdOpts = this.changelist > 0 ? "-c " + this.changelist : "";
        StringBuffer filelist = new StringBuffer();
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
            String[] srcFiles = ds.getIncludedFiles();
            if (srcFiles != null) {
                for (int j = 0; j < srcFiles.length; ++j) {
                    File f = new File(ds.getBasedir(), srcFiles[j]);
                    filelist.append(" ").append('\"').append(f.getAbsolutePath()).append('\"');
                    if (filelist.length() <= this.cmdLength) continue;
                    this.execP4Add(filelist);
                    filelist.setLength(0);
                }
                if (filelist.length() <= 0) continue;
                this.execP4Add(filelist);
                continue;
            }
            this.log("No files specified to add!", 1);
        }
    }

    private void execP4Add(StringBuffer list) {
        this.log("Execing add " + this.P4CmdOpts + " " + this.addCmd + list, 2);
        this.execP4Command("-s add " + this.P4CmdOpts + " " + this.addCmd + list, new SimpleP4OutputHandler(this));
    }
}

