/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.impl;

import edu.umd.marbl.mhap.impl.MatchResult;
import edu.umd.marbl.mhap.impl.MhapRuntimeException;
import edu.umd.marbl.mhap.impl.SequenceId;
import edu.umd.marbl.mhap.impl.SequenceSketch;
import edu.umd.marbl.mhap.impl.SequenceSketchStreamer;
import edu.umd.marbl.mhap.utils.ReadBuffer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractMatchSearch {
    private final AtomicLong matchesProcessed;
    protected final int numThreads;
    private final AtomicLong sequencesSearched;
    private final boolean storeResults;
    public static final int NUM_ELEMENTS_PER_OUTPUT = 20000;
    protected static final BufferedWriter STD_OUT_BUFFER = new BufferedWriter(new OutputStreamWriter(System.out), 0x800000);

    public AbstractMatchSearch(int numThreads, boolean storeResults) {
        this.numThreads = numThreads;
        this.storeResults = storeResults;
        this.matchesProcessed = new AtomicLong();
        this.sequencesSearched = new AtomicLong();
    }

    protected void addData(final SequenceSketchStreamer data, final boolean doReverseCompliment) {
        ExecutorService execSvc = Executors.newFixedThreadPool(this.numThreads);
        final AtomicInteger counter = new AtomicInteger();
        for (int iter = 0; iter < this.numThreads; ++iter) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        ReadBuffer buf = new ReadBuffer();
                        SequenceSketch seqHashes = data.dequeue(!doReverseCompliment, buf);
                        while (seqHashes != null) {
                            AbstractMatchSearch.this.addSequence(seqHashes);
                            int currCount = counter.incrementAndGet();
                            if (currCount % 5000 == 0) {
                                System.err.println("Current # sequences stored: " + currCount + "...");
                            }
                            seqHashes = data.dequeue(false, buf);
                        }
                    }
                    catch (IOException e) {
                        throw new MhapRuntimeException(e);
                    }
                }
            };
            execSvc.execute(task);
        }
        execSvc.shutdown();
        try {
            execSvc.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            execSvc.shutdownNow();
            throw new MhapRuntimeException("Unable to finish all tasks.");
        }
    }

    protected abstract boolean addSequence(SequenceSketch var1);

    public ArrayList<MatchResult> findMatches() {
        ExecutorService execSvc = Executors.newFixedThreadPool(this.numThreads);
        final ArrayList<MatchResult> combinedList = new ArrayList<MatchResult>();
        final ConcurrentLinkedQueue<SequenceId> seqList = new ConcurrentLinkedQueue<SequenceId>(this.getStoredForwardSequenceIds());
        for (int iter = 0; iter < this.numThreads; ++iter) {
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList<MatchResult> localMatches = new ArrayList<MatchResult>();
                    SequenceId nextSequence = (SequenceId)seqList.poll();
                    while (nextSequence != null) {
                        SequenceSketch sequenceHashes = AbstractMatchSearch.this.getStoredSequenceHash(nextSequence);
                        localMatches.addAll(AbstractMatchSearch.this.findMatches(sequenceHashes, true));
                        AbstractMatchSearch.this.sequencesSearched.getAndIncrement();
                        nextSequence = (SequenceId)seqList.poll();
                        if (nextSequence != null && localMatches.size() < 20000) continue;
                        AbstractMatchSearch.this.matchesProcessed.getAndAdd(localMatches.size());
                        if (AbstractMatchSearch.this.storeResults) {
                            ArrayList arrayList = combinedList;
                            synchronized (arrayList) {
                                combinedList.addAll(localMatches);
                            }
                        } else {
                            AbstractMatchSearch.this.outputResults(localMatches);
                        }
                        localMatches.clear();
                    }
                }
            };
            execSvc.execute(task);
        }
        execSvc.shutdown();
        try {
            execSvc.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            execSvc.shutdownNow();
            throw new MhapRuntimeException("Unable to finish all tasks.");
        }
        this.flushOutput();
        return combinedList;
    }

    protected abstract List<MatchResult> findMatches(SequenceSketch var1, boolean var2);

    public ArrayList<MatchResult> findMatches(final SequenceSketchStreamer data) throws IOException {
        ExecutorService execSvc = Executors.newFixedThreadPool(this.numThreads);
        final ArrayList<MatchResult> combinedList = new ArrayList<MatchResult>();
        for (int iter = 0; iter < this.numThreads; ++iter) {
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList<MatchResult> localMatches = new ArrayList<MatchResult>();
                    try {
                        ReadBuffer buf = new ReadBuffer();
                        SequenceSketch sequenceHashes = data.dequeue(true, buf);
                        while (sequenceHashes != null) {
                            localMatches.addAll(AbstractMatchSearch.this.findMatches(sequenceHashes, false));
                            AbstractMatchSearch.this.sequencesSearched.getAndIncrement();
                            sequenceHashes = data.dequeue(true, buf);
                            if (sequenceHashes != null && localMatches.size() < 20000) continue;
                            AbstractMatchSearch.this.matchesProcessed.getAndAdd(localMatches.size());
                            if (AbstractMatchSearch.this.storeResults) {
                                ArrayList arrayList = combinedList;
                                synchronized (arrayList) {
                                    combinedList.addAll(localMatches);
                                }
                            } else {
                                AbstractMatchSearch.this.outputResults(localMatches);
                            }
                            localMatches.clear();
                        }
                    }
                    catch (IOException e) {
                        throw new MhapRuntimeException(e);
                    }
                }
            };
            execSvc.execute(task);
        }
        execSvc.shutdown();
        try {
            execSvc.awaitTermination(365L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            execSvc.shutdownNow();
            throw new MhapRuntimeException("Unable to finish all tasks.");
        }
        this.flushOutput();
        return combinedList;
    }

    protected void flushOutput() {
        try {
            STD_OUT_BUFFER.flush();
        }
        catch (IOException e) {
            throw new MhapRuntimeException(e);
        }
    }

    public long getMatchesProcessed() {
        return this.matchesProcessed.get();
    }

    public long getNumberSequencesSearched() {
        return this.sequencesSearched.get();
    }

    public abstract List<SequenceId> getStoredForwardSequenceIds();

    public abstract SequenceSketch getStoredSequenceHash(SequenceId var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputResults(List<MatchResult> matches) {
        if (this.storeResults || matches.isEmpty()) {
            return;
        }
        try {
            BufferedWriter bufferedWriter = STD_OUT_BUFFER;
            synchronized (bufferedWriter) {
                for (MatchResult currResult : matches) {
                    STD_OUT_BUFFER.write(currResult.toString());
                    STD_OUT_BUFFER.newLine();
                }
                STD_OUT_BUFFER.flush();
            }
        }
        catch (IOException e) {
            throw new MhapRuntimeException(e);
        }
    }

    public abstract int size();
}

