/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.SortField;

public final class SimpleBindings
extends Bindings {
    final Map<String, Object> map = new HashMap<String, Object>();

    public void add(SortField sortField) {
        this.map.put(sortField.getField(), sortField);
    }

    public void add(String name, DoubleValuesSource source) {
        this.map.put(name, source);
    }

    public void add(String name, Expression expression) {
        this.map.put(name, expression);
    }

    @Override
    public DoubleValuesSource getDoubleValuesSource(String name) {
        Object o = this.map.get(name);
        if (o == null) {
            throw new IllegalArgumentException("Invalid reference '" + name + "'");
        }
        if (o instanceof Expression) {
            return ((Expression)o).getDoubleValuesSource(this);
        }
        if (o instanceof DoubleValuesSource) {
            return (DoubleValuesSource)o;
        }
        SortField field = (SortField)o;
        switch (field.getType()) {
            case INT: {
                return DoubleValuesSource.fromIntField((String)field.getField());
            }
            case LONG: {
                return DoubleValuesSource.fromLongField((String)field.getField());
            }
            case FLOAT: {
                return DoubleValuesSource.fromFloatField((String)field.getField());
            }
            case DOUBLE: {
                return DoubleValuesSource.fromDoubleField((String)field.getField());
            }
            case SCORE: {
                return DoubleValuesSource.SCORES;
            }
        }
        throw new UnsupportedOperationException();
    }

    public void validate() {
        for (Object o : this.map.values()) {
            if (!(o instanceof Expression)) continue;
            Expression expr = (Expression)o;
            try {
                expr.getDoubleValuesSource(this);
            }
            catch (StackOverflowError e) {
                throw new IllegalArgumentException("Recursion Error: Cycle detected originating in (" + expr.sourceText + ")");
            }
        }
    }
}

