/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.transform;

import java.io.IOException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xpack.core.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.core.watcher.transform.Transform;
import org.elasticsearch.xpack.core.watcher.transform.TransformFactory;
import org.elasticsearch.xpack.core.watcher.transform.TransformRegistry;
import org.elasticsearch.xpack.watcher.input.InputFactory;
import org.elasticsearch.xpack.watcher.input.transform.ExecutableTransformInput;
import org.elasticsearch.xpack.watcher.input.transform.TransformInput;

public final class TransformInputFactory
extends InputFactory<TransformInput, TransformInput.Result, ExecutableTransformInput> {
    private final TransformRegistry transformRegistry;

    public TransformInputFactory(TransformRegistry transformRegistry) {
        this.transformRegistry = transformRegistry;
    }

    @Override
    public String type() {
        return "transform";
    }

    @Override
    public TransformInput parseInput(String watchId, XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), () -> ((XContentParser)parser).getTokenLocation());
        Transform transform = this.transformRegistry.parse(watchId, parser).transform();
        return new TransformInput(transform);
    }

    @Override
    public ExecutableTransformInput createExecutable(TransformInput input) {
        Transform transform = input.getTransform();
        TransformFactory factory = this.transformRegistry.factory(transform.type());
        ExecutableTransform executableTransform = factory.createExecutable(transform);
        return new ExecutableTransformInput(input, executableTransform);
    }
}

