/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.annotations;

import java.io.IOException;
import java.util.SortedMap;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.annotations.Annotation;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class AnnotationIndex {
    public static final String READ_ALIAS_NAME = ".ml-annotations-read";
    public static final String WRITE_ALIAS_NAME = ".ml-annotations-write";
    public static final String INDEX_NAME = ".ml-annotations-6";

    public static void createAnnotationsIndexIfNecessary(Settings settings, Client client, ClusterState state, ActionListener<Boolean> finalListener) {
        ActionListener createAliasListener = ActionListener.wrap(success -> {
            IndicesAliasesRequest request = (IndicesAliasesRequest)client.admin().indices().prepareAliases().addAlias(INDEX_NAME, READ_ALIAS_NAME).addAlias(INDEX_NAME, WRITE_ALIAS_NAME).request();
            ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(r -> finalListener.onResponse((Object)r.isAcknowledged()), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).aliases(arg_0, arg_1));
        }, arg_0 -> finalListener.onFailure(arg_0));
        SortedMap mlLookup = state.getMetaData().getAliasAndIndexLookup().tailMap(".ml");
        if (!mlLookup.isEmpty() && mlLookup.firstKey().startsWith(".ml")) {
            if (!mlLookup.containsKey(INDEX_NAME)) {
                TimeValue delayedNodeTimeOutSetting = (Boolean)MachineLearningField.AUTODETECT_PROCESS.get(settings) != false ? (TimeValue)UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.get(settings) : TimeValue.ZERO;
                CreateIndexRequest createIndexRequest = new CreateIndexRequest(INDEX_NAME);
                try (XContentBuilder annotationsMapping = AnnotationIndex.annotationsMapping();){
                    createIndexRequest.mapping("doc", annotationsMapping);
                    createIndexRequest.settings(Settings.builder().put("index.auto_expand_replicas", "0-1").put("index.number_of_shards", "1").put(UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.getKey(), delayedNodeTimeOutSetting));
                    ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", createIndexRequest, ActionListener.wrap(r -> createAliasListener.onResponse((Object)r.isAcknowledged()), e -> {
                        if (e instanceof ResourceAlreadyExistsException) {
                            createAliasListener.onResponse((Object)true);
                        } else {
                            finalListener.onFailure(e);
                        }
                    }), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).create(arg_0, arg_1));
                }
                catch (IOException e2) {
                    finalListener.onFailure((Exception)e2);
                }
                return;
            }
            if (!mlLookup.containsKey(READ_ALIAS_NAME) || !mlLookup.containsKey(WRITE_ALIAS_NAME)) {
                createAliasListener.onResponse((Object)true);
                return;
            }
        }
        finalListener.onResponse((Object)false);
    }

    public static XContentBuilder annotationsMapping() throws IOException {
        return XContentFactory.jsonBuilder().startObject().startObject("doc").startObject("properties").startObject(Annotation.ANNOTATION.getPreferredName()).field("type", "text").endObject().startObject(Annotation.CREATE_TIME.getPreferredName()).field("type", "date").endObject().startObject(Annotation.CREATE_USERNAME.getPreferredName()).field("type", "keyword").endObject().startObject(Annotation.TIMESTAMP.getPreferredName()).field("type", "date").endObject().startObject(Annotation.END_TIMESTAMP.getPreferredName()).field("type", "date").endObject().startObject(Job.ID.getPreferredName()).field("type", "keyword").endObject().startObject(Annotation.MODIFIED_TIME.getPreferredName()).field("type", "date").endObject().startObject(Annotation.MODIFIED_USERNAME.getPreferredName()).field("type", "keyword").endObject().startObject(Annotation.TYPE.getPreferredName()).field("type", "keyword").endObject().endObject().endObject().endObject();
    }
}

