/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.raw.border;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.defaults.AbstractDockable;

public class DockablePanel
extends JPanel {
    private String title;
    private JPanel dragInit = new JPanel();
    private Dockable dockableImpl;

    public DockablePanel(String title) {
        super(new BorderLayout());
        this.dragInit.setBackground(this.getBackground().darker());
        this.dragInit.setPreferredSize(new Dimension(10, 10));
        this.add((Component)this.dragInit, "East");
        this.setBorder(new TitledBorder(title));
        this.setTitle(title);
        this.dockableImpl = new DockableImpl();
        DockingManager.registerDockable(this.dockableImpl);
    }

    private void setTitle(String title) {
        this.title = title;
    }

    Dockable getDockable() {
        return this.dockableImpl;
    }

    public String getTitle() {
        return this.title == null ? null : this.title.trim();
    }

    private class DockableImpl
    extends AbstractDockable {
        private DockableImpl() {
            super("dockable." + DockablePanel.this.getTitle());
            this.getDragSources().add(DockablePanel.this.dragInit);
            this.setTabText(DockablePanel.this.getTitle());
        }

        public Component getComponent() {
            return DockablePanel.this;
        }
    }
}

