/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.rtp.RTCPTransmitter;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.util.RTPMediaThread;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Random;

public class RTCPReporter
implements Runnable {
    RTCPTransmitter transmit;
    SSRCCache cache;
    RTPMediaThread reportthread;
    Random myrand;
    boolean restart = false;
    boolean closed = false;
    InetAddress host;
    String cname;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    static /* synthetic */ Class class$com$sun$media$rtp$util$RTPMediaThread;

    public RTCPReporter(SSRCCache cache, RTCPTransmitter t) {
        this.cache = cache;
        this.setTransmitter(t);
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                if (permission.endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = jdk12CreateThreadRunnableAction.cons;
                this.reportthread = (RTPMediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$rtp$util$RTPMediaThread == null ? (class$com$sun$media$rtp$util$RTPMediaThread = RTCPReporter.class$("com.sun.media.rtp.util.RTPMediaThread")) : class$com$sun$media$rtp$util$RTPMediaThread, this));
                this.reportthread.setName("RTCP Reporter");
                cons = jdk12PriorityAction.cons;
                jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(this.reportthread, new Integer(MediaThread.getControlPriority())));
            }
            catch (Exception exception) {}
        } else {
            this.reportthread = new RTPMediaThread(this, "RTCP Reporter");
            this.reportthread.useControlPriority();
        }
        this.reportthread.setDaemon(true);
        this.reportthread.start();
    }

    public void setTransmitter(RTCPTransmitter t) {
        this.transmit = t;
    }

    public void close(String reason) {
        RTPMediaThread rTPMediaThread = this.reportthread;
        synchronized (rTPMediaThread) {
            this.closed = true;
            this.reportthread.notify();
        }
        this.releasessrc(reason);
        this.transmit.close();
    }

    public void releasessrc(String reason) {
        this.transmit.bye(reason);
        this.transmit.ssrcInfo.setOurs(false);
        this.transmit.ssrcInfo = null;
    }

    public void run() {
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        if (this.restart) {
            this.restart = false;
        }
        while (true) {
            double delay = this.cache.calcReportInterval(this.cache.ourssrc.sender, false);
            RTPMediaThread rTPMediaThread = this.reportthread;
            synchronized (rTPMediaThread) {
                try {
                    this.reportthread.wait((long)delay);
                }
                catch (InterruptedException e3) {
                    Log.dumpStack(e3);
                }
            }
            if (this.closed) {
                return;
            }
            if (!this.restart) {
                this.transmit.report();
                continue;
            }
            this.restart = false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

