/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.launcher.daemon.server.DaemonStopState;
import org.gradle.launcher.daemon.server.api.DaemonState;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.gradle.launcher.daemon.server.api.DaemonStoppedException;
import org.gradle.launcher.daemon.server.api.DaemonUnavailableException;

public class DaemonStateCoordinator
implements Stoppable,
DaemonStateControl {
    public static final String DAEMON_WILL_STOP_MESSAGE = "Daemon will be stopped at the end of the build ";
    public static final String DAEMON_STOPPING_IMMEDIATELY_MESSAGE = "Daemon is stopping immediately ";
    private static final Logger LOGGER = Logging.getLogger(DaemonStateCoordinator.class);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final long cancelTimeoutMs;
    private DaemonState state = DaemonState.Idle;
    private final Timer idleTimer;
    private String currentCommandExecution;
    private Object result;
    private String stopReason;
    private volatile DefaultBuildCancellationToken cancellationToken;
    private final ManagedExecutor executor;
    private final Runnable onStartCommand;
    private final Runnable onFinishCommand;
    private final Runnable onCancelCommand;

    public DaemonStateCoordinator(ExecutorFactory executorFactory, Runnable onStartCommand, Runnable onFinishCommand, Runnable onCancelCommand) {
        this(executorFactory, onStartCommand, onFinishCommand, onCancelCommand, 10000L);
    }

    DaemonStateCoordinator(ExecutorFactory executorFactory, Runnable onStartCommand, Runnable onFinishCommand, Runnable onCancelCommand, long cancelTimeoutMs) {
        this.executor = executorFactory.create("Daemon worker");
        this.onStartCommand = onStartCommand;
        this.onFinishCommand = onFinishCommand;
        this.onCancelCommand = onCancelCommand;
        this.cancelTimeoutMs = cancelTimeoutMs;
        this.idleTimer = Time.startTimer();
        this.updateCancellationToken();
    }

    private void setState(DaemonState state) {
        this.state = state;
        this.condition.signalAll();
    }

    DaemonStopState awaitStop() {
        this.lock.lock();
        try {
            while (true) {
                switch (this.state) {
                    case Idle: 
                    case Busy: {
                        LOGGER.debug("daemon is running. Sleeping until state changes.");
                        this.condition.await();
                        break;
                    }
                    case Canceled: {
                        LOGGER.debug("cancel requested.");
                        DaemonStopState state = this.cancelNow();
                        if (state == null) break;
                        DaemonStopState daemonStopState = state;
                        return daemonStopState;
                    }
                    case Broken: {
                        throw new IllegalStateException("This daemon is in a broken state.");
                    }
                    case StopRequested: {
                        LOGGER.debug("daemon stop has been requested. Sleeping until state changes.");
                        this.condition.await();
                        break;
                    }
                    case Stopped: {
                        LOGGER.debug("daemon has stopped.");
                        DaemonStopState daemonStopState = DaemonStopState.Clean;
                        return daemonStopState;
                    }
                    case ForceStopped: {
                        LOGGER.debug("daemon has been force stopped.");
                        DaemonStopState daemonStopState = DaemonStopState.Forced;
                        return daemonStopState;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void requestStop(String reason) {
        this.lock.lock();
        try {
            if (this.state != DaemonState.StopRequested && this.state != DaemonState.Stopped && this.state != DaemonState.ForceStopped) {
                LOGGER.lifecycle(DAEMON_WILL_STOP_MESSAGE + reason);
                if (this.state == DaemonState.Busy) {
                    LOGGER.debug("Stop as soon as idle requested. The daemon is busy");
                    this.beginStopping();
                } else {
                    this.stopNow(reason);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void requestForcefulStop(String reason) {
        LOGGER.lifecycle(DAEMON_STOPPING_IMMEDIATELY_MESSAGE + reason);
        this.stopNow(reason);
    }

    public void stop() {
        this.stopNow("service stop");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stopNow(String reason) {
        this.lock.lock();
        try {
            switch (this.state) {
                case Idle: {
                    LOGGER.debug("Marking daemon stopped due to {}. The daemon is not running a build", (Object)reason);
                    this.stopReason = reason;
                    this.setState(DaemonState.Stopped);
                    return;
                }
                case Busy: 
                case Canceled: 
                case Broken: 
                case StopRequested: {
                    LOGGER.debug("Marking daemon stopped due to {}. The daemon is running a build", (Object)reason);
                    this.stopReason = reason;
                    this.setState(DaemonState.ForceStopped);
                    return;
                }
                case Stopped: 
                case ForceStopped: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Daemon is in unexpected state: " + this.state);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void beginStopping() {
        switch (this.state) {
            case Idle: 
            case Busy: 
            case Canceled: 
            case Broken: {
                this.setState(DaemonState.StopRequested);
                break;
            }
            case StopRequested: 
            case Stopped: 
            case ForceStopped: {
                break;
            }
            default: {
                throw new IllegalStateException("Daemon is in unexpected state: " + this.state);
            }
        }
    }

    @Override
    public BuildCancellationToken getCancellationToken() {
        return this.cancellationToken;
    }

    private void updateCancellationToken() {
        this.cancellationToken = new DefaultBuildCancellationToken();
        this.cancellationToken.addCallback(this.onCancelCommand);
    }

    @Override
    public void requestCancel() {
        this.lock.lock();
        try {
            if (this.state == DaemonState.Busy) {
                this.setState(DaemonState.Canceled);
            } else if (this.state == DaemonState.StopRequested) {
                this.requestForcefulStop("the build was canceled after a stop was requested");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void cancelBuild() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private DaemonStopState cancelNow() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void runCommand(Runnable command, String commandDisplayName) throws DaemonUnavailableException {
        this.onStartCommand(commandDisplayName);
        try {
            this.executor.execute(() -> {
                try {
                    command.run();
                    this.onCommandSuccessful();
                }
                catch (Throwable t) {
                    this.onCommandFailed(t);
                }
            });
            this.waitForCommandCompletion();
        }
        finally {
            this.onFinishCommand();
        }
    }

    private void waitForCommandCompletion() {
        this.lock.lock();
        try {
            while ((this.state == DaemonState.Busy || this.state == DaemonState.Canceled || this.state == DaemonState.StopRequested) && this.result == null) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            LOGGER.debug("Command execution: finished waiting for {}. Result {} with state {}", new Object[]{this.currentCommandExecution, this.result, this.state});
            if (this.result instanceof Throwable) {
                throw UncheckedException.throwAsUncheckedException((Throwable)((Throwable)this.result));
            }
            if (this.result != null) {
                return;
            }
            switch (this.state) {
                case Stopped: 
                case ForceStopped: {
                    throw new DaemonStoppedException(this.stopReason);
                }
                case Broken: {
                    throw new DaemonUnavailableException("This daemon is broken and will stop.");
                }
            }
            throw new IllegalStateException("Daemon is in unexpected state: " + this.state);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onCommandFailed(Throwable failure) {
        this.lock.lock();
        try {
            this.result = failure;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onCommandSuccessful() {
        this.lock.lock();
        try {
            this.result = this;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onStartCommand(String commandDisplayName) {
        this.lock.lock();
        try {
            switch (this.state) {
                case Broken: {
                    throw new DaemonUnavailableException("This daemon is in a broken state and will stop.");
                }
                case StopRequested: {
                    throw new DaemonUnavailableException("This daemon is currently stopping.");
                }
                case Stopped: 
                case ForceStopped: {
                    throw new DaemonUnavailableException("This daemon has stopped.");
                }
                case Busy: 
                case Canceled: {
                    throw new DaemonUnavailableException(String.format("This daemon is currently executing: %s", this.currentCommandExecution));
                }
            }
            LOGGER.debug("Command execution: started {} after {} minutes of idle", (Object)commandDisplayName, (Object)this.getIdleMinutes());
            try {
                this.setState(DaemonState.Busy);
                this.onStartCommand.run();
                this.currentCommandExecution = commandDisplayName;
                this.result = null;
                this.updateActivityTimestamp();
                this.updateCancellationToken();
                this.condition.signalAll();
            }
            catch (Throwable throwable) {
                this.setState(DaemonState.Broken);
                throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onFinishCommand() {
        this.lock.lock();
        try {
            LOGGER.debug("Command execution: completed {}", (Object)this.currentCommandExecution);
            this.currentCommandExecution = null;
            this.result = null;
            this.stopReason = null;
            this.updateActivityTimestamp();
            switch (this.state) {
                case Idle: 
                case Busy: 
                case Canceled: {
                    try {
                        this.onFinishCommand.run();
                        this.setState(DaemonState.Idle);
                        return;
                    }
                    catch (Throwable throwable) {
                        this.setState(DaemonState.Broken);
                        throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
                    }
                }
                case StopRequested: {
                    this.setState(DaemonState.Idle);
                    this.stopNow("command completed and stop requested");
                    return;
                }
                case Stopped: 
                case ForceStopped: {
                    return;
                }
                default: {
                    throw new IllegalStateException("Daemon is in unexpected state: " + this.state);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateActivityTimestamp() {
        LOGGER.debug("resetting idle timer");
        this.idleTimer.reset();
    }

    private double getIdleMinutes() {
        this.lock.lock();
        try {
            double d = (double)this.idleTimer.getElapsedMillis() / 1000.0 / 60.0;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getIdleMillis() {
        if (this.state == DaemonState.Idle) {
            return this.idleTimer.getElapsedMillis();
        }
        return 0L;
    }

    boolean isWillRefuseNewCommands() {
        return this.state != DaemonState.Idle && this.state != DaemonState.Busy;
    }

    @Override
    public DaemonState getState() {
        return this.state;
    }
}

