/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.windows;

import com.jidesoft.plaf.windows.TMSchema;
import com.jidesoft.plaf.windows.XPStyle;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIClientPropertyKey;
import javax.swing.UIManager;
import sun.awt.AppContext;
import sun.security.action.GetBooleanAction;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class AnimationController
implements ActionListener,
PropertyChangeListener {
    private static final boolean VISTA_ANIMATION_DISABLED = AccessController.doPrivileged(new GetBooleanAction("swing.disablevistaanimation"));
    private static final Object ANIMATION_CONTROLLER_KEY = new StringBuilder("ANIMATION_CONTROLLER_KEY");
    private final Map<JComponent, Map<TMSchema.Part, AnimationState>> animationStateMap = new WeakHashMap<JComponent, Map<TMSchema.Part, AnimationState>>();
    private final Timer timer = new Timer(33, this);

    private static synchronized AnimationController getAnimationController() {
        AppContext appContext = AppContext.getAppContext();
        Object obj = appContext.get(ANIMATION_CONTROLLER_KEY);
        if (obj == null) {
            obj = new AnimationController();
            appContext.put(ANIMATION_CONTROLLER_KEY, obj);
        }
        return (AnimationController)obj;
    }

    private AnimationController() {
        this.timer.setRepeats(true);
        this.timer.setCoalesce(true);
        UIManager.addPropertyChangeListener(this);
    }

    private static void triggerAnimation(JComponent c, TMSchema.Part part, TMSchema.State newState) {
        if (c instanceof JTabbedPane || part == TMSchema.Part.TP_BUTTON) {
            return;
        }
        AnimationController controller = AnimationController.getAnimationController();
        TMSchema.State oldState = controller.getState(c, part);
        if (oldState != newState) {
            controller.putState(c, part, newState);
            if (newState == TMSchema.State.DEFAULTED) {
                oldState = TMSchema.State.HOT;
            }
            if (oldState != null) {
                long duration = newState == TMSchema.State.DEFAULTED ? 1000L : XPStyle.getXP().getThemeTransitionDuration(c, part, AnimationController.normalizeState(oldState), AnimationController.normalizeState(newState), TMSchema.Prop.TRANSITIONDURATIONS);
                controller.startAnimation(c, part, oldState, newState, duration);
            }
        }
    }

    private static TMSchema.State normalizeState(TMSchema.State state) {
        TMSchema.State rv;
        switch (state) {
            case DOWNPRESSED: 
            case LEFTPRESSED: 
            case RIGHTPRESSED: {
                rv = TMSchema.State.UPPRESSED;
                break;
            }
            case DOWNDISABLED: 
            case LEFTDISABLED: 
            case RIGHTDISABLED: {
                rv = TMSchema.State.UPDISABLED;
                break;
            }
            case DOWNHOT: 
            case LEFTHOT: 
            case RIGHTHOT: {
                rv = TMSchema.State.UPHOT;
                break;
            }
            case DOWNNORMAL: 
            case LEFTNORMAL: 
            case RIGHTNORMAL: {
                rv = TMSchema.State.UPNORMAL;
                break;
            }
            default: {
                rv = state;
            }
        }
        return rv;
    }

    private synchronized TMSchema.State getState(JComponent component, TMSchema.Part part) {
        TMSchema.State rv = null;
        Object tmpObject = component.getClientProperty(PartUIClientPropertyKey.getKey(part));
        if (tmpObject instanceof TMSchema.State) {
            rv = (TMSchema.State)((Object)tmpObject);
        }
        return rv;
    }

    private synchronized void putState(JComponent component, TMSchema.Part part, TMSchema.State state) {
        component.putClientProperty(PartUIClientPropertyKey.getKey(part), (Object)state);
    }

    private synchronized void startAnimation(JComponent component, TMSchema.Part part, TMSchema.State startState, TMSchema.State endState, long millis) {
        boolean isForwardAndReverse = false;
        if (endState == TMSchema.State.DEFAULTED) {
            isForwardAndReverse = true;
        }
        Map<TMSchema.Part, AnimationState> map = this.animationStateMap.get(component);
        if (millis <= 0L) {
            if (map != null) {
                map.remove((Object)part);
                if (map.size() == 0) {
                    this.animationStateMap.remove(component);
                }
            }
            return;
        }
        if (map == null) {
            map = new EnumMap<TMSchema.Part, AnimationState>(TMSchema.Part.class);
            this.animationStateMap.put(component, map);
        }
        map.put(part, new AnimationState(startState, millis, isForwardAndReverse));
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paintSkin(JComponent component, XPStyle.Skin skin, Graphics g, int dx, int dy, int dw, int dh, TMSchema.State state) {
        AnimationController controller;
        if (VISTA_ANIMATION_DISABLED) {
            skin.paintSkinRaw(g, dx, dy, dw, dh, state);
            return;
        }
        AnimationController.triggerAnimation(component, skin.part, state);
        AnimationController animationController = controller = AnimationController.getAnimationController();
        synchronized (animationController) {
            AnimationState animationState = null;
            Map<TMSchema.Part, AnimationState> map = controller.animationStateMap.get(component);
            if (map != null) {
                animationState = map.get((Object)skin.part);
            }
            if (animationState != null) {
                animationState.paintSkin(skin, g, dx, dy, dw, dh, state);
            } else {
                skin.paintSkinRaw(g, dx, dy, dw, dh, state);
            }
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent e) {
        if ("lookAndFeel" == e.getPropertyName() && !(e.getNewValue() instanceof WindowsLookAndFeel)) {
            this.dispose();
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        ArrayList<JComponent> componentsToRemove = null;
        ArrayList<TMSchema.Part> partsToRemove = null;
        for (JComponent component : this.animationStateMap.keySet()) {
            component.repaint();
            if (partsToRemove != null) {
                partsToRemove.clear();
            }
            Map<TMSchema.Part, AnimationState> map = this.animationStateMap.get(component);
            if (!component.isShowing() || map == null || map.size() == 0) {
                if (componentsToRemove == null) {
                    componentsToRemove = new ArrayList<JComponent>();
                }
                componentsToRemove.add(component);
                continue;
            }
            for (TMSchema.Part part : map.keySet()) {
                if (!map.get((Object)part).isDone()) continue;
                if (partsToRemove == null) {
                    partsToRemove = new ArrayList<TMSchema.Part>();
                }
                partsToRemove.add(part);
            }
            if (partsToRemove == null) continue;
            if (partsToRemove.size() == map.size()) {
                if (componentsToRemove == null) {
                    componentsToRemove = new ArrayList();
                }
                componentsToRemove.add(component);
                continue;
            }
            for (TMSchema.Part part : partsToRemove) {
                map.remove((Object)part);
            }
        }
        if (componentsToRemove != null) {
            for (JComponent component : componentsToRemove) {
                this.animationStateMap.remove(component);
            }
        }
        if (this.animationStateMap.size() == 0) {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dispose() {
        this.timer.stop();
        UIManager.removePropertyChangeListener(this);
        Class<AnimationController> clazz = AnimationController.class;
        synchronized (AnimationController.class) {
            AppContext.getAppContext().put(ANIMATION_CONTROLLER_KEY, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class PartUIClientPropertyKey
    implements UIClientPropertyKey {
        private static final Map<TMSchema.Part, PartUIClientPropertyKey> map = new EnumMap<TMSchema.Part, PartUIClientPropertyKey>(TMSchema.Part.class);
        private final TMSchema.Part part;

        static synchronized PartUIClientPropertyKey getKey(TMSchema.Part part) {
            PartUIClientPropertyKey rv = map.get((Object)part);
            if (rv == null) {
                rv = new PartUIClientPropertyKey(part);
                map.put(part, rv);
            }
            return rv;
        }

        private PartUIClientPropertyKey(TMSchema.Part part) {
            this.part = part;
        }

        public String toString() {
            return this.part.toString();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class AnimationState {
        private final TMSchema.State startState;
        private final long duration;
        private long startTime;
        private boolean isForward = true;
        private boolean isForwardAndReverse;
        private float progress;

        AnimationState(TMSchema.State startState, long milliseconds, boolean isForwardAndReverse) {
            assert (startState != null && milliseconds > 0L);
            assert (SwingUtilities.isEventDispatchThread());
            this.startState = startState;
            this.duration = milliseconds * 1000000L;
            this.startTime = System.nanoTime();
            this.isForwardAndReverse = isForwardAndReverse;
            this.progress = 0.0f;
        }

        private void updateProgress() {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.isDone()) {
                return;
            }
            long currentTime = System.nanoTime();
            this.progress = (float)(currentTime - this.startTime) / (float)this.duration;
            this.progress = Math.max(this.progress, 0.0f);
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
                if (this.isForwardAndReverse) {
                    this.startTime = currentTime;
                    this.progress = 0.0f;
                    this.isForward = !this.isForward;
                }
            }
        }

        void paintSkin(XPStyle.Skin skin, Graphics _g, int dx, int dy, int dw, int dh, TMSchema.State state) {
            assert (SwingUtilities.isEventDispatchThread());
            this.updateProgress();
            if (!this.isDone()) {
                Graphics2D g = (Graphics2D)_g.create();
                skin.paintSkinRaw(g, dx, dy, dw, dh, this.startState);
                float alpha = this.isForward ? this.progress : 1.0f - this.progress;
                g.setComposite(AlphaComposite.SrcOver.derive(alpha));
                skin.paintSkinRaw(g, dx, dy, dw, dh, state);
                g.dispose();
            } else {
                skin.paintSkinRaw(_g, dx, dy, dw, dh, state);
            }
        }

        boolean isDone() {
            assert (SwingUtilities.isEventDispatchThread());
            return this.progress >= 1.0f;
        }
    }
}

