/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.consumer.OldConsumer;
import kafka.consumer.Whitelist;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.easymock.EasyMock;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001!2A!\u0001\u0002\u0001\u000f\t)B*[:u\u0007>t7/^7fe\u001e\u0013x.\u001e9UKN$(BA\u0002\u0005\u0003\u0015\tG-\\5o\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u00031\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e)\u0016\u001cH\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\u0006#\u0001!\tAE\u0001\u001ai\u0016\u001cH\u000fT5ti>cGmQ8ogVlWM]$s_V\u00048\u000fF\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0011)f.\u001b;)\u0005AQ\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015QWO\\5u\u0015\u0005y\u0012aA8sO&\u0011\u0011\u0005\b\u0002\u0005)\u0016\u001cH\u000fC\u0003$\u0001\u0011\u0005!#\u0001\u0011uKN$H*[:u\u000fJ|W\u000f],ji\"tu.\u0012=jgRLgnZ$s_V\u0004\bF\u0001\u0012\u001b\u0011\u00151\u0003\u0001\"\u0001\u0013\u0003Y!Xm\u001d;MSN$8i\u001c8tk6,'o\u0012:pkB\u001c\bFA\u0013\u001b\u0001")
public class ListConsumerGroupTest
extends ConsumerGroupCommandTest {
    @Test
    public void testListOldConsumerGroups() {
        Whitelist topicFilter = new Whitelist(this.topic());
        Properties props = new Properties();
        props.setProperty("group.id", this.group());
        props.setProperty("zookeeper.connect", this.zkConnect());
        OldConsumer consumer1Mock = (OldConsumer)EasyMock.createMockBuilder(OldConsumer.class).withConstructor(new Object[]{topicFilter, props}).createMock();
        props.setProperty("group.id", "some.other.group");
        OldConsumer consumer2Mock = (OldConsumer)EasyMock.createMockBuilder(OldConsumer.class).withConstructor(new Object[]{topicFilter, props}).createMock();
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect()}));
        ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.ZkConsumerGroupService(opts);
        EasyMock.replay((Object[])new Object[]{consumer1Mock});
        EasyMock.replay((Object[])new Object[]{consumer2Mock});
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            List groups = consumerGroupCommand.listGroups();
            return groups.size() == 2 && groups.contains((Object)this.group());
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected a different list group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        consumerGroupCommand.close();
        consumer1Mock.stop();
        consumer2Mock.stop();
    }

    @Test
    public void testListGroupWithNoExistingGroup() {
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect()}));
        try (ConsumerGroupCommand.ZkConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.ZkConsumerGroupService(opts);){
            List $org_scalatest_assert_macro_left = consumerGroupCommand.listGroups();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ListConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }
    }

    @Test
    public void testListConsumerGroups() {
        String simpleGroup;
        String x$1 = simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, x$1);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--list"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Set expectedGroups = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.group(), simpleGroup}));
        ObjectRef foundGroups = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            foundGroups$1.elem = service.listGroups().toSet();
            Set set = expectedGroups;
            Set set2 = (Set)foundGroups$1.elem;
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected --list to show groups ", ", but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedGroups, (Set)foundGroups$1.elem})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }
}

