/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u000f\t\u0019R*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001AQ!\u0005\u0001\u0005BI\t\u0011\u0003\u001d:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0003V]&$\b\"\u0002\u000e\u0011\u0001\u0004Y\u0012A\u00039s_B,'\u000f^5fgB\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005kRLGNC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"A\u0003)s_B,'\u000f^5fg\")A\u0005\u0001C\u0001K\u0005\u0001C/Z:u\u00072,8\u000f^3s\u0013\u0012<\u0016\u000e\u001e5SKF,Xm\u001d;WKJ\u001c\u0018n\u001c82)\u0005\u0019\u0002FA\u0012(!\tAS&D\u0001*\u0015\tQ3&A\u0003kk:LGOC\u0001-\u0003\ry'oZ\u0005\u0003]%\u0012A\u0001V3ti\")\u0001\u0007\u0001C\u0001K\u0005!B/Z:u\u00072,8\u000f^3s\u0013\u0012L5OV1mS\u0012D#aL\u0014\t\u000bM\u0002A\u0011A\u0013\u0002!Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe&#\u0007F\u0001\u001a(\u0011\u00151\u0004\u0001\"\u0001&\u0003!!Xm\u001d;SC\u000e\\\u0007FA\u001b(\u0011\u0015I\u0004\u0001\"\u0001&\u00039!Xm\u001d;Jg&sG/\u001a:oC2D#\u0001O\u0014\t\u000bq\u0002A\u0011A\u0013\u0002'Q,7\u000f\u001e(p)>\u0004\u0018nY:SKF,Xm\u001d;)\u0005m:\u0003\"B \u0001\t\u0003)\u0013!\u0006;fgR\fU\u000f^8U_BL7m\u0011:fCRLwN\u001c\u0015\u0003}\u001dBQA\u0011\u0001\u0005\u0002\u0015\nA\u0003^3ti\u0006cG\u000eV8qS\u000e\u001c(+Z9vKN$\bFA!(\u0011\u0015)\u0005\u0001\"\u0001&\u0003Q!Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\"\u0012Ai\n\u0005\u0006\u0011\u0002!\t!J\u0001\u0018i\u0016\u001cHOU3qY&\u001c\u0017\rR8x]J+7\u000f]8og\u0016D#aR\u0014\t\u000b-\u0003A\u0011\u0002'\u0002'M,g\u000eZ'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0015\u00075CV\f\u0005\u0002O-6\tqJ\u0003\u0002Q#\u0006A!/Z9vKN$8O\u0003\u0002S'\u000611m\\7n_:T!!\u0002+\u000b\u0005U[\u0013AB1qC\u000eDW-\u0003\u0002X\u001f\n\u0001R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a\u0005\u00063*\u0003\rAW\u0001\be\u0016\fX/Z:u!\tq5,\u0003\u0002]\u001f\nyQ*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fC\u0004_\u0015B\u0005\t\u0019A0\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\t\u0004)\u0001\u0014\u0017BA1\u0016\u0005\u0019y\u0005\u000f^5p]B\u00111MZ\u0007\u0002I*\u0011Q\rB\u0001\b]\u0016$xo\u001c:l\u0013\t9GM\u0001\u0007T_\u000e\\W\r^*feZ,'\u000fC\u0004j\u0001E\u0005I\u0011\u00026\u0002;M,g\u000eZ'fi\u0006$\u0017\r^1SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*\u0012a\u001b\u0016\u0003?2\\\u0013!\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005I,\u0012AC1o]>$\u0018\r^5p]&\u0011Ao\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class MetadataRequestTest
extends BaseRequestTest {
    @Override
    public void propertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())})));
    }

    @Test
    public void testClusterIdWithRequestVersion1() {
        MetadataResponse v1MetadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        String v1ClusterId = v1MetadataResponse.clusterId();
        Assert.assertNull((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v1 clusterId should be null"})).s((Seq)Nil$.MODULE$), (Object)v1ClusterId);
    }

    @Test
    public void testClusterIdIsValid() {
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)2), this.sendMetadataRequest$default$2());
        TestUtils.isValidClusterId((String)metadataResponse.clusterId());
    }

    @Test
    public void testControllerId() {
        KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$1(x$1))).get();
        int controllerId = controllerServer.config().brokerId();
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assert.assertEquals((String)"Controller id should match the active controller", (long)controllerId, (long)metadataResponse.controller().id());
        controllerServer.shutdown();
        controllerServer.startup();
        KafkaServer controllerServer2 = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$2(x$2))).get();
        int controllerId2 = controllerServer2.config().brokerId();
        Assert.assertNotEquals((String)"Controller id should switch to a new broker", (long)controllerId, (long)controllerId2);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            MetadataResponse metadataResponse2 = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
            return metadataResponse2.controller() != null && controllerServer2.apis().brokerId() == metadataResponse2.controller().id();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Controller id should match the active controller after failover", 5000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testRack() {
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.brokers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)broker -> {
            MetadataRequestTest.$anonfun$testRack$1(broker);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testIsInternal() {
        String internalTopic = "__consumer_offsets";
        String notInternalTopic = "notInternal";
        this.createTopic(internalTopic, 3, 2, this.createTopic$default$4());
        this.createTopic(notInternalTopic, 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"Response should have no errors", (boolean)metadataResponse.errors().isEmpty());
        Iterable topicMetadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala();
        MetadataResponse.TopicMetadata internalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$1(internalTopic, x$3))).get();
        MetadataResponse.TopicMetadata notInternalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$2(notInternalTopic, x$4))).get();
        Assert.assertTrue((String)"internalTopic should show isInternal", (boolean)internalTopicMetadata.isInternal());
        Assert.assertFalse((String)"notInternalTopic topic not should show isInternal", (boolean)notInternalTopicMetadata.isInternal());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{internalTopic}))).asJava(), (Object)metadataResponse.cluster().internalTopics());
    }

    @Test
    public void testNoTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4());
        this.createTopic("t2", 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), true, (short)1), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"Response should have no errors", (boolean)metadataResponse.errors().isEmpty());
        Assert.assertTrue((String)"Response should have no topics", (boolean)metadataResponse.topicMetadata().isEmpty());
    }

    @Test
    public void testAutoTopicCreation() {
        String topic1 = "t1";
        String topic2 = "t2";
        String topic3 = "t3";
        String topic4 = "t4";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        MetadataResponse response1 = this.sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2}))).asJava(), true, ApiKeys.METADATA.latestVersion()), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic$1(topic1, topic2, response1);
        MetadataResponse response2 = this.sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic2, topic3}))).asJava(), false, 3), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic$1(topic2, topic3, response2);
        MetadataResponse response3 = this.sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic3, topic4}))).asJava(), false, 4), this.sendMetadataRequest$default$2());
        Assert.assertNull(response3.errors().get(topic3));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic4));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(topic4));
    }

    @Test
    public void testAllTopicsRequest() {
        this.createTopic("t1", 3, 2, this.createTopic$default$4());
        this.createTopic("t2", 3, 2, this.createTopic$default$4());
        MetadataResponse metadataResponseV0 = this.sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), true, (short)0), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"V0 Response should have no errors", (boolean)metadataResponseV0.errors().isEmpty());
        Assert.assertEquals((String)"V0 Response should have 2 (all) topics", (long)2L, (long)metadataResponseV0.topicMetadata().size());
        MetadataResponse metadataResponseV1 = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assert.assertTrue((String)"V1 Response should have no errors", (boolean)metadataResponseV1.errors().isEmpty());
        Assert.assertEquals((String)"V1 Response should have 2 (all) topics", (long)2L, (long)metadataResponseV1.topicMetadata().size());
    }

    @Test
    public void testPreferredReplica() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopic("t1", (Map<Object, Seq<Object>>)replicaAssignment);
        Seq responses = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetadataResponse[]{this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).asJava(), true).build(), (Option<SocketServer>)new Some((Object)this.controllerSocketServer())), this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).asJava(), true).build(), (Option<SocketServer>)new Some((Object)this.notControllerSocketServer()))}));
        responses.foreach((Function1 & Serializable & scala.Serializable)response -> {
            MetadataRequestTest.$anonfun$testPreferredReplica$1(replicaAssignment, response);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testReplicaDownResponse() {
        String replicaDownTopic = "replicaDown";
        int replicaCount = 3;
        this.createTopic(replicaDownTopic, 1, replicaCount, this.createTopic$default$4());
        MetadataResponse metadataResponse = this.sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))).asJava(), true, (short)1), this.sendMetadataRequest$default$2());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        KafkaServer downNode = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$1(partitionMetadata, server))).get();
        downNode.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            MetadataResponse response = this.sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))).asJava(), true, (short)1), this.sendMetadataRequest$default$2());
            MetadataResponse.PartitionMetadata metadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
            Node replica = (Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.replicas()).asScala()).find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$5(downNode, x$9))).get();
            String string = replica.host();
            String string2 = "";
            return !(string != null ? !string.equals(string2) : string2 != null) & replica.port() == -1;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replica was not found down", 5000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        MetadataResponse v0MetadataResponse = this.sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))).asJava(), true, (short)0), this.sendMetadataRequest$default$2());
        Seq v0BrokerIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assert.assertTrue((String)"Response should have no errors", (boolean)v0MetadataResponse.errors().isEmpty());
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The downed broker should not be in the brokers list"})).s((Seq)Nil$.MODULE$), (boolean)v0BrokerIds.contains((Object)downNode));
        Assert.assertTrue((String)"Response should have one topic", (v0MetadataResponse.topicMetadata().size() == 1 ? 1 : 0) != 0);
        MetadataResponse.PartitionMetadata v0PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Errors errors = v0PartitionMetadata.error();
        Errors errors2 = Errors.REPLICA_NOT_AVAILABLE;
        Assert.assertTrue((String)"PartitionMetadata should have an error", (!(errors != null ? !errors.equals(errors2) : errors2 != null) ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response should have ", " replicas"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(replicaCount - 1))})), (v0PartitionMetadata.replicas().size() == replicaCount - 1 ? 1 : 0) != 0);
        MetadataResponse v1MetadataResponse = this.sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))).asJava(), true, (short)1), this.sendMetadataRequest$default$2());
        Seq v1BrokerIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assert.assertTrue((String)"Response should have no errors", (boolean)v1MetadataResponse.errors().isEmpty());
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The downed broker should not be in the brokers list"})).s((Seq)Nil$.MODULE$), (boolean)v1BrokerIds.contains((Object)downNode));
        Assert.assertEquals((String)"Response should have one topic", (long)1L, (long)v1MetadataResponse.topicMetadata().size());
        MetadataResponse.PartitionMetadata v1PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Assert.assertEquals((String)"PartitionMetadata should have no errors", (Object)Errors.NONE, (Object)v1PartitionMetadata.error());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response should have ", " replicas"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaCount)})), (long)replicaCount, (long)v1PartitionMetadata.replicas().size());
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.METADATA, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return MetadataResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<SocketServer> sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$1(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$2(KafkaServer x$2) {
        return x$2.kafkaController().isActive();
    }

    public static final /* synthetic */ void $anonfun$testRack$1(Node broker) {
        Assert.assertEquals((String)"Rack information should match config", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)broker.id())})), (Object)broker.rack());
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$1(String internalTopic$1, MetadataResponse.TopicMetadata x$3) {
        String string = x$3.topic();
        String string2 = internalTopic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$2(String notInternalTopic$1, MetadataResponse.TopicMetadata x$4) {
        String string = x$4.topic();
        String string2 = notInternalTopic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final void checkAutoCreatedTopic$1(String existingTopic, String autoCreatedTopic, MetadataResponse response) {
        Assert.assertNull(response.errors().get(existingTopic));
        Assert.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, response.errors().get(autoCreatedTopic));
        Assert.assertEquals((Object)new Some((Object)((KafkaServer)this.servers().head()).config().numPartitions()), (Object)this.zkClient().getTopicPartitionCount(autoCreatedTopic));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(((KafkaServer)this.servers().head()).config().numPartitions())).foreach((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), autoCreatedTopic, i, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4()));
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplica$3(scala.collection.immutable.Map replicaAssignment$1, MetadataResponse.PartitionMetadata partitionMetadata) {
        Seq assignment = (Seq)replicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)partitionMetadata.partition()));
        Assert.assertEquals((Object)assignment, (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)assignment, (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)assignment.head()), (long)partitionMetadata.leader().id());
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplica$1(scala.collection.immutable.Map replicaAssignment$1, MetadataResponse response) {
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)response.topicMetadata().iterator().next();
        Assert.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        Assert.assertEquals((Object)"t1", (Object)topicMetadata.topic());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.partition()), Buffer$.MODULE$.canBuildFrom())).toSet());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).foreach((Function1 & Serializable & scala.Serializable)partitionMetadata -> {
            MetadataRequestTest.$anonfun$testPreferredReplica$3(replicaAssignment$1, partitionMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$1(MetadataResponse.PartitionMetadata partitionMetadata$1, KafkaServer server) {
        int serverId = server.apis().brokerId();
        int leaderId = partitionMetadata$1.leader().id();
        Buffer replicaIds = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata$1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()), Buffer$.MODULE$.canBuildFrom());
        return serverId != leaderId && replicaIds.contains((Object)BoxesRunTime.boxToInteger((int)serverId));
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$5(KafkaServer downNode$1, Node x$9) {
        return x$9.id() == downNode$1.apis().brokerId();
    }
}

