require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_PARAM_H_)) {
    eval 'sub _SYS_PARAM_H_ () {1;}' unless defined(&_SYS_PARAM_H_);
    if(defined(&_KERNEL_OPT)) {
	require './sys/opt_param.ph';
    }
    eval 'sub BSD () {199506;}' unless defined(&BSD);
    eval 'sub BSD4_3 () {1;}' unless defined(&BSD4_3);
    eval 'sub BSD4_4 () {1;}' unless defined(&BSD4_4);
    eval 'sub __NetBSD_Version__ () {904000000;}' unless defined(&__NetBSD_Version__);
    eval 'sub __NetBSD_Prereq__ {
        my($M,$m,$p) = @_;
	    eval q(((((($M) * 100000000) + ($m) * 1000000) + ($p) * 100) <=  &__NetBSD_Version__));
    }' unless defined(&__NetBSD_Prereq__);
    eval 'sub NetBSD () {199905;}' unless defined(&NetBSD);
    if(defined(&_KERNEL)  && !defined(&_RUMPKERNEL)) {
	eval 'sub _HARDKERNEL () {1;}' unless defined(&_HARDKERNEL);
    }
    if(defined(&_KERNEL)  && defined(&_RUMPKERNEL)) {
	eval 'sub _SOFTKERNEL () {1;}' unless defined(&_SOFTKERNEL);
    }
    require 'sys/null.ph';
    unless(defined(&__ASSEMBLER__)) {
	require 'sys/inttypes.ph';
	require 'sys/types.ph';
	require 'sys/syslimits.ph';
	eval 'sub MAXCOMLEN () {16;}' unless defined(&MAXCOMLEN);
	eval 'sub MAXINTERP () { &PATH_MAX;}' unless defined(&MAXINTERP);
	eval 'sub MAXLOGNAME () {( &LOGIN_NAME_MAX - 1);}' unless defined(&MAXLOGNAME);
	eval 'sub NCARGS () { &ARG_MAX;}' unless defined(&NCARGS);
	eval 'sub NGROUPS () { &NGROUPS_MAX;}' unless defined(&NGROUPS);
	eval 'sub NOGROUP () {65535;}' unless defined(&NOGROUP);
	eval 'sub MAXHOSTNAMELEN () {256;}' unless defined(&MAXHOSTNAMELEN);
	unless(defined(&NOFILE)) {
	    eval 'sub NOFILE () { &OPEN_MAX;}' unless defined(&NOFILE);
	}
	unless(defined(&MAXUPRC)) {
	    eval 'sub MAXUPRC () { &CHILD_MAX;}' unless defined(&MAXUPRC);
	} else {
	    if(((defined(&MAXUPRC) ? &MAXUPRC : undef) - 0) < (defined(&CHILD_MAX) ? &CHILD_MAX : undef)) {
		die("MAXUPRC\ less\ than\ CHILD_MAX\.\ \ See\ options\(4\)\ for\ details\.");
	    }
	}
	eval 'sub MIN {
	    my($a,$b) = @_;
    	    eval q((( ($a)<($b))?($a):($b)));
	}' unless defined(&MIN);
	eval 'sub MAX {
	    my($a,$b) = @_;
    	    eval q((( ($a)>($b))?($a):($b)));
	}' unless defined(&MAX);
	if(defined(&_KERNEL)) {
	    require 'sys/cdefs.ph';
	    require 'sys/errno.ph';
	    require 'sys/time.ph';
	    require 'sys/resource.ph';
	    require 'sys/ucred.ph';
	    require 'sys/uio.ph';
	    require 'uvm/uvm_param.ph';
	    unless(defined(&NPROC)) {
		eval 'sub NPROC () {(20+ 16*  &MAXUSERS);}' unless defined(&NPROC);
	    }
	    unless(defined(&MAXFILES)) {
		eval 'sub MAXFILES () {(3* ( &NPROC +  &MAXUSERS) + 80);}' unless defined(&MAXFILES);
		eval 'sub MAXFILES_IMPLICIT () {1;}' unless defined(&MAXFILES_IMPLICIT);
	    }
	    unless(defined(&NTEXT)) {
		eval 'sub NTEXT () {(80+  &NPROC / 8);}' unless defined(&NTEXT);
	    }
	    unless(defined(&NVNODE)) {
		eval 'sub NVNODE () {( &NPROC +  &NTEXT + 100);}' unless defined(&NVNODE);
		eval 'sub NVNODE_IMPLICIT () {1;}' unless defined(&NVNODE_IMPLICIT);
	    }
	    unless(defined(&VNODE_KMEM_MAXPCT)) {
		eval 'sub VNODE_KMEM_MAXPCT () {60;}' unless defined(&VNODE_KMEM_MAXPCT);
	    }
	    unless(defined(&BUFCACHE_VA_MAXPCT)) {
		eval 'sub BUFCACHE_VA_MAXPCT () {20;}' unless defined(&BUFCACHE_VA_MAXPCT);
	    }
	    eval 'sub VNODE_COST () {2048;}' unless defined(&VNODE_COST);
	}
	require 'sys/signal.ph';
	require 'machine/param.ph';
	require 'machine/limits.ph';
	eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
	eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
	unless(defined(&BLKDEV_IOSIZE)) {
	    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
	}
	unless(defined(&MAXPHYS)) {
	    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
	}
	eval 'sub ctod {
	    my($x) = @_;
    	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
	}' unless defined(&ctod);
	eval 'sub dtoc {
	    my($x) = @_;
    	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
	}' unless defined(&dtoc);
	eval 'sub ctob {
	    my($x) = @_;
    	    eval q((($x) <<  &PGSHIFT));
	}' unless defined(&ctob);
	eval 'sub btoc {
	    my($x) = @_;
    	    eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
	}' unless defined(&btoc);
	eval 'sub dbtob {
	    my($x) = @_;
    	    eval q((($x) <<  &DEV_BSHIFT));
	}' unless defined(&dbtob);
	eval 'sub btodb {
	    my($x) = @_;
    	    eval q((($x) >>  &DEV_BSHIFT));
	}' unless defined(&btodb);
	unless(defined(&COHERENCY_UNIT)) {
	    eval 'sub COHERENCY_UNIT () {64;}' unless defined(&COHERENCY_UNIT);
	}
	unless(defined(&CACHE_LINE_SIZE)) {
	    eval 'sub CACHE_LINE_SIZE () {64;}' unless defined(&CACHE_LINE_SIZE);
	}
	unless(defined(&MAXCPUS)) {
	    eval 'sub MAXCPUS () {32;}' unless defined(&MAXCPUS);
	}
	unless(defined(&MAX_LWP_PER_PROC)) {
	    eval 'sub MAX_LWP_PER_PROC () {8000;}' unless defined(&MAX_LWP_PER_PROC);
	}
	if(defined(&_KERNEL) || defined(&__EXPOSE_STACK)) {
	    unless(defined(&STACK_ALIGNBYTES)) {
		eval 'sub STACK_ALIGNBYTES () { &__ALIGNBYTES;}' unless defined(&STACK_ALIGNBYTES);
	    }
	    if(defined(&__MACHINE_STACK_GROWS_UP)) {
		eval 'sub STACK_GROW {
		    my($sp, $_size) = @_;
    		    eval q(((( &void *)($sp)) + ($_size)));
		}' unless defined(&STACK_GROW);
		eval 'sub STACK_SHRINK {
		    my($sp, $_size) = @_;
    		    eval q(((( &void *)($sp)) - ($_size)));
		}' unless defined(&STACK_SHRINK);
		eval 'sub STACK_ALIGN {
		    my($sp, $bytes) = @_;
    		    eval q(((((($sp)) + ($bytes)) & ~($bytes))));
		}' unless defined(&STACK_ALIGN);
		eval 'sub STACK_ALLOC {
		    my($sp, $_size) = @_;
    		    eval q((( &void *)($sp)));
		}' unless defined(&STACK_ALLOC);
		eval 'sub STACK_MAX {
		    my($p, $_size) = @_;
    		    eval q(((( &void *)($p)) + ($_size)));
		}' unless defined(&STACK_MAX);
	    } else {
		eval 'sub STACK_GROW {
		    my($sp, $_size) = @_;
    		    eval q(((( &void *)($sp)) - ($_size)));
		}' unless defined(&STACK_GROW);
		eval 'sub STACK_SHRINK {
		    my($sp, $_size) = @_;
    		    eval q(((( &void *)($sp)) + ($_size)));
		}' unless defined(&STACK_SHRINK);
		eval 'sub STACK_ALIGN {
		    my($sp, $bytes) = @_;
    		    eval q((((($sp)) & ~($bytes))));
		}' unless defined(&STACK_ALIGN);
		eval 'sub STACK_ALLOC {
		    my($sp, $_size) = @_;
    		    eval q(((( &void *)($sp)) - ($_size)));
		}' unless defined(&STACK_ALLOC);
		eval 'sub STACK_MAX {
		    my($p, $_size) = @_;
    		    eval q((( &void *)($p)));
		}' unless defined(&STACK_MAX);
	    }
	    eval 'sub STACK_LEN_ALIGN {
	        my($len, $bytes) = @_;
    		eval q(((($len) + ($bytes)) & ~($bytes)));
	    }' unless defined(&STACK_LEN_ALIGN);
	}
	eval 'sub ALIGNBYTES () { &__ALIGNBYTES;}' unless defined(&ALIGNBYTES);
	unless(defined(&ALIGN)) {
	    eval 'sub ALIGN {
	        my($p) = @_;
    		eval q(((( &uintptr_t)($p) +  &ALIGNBYTES) & ~ &ALIGNBYTES));
	    }' unless defined(&ALIGN);
	}
	unless(defined(&ALIGNED_POINTER)) {
	    eval 'sub ALIGNED_POINTER {
	        my($p,$t) = @_;
    		eval q((((( &uintptr_t)($p)) & ($sizeof{$t} - 1)) == 0));
	    }' unless defined(&ALIGNED_POINTER);
	}
	unless(defined(&ALIGNED_POINTER_LOAD)) {
	    eval 'sub ALIGNED_POINTER_LOAD {
	        my($q,$p,$t) = @_;
    		eval q((*($q) = *(( &const $t *)($p))));
	    }' unless defined(&ALIGNED_POINTER_LOAD);
	}
	eval 'sub PSWP () {0;}' unless defined(&PSWP);
	eval 'sub PVM () {4;}' unless defined(&PVM);
	eval 'sub PINOD () {8;}' unless defined(&PINOD);
	eval 'sub PRIBIO () {16;}' unless defined(&PRIBIO);
	eval 'sub PVFS () {20;}' unless defined(&PVFS);
	eval 'sub PZERO () {22;}' unless defined(&PZERO);
	eval 'sub PSOCK () {24;}' unless defined(&PSOCK);
	eval 'sub PWAIT () {32;}' unless defined(&PWAIT);
	eval 'sub PLOCK () {36;}' unless defined(&PLOCK);
	eval 'sub PPAUSE () {40;}' unless defined(&PPAUSE);
	eval 'sub PUSER () {50;}' unless defined(&PUSER);
	eval 'sub MAXPRI () {127;}' unless defined(&MAXPRI);
	eval 'sub PCATCH () {0x100;}' unless defined(&PCATCH);
	eval 'sub PNORELOCK () {0x200;}' unless defined(&PNORELOCK);
	eval 'sub PRI_COUNT () {224;}' unless defined(&PRI_COUNT);
	eval 'sub PRI_NONE () {(-1);}' unless defined(&PRI_NONE);
	eval 'sub PRI_KERNEL_RT () {192;}' unless defined(&PRI_KERNEL_RT);
	eval 'sub NPRI_KERNEL_RT () {32;}' unless defined(&NPRI_KERNEL_RT);
	eval 'sub MAXPRI_KERNEL_RT () {( &PRI_KERNEL_RT +  &NPRI_KERNEL_RT - 1);}' unless defined(&MAXPRI_KERNEL_RT);
	eval 'sub PRI_USER_RT () {128;}' unless defined(&PRI_USER_RT);
	eval 'sub NPRI_USER_RT () {64;}' unless defined(&NPRI_USER_RT);
	eval 'sub MAXPRI_USER_RT () {( &PRI_USER_RT +  &NPRI_USER_RT - 1);}' unless defined(&MAXPRI_USER_RT);
	eval 'sub PRI_KTHREAD () {96;}' unless defined(&PRI_KTHREAD);
	eval 'sub NPRI_KTHREAD () {32;}' unless defined(&NPRI_KTHREAD);
	eval 'sub MAXPRI_KTHREAD () {( &PRI_KTHREAD +  &NPRI_KTHREAD - 1);}' unless defined(&MAXPRI_KTHREAD);
	eval 'sub PRI_KERNEL () {64;}' unless defined(&PRI_KERNEL);
	eval 'sub NPRI_KERNEL () {32;}' unless defined(&NPRI_KERNEL);
	eval 'sub MAXPRI_KERNEL () {( &PRI_KERNEL +  &NPRI_KERNEL - 1);}' unless defined(&MAXPRI_KERNEL);
	eval 'sub PRI_USER () {0;}' unless defined(&PRI_USER);
	eval 'sub NPRI_USER () {64;}' unless defined(&NPRI_USER);
	eval 'sub MAXPRI_USER () {( &PRI_USER +  &NPRI_USER - 1);}' unless defined(&MAXPRI_USER);
	eval 'sub SCHED_PRI_MIN () {0;}' unless defined(&SCHED_PRI_MIN);
	eval 'sub SCHED_PRI_MAX () {63;}' unless defined(&SCHED_PRI_MAX);
	eval 'sub PRI_SOFTSERIAL () { &MAXPRI_KERNEL_RT;}' unless defined(&PRI_SOFTSERIAL);
	eval 'sub PRI_SOFTNET () {( &MAXPRI_KERNEL_RT -  &schedppq * 1);}' unless defined(&PRI_SOFTNET);
	eval 'sub PRI_SOFTBIO () {( &MAXPRI_KERNEL_RT -  &schedppq * 2);}' unless defined(&PRI_SOFTBIO);
	eval 'sub PRI_SOFTCLOCK () {( &MAXPRI_KERNEL_RT -  &schedppq * 3);}' unless defined(&PRI_SOFTCLOCK);
	eval 'sub PRI_XCALL () { &MAXPRI_KTHREAD;}' unless defined(&PRI_XCALL);
	eval 'sub PRI_PGDAEMON () {( &MAXPRI_KTHREAD -  &schedppq * 1);}' unless defined(&PRI_PGDAEMON);
	eval 'sub PRI_VM () {( &MAXPRI_KTHREAD -  &schedppq * 2);}' unless defined(&PRI_VM);
	eval 'sub PRI_IOFLUSH () {( &MAXPRI_KTHREAD -  &schedppq * 3);}' unless defined(&PRI_IOFLUSH);
	eval 'sub PRI_BIO () {( &MAXPRI_KTHREAD -  &schedppq * 4);}' unless defined(&PRI_BIO);
	eval 'sub PRI_IDLE () { &PRI_USER;}' unless defined(&PRI_IDLE);
	eval 'sub NBPW () {$sizeof{\'int\'};}' unless defined(&NBPW);
	eval 'sub CMASK () {022;}' unless defined(&CMASK);
	eval 'sub NODEV () {( &dev_t)(-1);}' unless defined(&NODEV);
	unless(defined(&MAXBSIZE)) {
	    eval 'sub MAXBSIZE () { &MAXPHYS;}' unless defined(&MAXBSIZE);
	}
	eval 'sub MAXFRAG () {8;}' unless defined(&MAXFRAG);
	eval 'sub MAXPATHLEN () { &PATH_MAX;}' unless defined(&MAXPATHLEN);
	eval 'sub MAXSYMLINKS () {32;}' unless defined(&MAXSYMLINKS);
	eval 'sub KERNEL_NAME_MAX () {255;}' unless defined(&KERNEL_NAME_MAX);
	eval 'sub setbit {
	    my($a,$i) = @_;
    	    eval q((($a)[($i)/ &NBBY] |= 1<<(($i)% &NBBY)));
	}' unless defined(&setbit);
	eval 'sub clrbit {
	    my($a,$i) = @_;
    	    eval q((($a)[($i)/ &NBBY] &= ~(1<<(($i)% &NBBY))));
	}' unless defined(&clrbit);
	eval 'sub isset {
	    my($a,$i) = @_;
    	    eval q((($a)[($i)/ &NBBY] & (1<<(($i)% &NBBY))));
	}' unless defined(&isset);
	eval 'sub isclr {
	    my($a,$i) = @_;
    	    eval q(((($a)[($i)/ &NBBY] & (1<<(($i)% &NBBY))) == 0));
	}' unless defined(&isclr);
	unless(defined(&howmany)) {
	    eval 'sub howmany {
	        my($x, $y) = @_;
    		eval q(((($x)+(($y)-1))/($y)));
	    }' unless defined(&howmany);
	}
	eval 'sub roundup {
	    my($x, $y) = @_;
    	    eval q((((($x)+(($y)-1))/($y))*($y)));
	}' unless defined(&roundup);
	eval 'sub rounddown {
	    my($x,$y) = @_;
    	    eval q(((($x)/($y))*($y)));
	}' unless defined(&rounddown);
	eval 'sub roundup2 {
	    my($x,$m) = @_;
    	    eval q((((($x) - 1) | (($m) - 1)) + 1));
	}' unless defined(&roundup2);
	eval 'sub rounddown2 {
	    my($x,$m) = @_;
    	    eval q((($x) & ~(( &__typeof__($x))(($m) - 1))));
	}' unless defined(&rounddown2);
	eval 'sub powerof2 {
	    my($x) = @_;
    	    eval q((((($x)-1)($x))==0));
	}' unless defined(&powerof2);
	if(defined(&_LP64)) {
	    eval 'sub MINBUCKET () {5;}' unless defined(&MINBUCKET);
	} else {
	    eval 'sub MINBUCKET () {4;}' unless defined(&MINBUCKET);
	}
	eval 'sub MAXALLOCSAVE () {(2*  &NBPG);}' unless defined(&MAXALLOCSAVE);
	eval 'sub FSHIFT () {11;}' unless defined(&FSHIFT);
	eval 'sub FSCALE () {(1<< &FSHIFT);}' unless defined(&FSCALE);
	eval 'sub MAXSLP () {20;}' unless defined(&MAXSLP);
	unless(defined(&UBC_WINSHIFT)) {
	    eval 'sub UBC_WINSHIFT () {13;}' unless defined(&UBC_WINSHIFT);
	}
	unless(defined(&UBC_NWINS)) {
	    eval 'sub UBC_NWINS () {1024;}' unless defined(&UBC_NWINS);
	}
	if(defined(&_KERNEL)) {
	    unless(defined(&mstohz)) {
		eval 'sub mstohz {
		    my($ms) = @_;
    		    eval q(( &__predict_false(($ms) >= 0x20000) ? (($ms +0) / 1000) *  &hz : (($ms +0) *  &hz) / 1000));
		}' unless defined(&mstohz);
	    }
	    unless(defined(&hztoms)) {
		eval 'sub hztoms {
		    my($t) = @_;
    		    eval q(( &__predict_false(($t) >= 0x20000) ? (($t +0) /  &hz) * 1000 : (($t +0) * 1000) /  &hz));
		}' unless defined(&hztoms);
	    }
	    eval 'sub hz2bintime {
	        my($t) = @_;
    		eval q(( &ms2bintime( &hztoms($t))));
	    }' unless defined(&hz2bintime);
	}
	unless(defined(&MIN_LWP_ALIGNMENT)) {
	    eval 'sub MIN_LWP_ALIGNMENT () {32;}' unless defined(&MIN_LWP_ALIGNMENT);
	}
    }
}
1;
