/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpException;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;

public class TestInjectionSQL
extends AbstractAppParamPlugin {
    private static final String[] dependency = new String[]{"TestInjectionSQLFingerprint"};
    private static final int TIME_SPREAD = 15000;
    private static final String SQL_DELAY_1 = "';waitfor delay '0:0:15';--";
    private static final String SQL_DELAY_2 = ";waitfor delay '0:0:15';--";
    private static final String SQL_BLIND_MS_INSERT = ");waitfor delay '0:0:15';--";
    private static final String[] SQL_AND = new String[]{" AND 1=1", "' AND '1'='1", "\" AND \"1\"=\"1"};
    private static final String[] SQL_AND_ERR = new String[]{" AND 1=2", "' AND '1'='2", "\" AND \"1\"=\"2"};
    private static final String[] SQL_OR = new String[]{" OR 1=1", "' OR '1'='1", "\" OR \"1\"=\"1"};
    private static final String SQL_CHECK_ERR = "'INJECTED_PARAM";
    private static final Pattern patternErrorODBC1 = Pattern.compile("Microsoft OLE DB Provider for ODBC Drivers.*error", 10);
    private static final Pattern patternErrorODBC2 = Pattern.compile("ODBC.*Drivers.*error", 10);
    private static final Pattern patternErrorGeneric = Pattern.compile("JDBC|ODBC|not a valid MySQL|SQL", 10);
    private static final Pattern patternErrorODBCMSSQL = Pattern.compile("ODBC SQL Server Driver", 10);
    private String mResBodyNormal = "";
    private String mResBodyError = "";

    public int getId() {
        return 40030;
    }

    public String getName() {
        return "SQL Injection";
    }

    public String[] getDependency() {
        return dependency;
    }

    public String getDescription() {
        String string = "SQL injection is possible.  User parameters submitted will be formulated into a SQL query for database processing.  If the query is built by simple 'string concatenation', it is possible to modify the meaning of the query by carefully crafting the parameters.  Depending on the access right and type of database used, tampered query can be used to retrieve sensitive information from the database or execute arbitrary code.  MS SQL and PostGreSQL, which supports multiple statements, may be exploited if the database access right is more powerful.\r\nThis can occur in URL query strings, POST paramters or even cookies.  Currently check on cookie is not supported by Paros.  You should check SQL injection manually as well as some blind SQL injection areas cannot be discovered by this check.";
        return string;
    }

    public int getCategory() {
        return 4;
    }

    public String getSolution() {
        String string = "Do not trust client side input even if there is client side validation.  In general, <ul><li>If the input string is numeric, type check it.</li><li>If the application used JDBC, use PreparedStatement or CallableStatement with parameters passed by '?'</li><li>If the application used ASP, use ADO Command Objects with strong type checking and parameterized query.</li><li>If stored procedure or bind variables can be used, use it for parameter passing into query.  Do not just concatenate string into query in the stored procedure!</li><li>Do not create dynamic SQL query by simple string concatentation.</li><li>Use minimum database user privilege for the application.  This does not eliminate SQL injection but minimize its damage.  Eg if the application require reading one table only, grant such access to the application.  Avoid using 'sa' or 'db-owner'.</li></ul>";
        return string;
    }

    public String getReference() {
        String string = "<ul><li>The OWASP guide at http://www.owasp.org/documentation/guide</li><li>http://www.sqlsecurity.com/DesktopDefault.aspx?tabid=23</li><li>http://www.spidynamics.com/whitepapers/WhitepaperSQLInjection.pdf</li><li>For Oracle database, refer to http://www.integrigy.com/info/IntegrigyIntrotoSQLInjectionAttacks.pdf</li></ul>";
        return string;
    }

    public void init() {
    }

    public void scan(HttpMessage httpMessage, String string, String string2) {
        try {
            this.scanSQL(httpMessage, string, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void scanSQL(HttpMessage httpMessage, String string, String string2) throws HttpException, IOException {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        long l = 0L;
        HttpMessage httpMessage2 = this.getNewMsg();
        this.sendAndReceive(httpMessage2);
        l = httpMessage2.getTimeElapsedMillis();
        if (httpMessage2.getResponseHeader().getStatusCode() != 200) {
            return;
        }
        this.mResBodyNormal = httpMessage2.getResponseBody().toString();
        string5 = this.setParameter(httpMessage2, string, string2 + SQL_CHECK_ERR);
        this.sendAndReceive(httpMessage2);
        this.mResBodyError = httpMessage2.getResponseBody().toString();
        if (this.checkANDResult(httpMessage2, string5)) {
            return;
        }
        for (int i = 0; i < SQL_AND.length; ++i) {
            string3 = this.setParameter(httpMessage2, string, string2 + SQL_AND[i]);
            this.sendAndReceive(httpMessage2);
            string4 = httpMessage2.getRequestHeader().getURI().toString();
            if (this.checkANDResult(httpMessage2, string3)) {
                return;
            }
            if (httpMessage2.getResponseHeader().getStatusCode() != 200 || (string6 = this.stripOff(httpMessage2.getResponseBody().toString(), SQL_AND[i])).compareTo(this.mResBodyNormal) != 0) continue;
            string5 = this.setParameter(httpMessage2, string, string2 + SQL_AND_ERR[i]);
            this.sendAndReceive(httpMessage2);
            string7 = this.stripOff(httpMessage2.getResponseBody().toString(), SQL_AND_ERR[i]);
            if (string7.compareTo(this.mResBodyNormal) != 0) {
                this.getKb().add(httpMessage2.getRequestHeader().getURI(), "sql/and", (Object)new Boolean(true));
                this.bingo(3, 1, string4, string3, "", httpMessage2);
                return;
            }
            string5 = this.setParameter(httpMessage2, string, string2 + SQL_OR[i]);
            this.sendAndReceive(httpMessage2);
            string8 = this.stripOff(httpMessage2.getResponseBody().toString(), SQL_OR[i]);
            if (string8.compareTo(this.mResBodyNormal) == 0) continue;
            this.getKb().add(httpMessage2.getRequestHeader().getURI(), "sql/or", (Object)new Boolean(true));
            this.bingo(3, 1, string4, string5, "", httpMessage2);
            return;
        }
        if (this.getKb().getBoolean(httpMessage2.getRequestHeader().getURI(), "sql/mssql")) {
            return;
        }
        string5 = this.setParameter(httpMessage2, string, string2 + SQL_DELAY_1);
        this.sendAndReceive(httpMessage2);
        if (this.checkTimeResult(httpMessage2, string5, l, httpMessage2.getTimeElapsedMillis())) {
            return;
        }
        string5 = this.setParameter(httpMessage2, string, string2 + SQL_DELAY_2);
        this.sendAndReceive(httpMessage2);
        if (this.checkTimeResult(httpMessage2, string5, l, httpMessage2.getTimeElapsedMillis())) {
            return;
        }
        this.testBlindINSERT(httpMessage2, string, string2);
    }

    private void testBlindINSERT(HttpMessage httpMessage, String string, String string2) throws HttpException, IOException {
        Object var4_4 = null;
        Object var5_5 = null;
        String string3 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        boolean bl = false;
        long l = 0L;
        int n = 5;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(",'0'");
            }
            string3 = this.setParameter(httpMessage, string, string2 + "'" + stringBuffer.toString() + SQL_BLIND_MS_INSERT);
            this.sendAndReceive(httpMessage);
            if (this.checkTimeResult(httpMessage, string3, l, httpMessage.getTimeElapsedMillis())) {
                this.getKb().add(httpMessage.getRequestHeader().getURI(), "sql/mssql", (Object)new Boolean(true));
                return;
            }
            try {
                long l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            string3 = this.setParameter(httpMessage, string, string2 + stringBuffer.toString() + SQL_BLIND_MS_INSERT);
            this.sendAndReceive(httpMessage);
            if (!this.checkTimeResult(httpMessage, string3, l, httpMessage.getTimeElapsedMillis())) continue;
            this.getKb().add(httpMessage.getRequestHeader().getURI(), "sql/mssql", (Object)new Boolean(true));
            return;
        }
    }

    private boolean checkANDResult(HttpMessage httpMessage, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (httpMessage.getResponseHeader().getStatusCode() != 200 && !HttpStatusCode.isServerError(httpMessage.getResponseHeader().getStatusCode())) {
            return false;
        }
        if (this.matchBodyPattern(httpMessage, patternErrorODBCMSSQL, stringBuffer)) {
            this.getKb().add(httpMessage.getRequestHeader().getURI(), "sql/mssql", (Object)new Boolean(true));
        }
        if (this.matchBodyPattern(httpMessage, patternErrorODBC1, stringBuffer) || this.matchBodyPattern(httpMessage, patternErrorODBC2, stringBuffer)) {
            this.bingo(3, 1, null, string, stringBuffer.toString(), httpMessage);
            return true;
        }
        if (this.matchBodyPattern(httpMessage, patternErrorGeneric, stringBuffer)) {
            this.bingo(3, 0, null, string, stringBuffer.toString(), httpMessage);
            return true;
        }
        return false;
    }

    private boolean checkTimeResult(HttpMessage httpMessage, String string, long l, long l2) {
        boolean bl = this.checkANDResult(httpMessage, string);
        if (bl) {
            return bl;
        }
        if (l2 > l + 15000L - 500L) {
            this.bingo(3, 0, null, string, "", httpMessage);
            return true;
        }
        return false;
    }
}

