/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.context;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.context.FileTreeIterator;
import com.sixrr.xrp.context.MultiIterator;
import java.util.ArrayList;
import java.util.Iterator;

public class ModuleContext
implements Context {
    private final Module module;

    public ModuleContext(Module module) {
        this.module = module;
    }

    @Override
    public Iterator<XmlFile> iterator() {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.module);
        Project project = this.module.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        VirtualFile[] directories = rootManager.getContentRoots();
        ArrayList<Iterator<FileTreeIterator>> enumerations = new ArrayList<Iterator<FileTreeIterator>>();
        for (VirtualFile directory : directories) {
            PsiDirectory psiDirectory = psiManager.findDirectory(directory);
            if (psiDirectory == null) continue;
            enumerations.add(new FileTreeIterator(psiDirectory));
        }
        return new MultiIterator<XmlFile>(enumerations);
    }
}

