/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import git4idea.config.GitExecutableManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class VCSCheckoutCommand
extends AbstractCommand {
    public static final String PREFIX = "%vcsCheckout";
    private final Project myProject;

    public VCSCheckoutCommand(@NotNull String text, int line, Project project) {
        if (text == null) {
            VCSCheckoutCommand.$$$reportNull$$$0(0);
        }
        super(text, line, true);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath(GitExecutableManager.getInstance().getPathToGit(this.myProject));
        cl.setWorkDirectory(this.myProject.getBasePath());
        cl.addParameter("checkout");
        cl.addParameter("--force");
        cl.addParameter(this.getText().substring(this.getText().indexOf(" ")).trim());
        AsyncPromise result = new AsyncPromise();
        try {
            context.message(cl.getCommandLineString(), this.getLine());
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cl);
            if (output.getExitCode() != 0) {
                throw new Exception("Git checkout failed with " + output.getExitCode() + ":\n" + output.getStderr());
            }
            this.myProject.getBaseDir().refresh(true, true, () -> result.setResult(null));
        }
        catch (Throwable e) {
            context.error(e.getMessage(), this.getLine());
            result.setError(e);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/VCSCheckoutCommand", "<init>"));
    }
}

