/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThrowableConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class GitHandlerInputProcessorUtil {
    private static final String DEFAULT_SEPARATOR = "\n";

    private GitHandlerInputProcessorUtil() {
    }

    @NotNull
    public static ThrowableConsumer<OutputStream, IOException> writeLines(@NotNull Collection<String> lines, @NotNull Charset charset) {
        if (lines == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(1);
        }
        ThrowableConsumer<OutputStream, IOException> throwableConsumer = GitHandlerInputProcessorUtil.writeLines(lines, DEFAULT_SEPARATOR, charset, false);
        if (throwableConsumer == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(2);
        }
        return throwableConsumer;
    }

    @NotNull
    public static ThrowableConsumer<OutputStream, IOException> writeLines(@NotNull Collection<String> lines, @NotNull String separator, @NotNull Charset charset, boolean endWithSecondSeparator) {
        if (lines == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(3);
        }
        if (separator == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(4);
        }
        if (charset == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(5);
        }
        ThrowableConsumer throwableConsumer = stream -> {
            if (charset == null) {
                GitHandlerInputProcessorUtil.$$$reportNull$$$0(10);
            }
            if (lines == null) {
                GitHandlerInputProcessorUtil.$$$reportNull$$$0(11);
            }
            if (separator == null) {
                GitHandlerInputProcessorUtil.$$$reportNull$$$0(12);
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);
            try {
                for (String line : lines) {
                    writer.write(line);
                    writer.write(separator);
                }
                if (endWithSecondSeparator) {
                    writer.write(separator);
                }
                writer.flush();
            }
            finally {
                if (!SystemInfo.isWindows || !endWithSecondSeparator) {
                    writer.close();
                }
            }
        };
        if (throwableConsumer == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(6);
        }
        return throwableConsumer;
    }

    @NotNull
    public static ThrowableConsumer<OutputStream, IOException> redirectStream(@NotNull InputStream stream) {
        if (stream == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(7);
        }
        ThrowableConsumer throwableConsumer = outputStream -> {
            if (stream == null) {
                GitHandlerInputProcessorUtil.$$$reportNull$$$0(9);
            }
            try {
                FileUtil.copy((InputStream)stream, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
        };
        if (throwableConsumer == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(8);
        }
        return throwableConsumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitHandlerInputProcessorUtil";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitHandlerInputProcessorUtil";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "writeLines";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "redirectStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeLines";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "redirectStream";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$redirectStream$1";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$writeLines$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

