/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.BlockType;
import com.github.rjeschke.txtmark.Line;

class Block {
    public BlockType type = BlockType.NONE;
    public Line lines = null;
    public Line lineTail = null;
    public Block blocks = null;
    public Block blockTail = null;
    public Block next = null;
    public int hlDepth = 0;
    public String id = null;
    public String meta = "";

    public boolean hasLines() {
        return this.lines != null;
    }

    public void removeSurroundingEmptyLines() {
        if (this.lines != null) {
            this.removeTrailingEmptyLines();
            this.removeLeadingEmptyLines();
        }
    }

    public void transfromHeadline() {
        int start;
        if (this.hlDepth > 0) {
            return;
        }
        int level = 0;
        Line line = this.lines;
        if (line.isEmpty) {
            return;
        }
        for (start = line.leading; start < line.value.length() && line.value.charAt(start) == '#'; ++start) {
            ++level;
        }
        while (start < line.value.length() && line.value.charAt(start) == ' ') {
            ++start;
        }
        if (start >= line.value.length()) {
            line.setEmpty();
        } else {
            int end = line.value.length() - line.trailing - 1;
            while (line.value.charAt(end) == '#') {
                --end;
            }
            while (line.value.charAt(end) == ' ') {
                --end;
            }
            line.value = line.value.substring(start, end + 1);
            line.trailing = 0;
            line.leading = 0;
        }
        this.hlDepth = Math.min(level, 6);
    }

    public void removeListIndent(boolean extendedMode) {
        Line line = this.lines;
        while (line != null) {
            if (!line.isEmpty) {
                switch (line.getLineType(extendedMode)) {
                    case ULIST: {
                        line.value = line.value.substring(line.leading + 2);
                        break;
                    }
                    case OLIST: {
                        line.value = line.value.substring(line.value.indexOf(46) + 2);
                        break;
                    }
                    default: {
                        line.value = line.value.substring(Math.min(line.leading, 4));
                    }
                }
                line.initLeading();
            }
            line = line.next;
        }
    }

    public void removeBlockQuotePrefix() {
        Line line = this.lines;
        while (line != null) {
            if (!line.isEmpty && line.value.charAt(line.leading) == '>') {
                int rem = line.leading + 1;
                if (line.leading + 1 < line.value.length() && line.value.charAt(line.leading + 1) == ' ') {
                    ++rem;
                }
                line.value = line.value.substring(rem);
                line.initLeading();
            }
            line = line.next;
        }
    }

    public boolean removeLeadingEmptyLines() {
        boolean wasEmpty = false;
        Line line = this.lines;
        while (line != null && line.isEmpty) {
            this.removeLine(line);
            line = this.lines;
            wasEmpty = true;
        }
        return wasEmpty;
    }

    public void removeTrailingEmptyLines() {
        Line line = this.lineTail;
        while (line != null && line.isEmpty) {
            this.removeLine(line);
            line = this.lineTail;
        }
    }

    public Block split(Line line) {
        Block block = new Block();
        block.lines = this.lines;
        block.lineTail = line;
        this.lines = line.next;
        line.next = null;
        if (this.lines == null) {
            this.lineTail = null;
        } else {
            this.lines.previous = null;
        }
        if (this.blocks == null) {
            this.blocks = this.blockTail = block;
        } else {
            this.blockTail.next = block;
            this.blockTail = block;
        }
        return block;
    }

    public void removeLine(Line line) {
        if (line.previous == null) {
            this.lines = line.next;
        } else {
            line.previous.next = line.next;
        }
        if (line.next == null) {
            this.lineTail = line.previous;
        } else {
            line.next.previous = line.previous;
        }
        line.next = null;
        line.previous = null;
    }

    public void appendLine(Line line) {
        if (this.lineTail == null) {
            this.lines = this.lineTail = line;
        } else {
            this.lineTail.nextEmpty = line.isEmpty;
            line.prevEmpty = this.lineTail.isEmpty;
            line.previous = this.lineTail;
            this.lineTail.next = line;
            this.lineTail = line;
        }
    }

    public void expandListParagraphs() {
        Block inner;
        if (this.type != BlockType.ORDERED_LIST && this.type != BlockType.UNORDERED_LIST) {
            return;
        }
        Block outer = this.blocks;
        boolean hasParagraph = false;
        while (outer != null && !hasParagraph) {
            if (outer.type == BlockType.LIST_ITEM) {
                inner = outer.blocks;
                while (inner != null && !hasParagraph) {
                    if (inner.type == BlockType.PARAGRAPH) {
                        hasParagraph = true;
                    }
                    inner = inner.next;
                }
            }
            outer = outer.next;
        }
        if (hasParagraph) {
            outer = this.blocks;
            while (outer != null) {
                if (outer.type == BlockType.LIST_ITEM) {
                    inner = outer.blocks;
                    while (inner != null) {
                        if (inner.type == BlockType.NONE) {
                            inner.type = BlockType.PARAGRAPH;
                        }
                        inner = inner.next;
                    }
                }
                outer = outer.next;
            }
        }
    }
}

