/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.highlighting;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.Consumer;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightUsagesHandlerBase;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHighlightOverridingMethodsHandler
extends PhpHighlightUsagesHandlerBase<PhpClass> {
    private final PsiElement myTarget;
    private final PhpClass myClass;
    private final List<? extends ClassReference> myReferences;

    public PhpHighlightOverridingMethodsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target, @NotNull PhpClass aClass, @NotNull List<? extends ClassReference> references) {
        if (editor == null) {
            PhpHighlightOverridingMethodsHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpHighlightOverridingMethodsHandler.$$$reportNull$$$0(1);
        }
        if (target == null) {
            PhpHighlightOverridingMethodsHandler.$$$reportNull$$$0(2);
        }
        if (aClass == null) {
            PhpHighlightOverridingMethodsHandler.$$$reportNull$$$0(3);
        }
        if (references == null) {
            PhpHighlightOverridingMethodsHandler.$$$reportNull$$$0(4);
        }
        super(editor, file);
        this.myTarget = target;
        this.myClass = aClass;
        this.myReferences = references;
    }

    public List<PhpClass> getTargets() {
        return StreamEx.of(this.myReferences).map(PsiReference::resolve).select(PhpClass.class).toList();
    }

    protected void selectTargets(List<PhpClass> targets, Consumer<List<PhpClass>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    public void computeUsages(List<PhpClass> targets) {
        this.addOccurrence(this.myTarget);
        for (Method method : this.myClass.getOwnMethods()) {
            if (!targets.stream().anyMatch(phpClass -> phpClass.findMethodByName((CharSequence)method.getName()) != null)) continue;
            this.addOccurrence((PsiElement)method);
        }
    }

    @Nullable
    public String getFeatureId() {
        return "codeassists.highlight.implements";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "references";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightOverridingMethodsHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

