/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpUndefinedMemberInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodTagQuickFix;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUndefinedMethodInspection
extends PhpUndefinedMemberInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpAddMethodDeclarationQuickFix.INSTANCE, PhpAddMethodTagQuickFix.INSTANCE};
    private static final String UNDEFINED_METHOD_REF = "Method '#ref' not found in ";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUndefinedMethodInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference reference) {
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                PhpExpression classReference = reference.getClassReference();
                if (classReference == null) {
                    return;
                }
                PsiElement psi = nameNode.getPsi();
                if (MemberReferenceImpl.getDepth(classReference) == 100) {
                    holder.registerProblem(psi, "Call chain is too long to analyse, please break into fragments of up to 100 calls", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                    return;
                }
                if (classReference instanceof PhpReference && ((PhpReference)classReference).multiResolve(false).length == 0) {
                    return;
                }
                Project project = reference.getProject();
                PhpType type = classReference.getType().global(project);
                if (PhpType.isSubType((PhpType)PhpType.MIXED, (PhpType)type) || PhpType.isSubType((PhpType)PhpType.OBJECT, (PhpType)type)) {
                    return;
                }
                CharSequence methodName = reference.getNameCS();
                if (methodName != null && this.isSuppressed(reference, classReference, methodName)) {
                    return;
                }
                PhpIndex index = PhpIndex.getInstance((Project)project);
                if (reference.multiResolve(false).length == 0) {
                    String template;
                    boolean hasMagic = false;
                    if (PhpUndefinedMethodInspection.this.isDowngradeSeverity()) {
                        hasMagic = PhpCodeInsightUtil.hasMagicMethod(type, index, reference.isStatic() ? "__callStatic" : "__call");
                    }
                    assert (psi != null);
                    LocalQuickFix[] fixes = PhpUndefinedMethodInspection.isQuickFixApplicable(psi, isOnTheFly) ? FIXES : LocalQuickFix.EMPTY_ARRAY;
                    String string = template = isOnTheFly ? PhpUndefinedMethodInspection.UNDEFINED_METHOD_REF + type.toStringRelativized(reference.getNamespaceName()) : PhpUndefinedMethodInspection.UNDEFINED_METHOD_REF;
                    if (PhpUndefinedMethodInspection.this.isDowngradeSeverity() && hasMagic) {
                        holder.registerProblem(psi, template, ProblemHighlightType.WEAK_WARNING, fixes);
                    } else {
                        holder.registerProblem(psi, template, fixes);
                    }
                }
            }

            private boolean isSuppressed(@NotNull MethodReference methodReference, @NotNull PhpExpression classReference, @NotNull CharSequence methodName) {
                PhpCallInstruction instruction;
                if (methodReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (classReference == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (methodName == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((instruction = PhpControlFlowUtil.getCallInstruction((FunctionReference)methodReference)) != null) {
                    Ref canBeDefined = Ref.create((Object)false);
                    Ref canBeUndefined = Ref.create((Object)false);
                    PhpMethodExistsReachingDFAnalyzer analyzer = new PhpMethodExistsReachingDFAnalyzer(classReference, methodName);
                    PhpDFAUtil.performReachingDefinition((PhpInstruction)instruction, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, analyzer);
                    return (Boolean)canBeDefined.get() != false && (Boolean)canBeUndefined.get() == false;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "methodReference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "classReference";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "methodName";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection$1";
                objectArray[2] = "isSuppressed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (phpElementVisitor == null) {
            PhpUndefinedMethodInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static boolean isQuickFixApplicable(@NotNull PsiElement element, boolean isOnTheFly) {
        if (element == null) {
            PhpUndefinedMethodInspection.$$$reportNull$$$0(2);
        }
        return isOnTheFly && element.getContainingFile().isWritable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isQuickFixApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpMethodExistsReachingDFAnalyzer
    extends PhpReachingDefinitionDFAnalyzer {
        private static final String METHOD_EXISTS = "method_exists";
        private final PhpExpression myClassReference;
        private final CharSequence myMethodName;

        private PhpMethodExistsReachingDFAnalyzer(@Nullable PhpExpression classReference, @NotNull CharSequence methodName) {
            if (methodName == null) {
                PhpMethodExistsReachingDFAnalyzer.$$$reportNull$$$0(0);
            }
            this.myClassReference = classReference;
            this.myMethodName = methodName;
        }

        @Override
        @NotNull
        protected PhpReachingDefinitionDFAnalyzer.Result performDFA(@Nullable PsiElement condition, boolean result) {
            PsiElement[] parameters;
            FunctionReference functionReference;
            if (condition instanceof FunctionReference && !(condition instanceof MethodReference) && PhpLangUtil.equalsFunctionNames(METHOD_EXISTS, (functionReference = (FunctionReference)condition).getName()) && (parameters = functionReference.getParameters()).length > 1) {
                PsiElement method;
                String methodName;
                PsiElement classReference = parameters[0];
                String classReferenceText = classReference.getText();
                if (PhpLangUtil.equalsVariableNames(this.myClassReference.getText(), classReferenceText) && PhpLangUtil.equalsMethodNames(methodName = PhpCodeInsightUtil.toString(method = parameters[1], false), this.myMethodName)) {
                    PhpReachingDefinitionDFAnalyzer.Result dfaResult = new PhpReachingDefinitionDFAnalyzer.Result();
                    if (result) {
                        dfaResult.setDefined(true);
                    } else {
                        dfaResult.setUndefined(true);
                    }
                    PhpReachingDefinitionDFAnalyzer.Result result2 = dfaResult;
                    if (result2 == null) {
                        PhpMethodExistsReachingDFAnalyzer.$$$reportNull$$$0(1);
                    }
                    return result2;
                }
            }
            PhpReachingDefinitionDFAnalyzer.Result result3 = (PhpReachingDefinitionDFAnalyzer.Result)super.performDFA(condition, result);
            if (result3 == null) {
                PhpMethodExistsReachingDFAnalyzer.$$$reportNull$$$0(2);
            }
            return result3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection$PhpMethodExistsReachingDFAnalyzer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUndefinedMethodInspection$PhpMethodExistsReachingDFAnalyzer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performDFA";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

