/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpVoidFunctionResultUsedInspection
extends PhpInspection {
    public static final String PROBLEM_1_DESCRIPTION = "inspection.void.function.result.used.problem1";
    public static final String PROBLEM_2_DESCRIPTION = "inspection.void.function.result.used.problem2";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                PhpVoidFunctionResultUsedInspection.analyzeCall(reference, holder, PhpVoidFunctionResultUsedInspection.PROBLEM_1_DESCRIPTION);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                if (PhpPsiUtil.isOfType(reference.getParent(), PhpStubElementTypes.TRAIT_USE_RULE)) {
                    return;
                }
                PhpVoidFunctionResultUsedInspection.analyzeCall((FunctionReference)reference, holder, PhpVoidFunctionResultUsedInspection.PROBLEM_2_DESCRIPTION);
            }
        };
        if (phpElementVisitor == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static void analyzeCall(@NotNull FunctionReference reference, @NotNull ProblemsHolder holder, @NotNull String problemDescription) {
        PhpType functionType;
        String name;
        if (reference == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(3);
        }
        if (problemDescription == null) {
            PhpVoidFunctionResultUsedInspection.$$$reportNull$$$0(4);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(name = reference.getName())) && PhpType.VOID.equals((Object)(functionType = reference.getType().global(holder.getProject())))) {
            PsiElement parent = reference.getParent();
            if (parent instanceof BinaryExpression) {
                BinaryExpression binaryExpression = (BinaryExpression)parent;
                PsiElement rightOperand = binaryExpression.getRightOperand();
                if (rightOperand == reference && PhpLangUtil.isShortCircuitOperator(binaryExpression.getOperationType()) && PhpCodeInsightUtil.isResultUsed(parent)) {
                    holder.registerProblem((PsiElement)reference, PhpBundle.message(problemDescription, name), new LocalQuickFix[0]);
                }
            } else if (PhpCodeInsightUtil.isResultUsed((PsiElement)reference)) {
                holder.registerProblem((PsiElement)reference, PhpBundle.message(problemDescription, name), new LocalQuickFix[0]);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpVoidFunctionResultUsedInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpVoidFunctionResultUsedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "analyzeCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

