/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayFilterInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertLoopToArrayMapQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLoopCanBeConvertedToArrayFillInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpLoopCanBeConvertedToArrayFillInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFor(For forStatement) {
                Variable variable = PhpLoopCanBeConvertedToArrayFillInspection.getInitialVariable(forStatement);
                if (variable == null) {
                    return;
                }
                Variable conditionalVariable = PhpLoopCanBeConvertedToArrayFillInspection.getConditionalVariable(forStatement);
                String variableName = variable.getName();
                if (conditionalVariable == null || !StringUtil.equals((CharSequence)variableName, (CharSequence)conditionalVariable.getName())) {
                    return;
                }
                Variable incrementedVariable = PhpLoopCanBeConvertedToArrayFillInspection.getIncrementedVariable(forStatement);
                if (incrementedVariable == null || !StringUtil.equals((CharSequence)variableName, (CharSequence)incrementedVariable.getName())) {
                    return;
                }
                String arrayName = PhpLoopCanBeConvertedToArrayFilterInspection.getEmptyArrayNameDeclaredBeforeLoop((PsiElement)forStatement);
                if (PhpLoopCanBeConvertedToArrayFillInspection.isArrayFillingByIndex(PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(forStatement.getStatement()), variableName, arrayName)) {
                    holder.registerProblem(forStatement.getFirstChild(), PhpBundle.message("inspection.loop.can.be.converted.to.arrayfill", new Object[0]), new LocalQuickFix[]{PhpConvertLoopToArrayFillQuickFix.INSTANCE});
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpLoopCanBeConvertedToArrayFillInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static boolean isArrayFillingByIndex(@Nullable Statement statement, @NotNull String indexName, @Nullable String arrayName) {
        AssignmentExpression assignmentExpression;
        if (indexName == null) {
            PhpLoopCanBeConvertedToArrayFillInspection.$$$reportNull$$$0(2);
        }
        if (statement != null && arrayName != null && (assignmentExpression = (AssignmentExpression)ObjectUtils.tryCast((Object)statement.getFirstPsiChild(), AssignmentExpression.class)) != null && !(assignmentExpression instanceof SelfAssignmentExpression)) {
            ArrayAccessExpression fromArray = (ArrayAccessExpression)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), ArrayAccessExpression.class);
            return PhpLoopCanBeConvertedToArrayFilterInspection.hasName(fromArray, arrayName) && PhpLoopCanBeConvertedToArrayFilterInspection.accessByVariableName(fromArray, indexName) && PhpLoopCanBeConvertedToArrayFillInspection.isScalarOrVariable((PsiElement)assignmentExpression.getValue(), 0, indexName, arrayName);
        }
        return false;
    }

    public static boolean isScalarOrVariable(@Nullable PsiElement value, int stack, String ... forbiddenVariableNames) {
        if (forbiddenVariableNames == null) {
            PhpLoopCanBeConvertedToArrayFillInspection.$$$reportNull$$$0(3);
        }
        if (stack > 200 || !(value instanceof PhpPsiElement)) {
            return false;
        }
        if (value instanceof Variable) {
            return !ContainerUtil.newHashSet((Object[])forbiddenVariableNames).contains(((PhpPsiElement)value).getName());
        }
        if (value instanceof ArrayCreationExpression) {
            return StreamEx.of((Object[])value.getChildren()).select(PhpPsiElement.class).map(c -> c.getFirstPsiChild()).allMatch(c -> {
                if (forbiddenVariableNames == null) {
                    PhpLoopCanBeConvertedToArrayFillInspection.$$$reportNull$$$0(7);
                }
                return PhpLoopCanBeConvertedToArrayFillInspection.isScalarOrVariable((PsiElement)c, stack + 1, forbiddenVariableNames);
            });
        }
        if (value instanceof BinaryExpression) {
            return PhpLoopCanBeConvertedToArrayFillInspection.isScalarOrVariable(((BinaryExpression)value).getLeftOperand(), stack + 1, forbiddenVariableNames) && PhpLoopCanBeConvertedToArrayFillInspection.isScalarOrVariable(((BinaryExpression)value).getRightOperand(), stack + 1, forbiddenVariableNames);
        }
        if (value instanceof TernaryExpression) {
            return PhpLoopCanBeConvertedToArrayFillInspection.isScalarOrVariable((PsiElement)((TernaryExpression)value).getTrueVariant(), stack + 1, forbiddenVariableNames) && PhpLoopCanBeConvertedToArrayFillInspection.isScalarOrVariable((PsiElement)((TernaryExpression)value).getFalseVariant(), stack + 1, forbiddenVariableNames) && PhpLoopCanBeConvertedToArrayFillInspection.isScalarOrVariable((PsiElement)((TernaryExpression)value).getCondition(), stack + 1, forbiddenVariableNames);
        }
        return !(value instanceof ParameterListOwner);
    }

    @Nullable
    public static Variable getIncrementedVariable(@NotNull For forStatement) {
        UnaryExpression expression;
        PhpPsiElement[] expressions;
        if (forStatement == null) {
            PhpLoopCanBeConvertedToArrayFillInspection.$$$reportNull$$$0(4);
        }
        if ((expressions = forStatement.getRepeatedExpressions()).length == 1 && (expression = (UnaryExpression)ObjectUtils.tryCast((Object)expressions[0], UnaryExpression.class)) != null && PhpPsiUtil.isOfType(expression.getOperation(), PhpTokenTypes.opINCREMENT)) {
            return (Variable)ObjectUtils.tryCast((Object)expression.getValue(), Variable.class);
        }
        return null;
    }

    @Nullable
    public static Variable getInitialVariable(@NotNull For forStatement) {
        AssignmentExpression expression;
        PhpPsiElement[] expressions;
        if (forStatement == null) {
            PhpLoopCanBeConvertedToArrayFillInspection.$$$reportNull$$$0(5);
        }
        if ((expressions = forStatement.getInitialExpressions()).length == 1 && (expression = (AssignmentExpression)ObjectUtils.tryCast((Object)expressions[0], AssignmentExpression.class)) != null && PhpPsiUtil.isOfType((PsiElement)expression.getValue(), new IElementType[]{PhpElementTypes.NUMBER, PhpStubElementTypes.VARIABLE})) {
            return (Variable)ObjectUtils.tryCast((Object)expression.getVariable(), Variable.class);
        }
        return null;
    }

    @Nullable
    public static Variable getConditionalVariable(@NotNull For forStatement) {
        BinaryExpression expression;
        PhpPsiElement[] expressions;
        if (forStatement == null) {
            PhpLoopCanBeConvertedToArrayFillInspection.$$$reportNull$$$0(6);
        }
        if ((expressions = forStatement.getConditionalExpressions()).length == 1 && (expression = (BinaryExpression)ObjectUtils.tryCast((Object)expressions[0], BinaryExpression.class)) != null && PhpPsiUtil.isOfType(expression.getOperation(), PhpTokenTypes.opLESS, PhpTokenTypes.opLESS_OR_EQUAL) && PhpPsiUtil.isOfType(expression.getRightOperand(), new IElementType[]{PhpElementTypes.NUMBER, PhpStubElementTypes.VARIABLE})) {
            return (Variable)ObjectUtils.tryCast((Object)expression.getLeftOperand(), Variable.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayFillInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forbiddenVariableNames";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayFillInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isArrayFillingByIndex";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isScalarOrVariable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIncrementedVariable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInitialVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConditionalVariable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isScalarOrVariable$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpConvertLoopToArrayFillQuickFix
    extends PhpQuickFixBase {
        private static final PhpConvertLoopToArrayFillQuickFix INSTANCE = new PhpConvertLoopToArrayFillQuickFix();
        private final String NAME = PhpBundle.message("quickfix.convert.loop.to.arrayfilll", new Object[0]);

        private PhpConvertLoopToArrayFillQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.NAME;
            if (string == null) {
                PhpConvertLoopToArrayFillQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            BinaryExpression condition;
            PhpPsiElement initialValue;
            String resultArrayName;
            For forStatement;
            if (project == null) {
                PhpConvertLoopToArrayFillQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpConvertLoopToArrayFillQuickFix.$$$reportNull$$$0(2);
            }
            if ((forStatement = (For)PhpPsiUtil.getParentByCondition(descriptor.getStartElement(), false, (Condition<? super PsiElement>)For.INSTANCEOF)) == null) {
                return;
            }
            Statement prevStatement = (Statement)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)forStatement, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            AssignmentExpression emptyArrayDeclaration = PhpLoopCanBeConvertedToArrayMapInspection.getEmptyArrayDeclaration(prevStatement);
            PhpPsiElement resultArray = emptyArrayDeclaration != null ? emptyArrayDeclaration.getVariable() : null;
            String string = resultArrayName = resultArray != null ? resultArray.getName() : null;
            if (resultArrayName == null) {
                return;
            }
            Variable initialVariable = PhpLoopCanBeConvertedToArrayFillInspection.getInitialVariable(forStatement);
            AssignmentExpression initialAssignment = initialVariable != null ? (AssignmentExpression)ObjectUtils.tryCast((Object)initialVariable.getParent(), AssignmentExpression.class) : null;
            PhpPsiElement phpPsiElement = initialValue = initialAssignment != null ? initialAssignment.getValue() : null;
            if (initialValue == null) {
                return;
            }
            Variable conditionalVariable = PhpLoopCanBeConvertedToArrayFillInspection.getConditionalVariable(forStatement);
            BinaryExpression binaryExpression = condition = conditionalVariable != null ? (BinaryExpression)ObjectUtils.tryCast((Object)conditionalVariable.getParent(), BinaryExpression.class) : null;
            if (condition == null) {
                return;
            }
            boolean includingLimit = PhpPsiUtil.isOfType(condition.getOperation(), PhpTokenTypes.opLESS_OR_EQUAL);
            PsiElement limitValue = condition.getRightOperand();
            if (limitValue == null) {
                return;
            }
            PsiElement pushValue = PhpConvertLoopToArrayMapQuickFix.getArrayPushValue(forStatement.getStatement());
            if (pushValue == null) {
                return;
            }
            Statement arrayFillStatement = PhpConvertLoopToArrayFillQuickFix.createArrayFillStatement(project, pushValue.getText(), resultArrayName, initialValue.getText(), limitValue.getText(), includingLimit);
            if (arrayFillStatement != null) {
                PhpConvertLoopToArrayMapQuickFix.restoreComments((PsiElement)forStatement);
                forStatement.replace((PsiElement)arrayFillStatement);
                prevStatement.delete();
            }
        }

        @Nullable
        private static Statement createArrayFillStatement(@NotNull Project project, @NotNull String pushValue, @NotNull String arrayName, @NotNull String initialValueText, @NotNull String limitValueText, boolean includeLimit) {
            if (project == null) {
                PhpConvertLoopToArrayFillQuickFix.$$$reportNull$$$0(3);
            }
            if (pushValue == null) {
                PhpConvertLoopToArrayFillQuickFix.$$$reportNull$$$0(4);
            }
            if (arrayName == null) {
                PhpConvertLoopToArrayFillQuickFix.$$$reportNull$$$0(5);
            }
            if (initialValueText == null) {
                PhpConvertLoopToArrayFillQuickFix.$$$reportNull$$$0(6);
            }
            if (limitValueText == null) {
                PhpConvertLoopToArrayFillQuickFix.$$$reportNull$$$0(7);
            }
            try {
                String num = limitValueText.startsWith("$") || initialValueText.startsWith("$") ? limitValueText + "-" + initialValueText + (includeLimit ? "+1" : "") : String.valueOf(Integer.parseInt(limitValueText) - Integer.parseInt(initialValueText) + (includeLimit ? 1 : 0));
                return PhpPsiElementFactory.createStatement(project, String.format("$%s = array_fill(%s, %s, %s);", arrayName, initialValueText, num, pushValue));
            }
            catch (NumberFormatException exception) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayFillInspection$PhpConvertLoopToArrayFillQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pushValue";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialValueText";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "limitValueText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayFillInspection$PhpConvertLoopToArrayFillQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createArrayFillStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

