/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.surroundWith;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Statement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

abstract class PhpStatementSurrounder<T extends PsiElement>
implements Surrounder {
    PhpStatementSurrounder() {
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(0);
        }
        for (PsiElement it : elements) {
            if (!PhpLangUtil.isShortEchoTagStatement(it) && !PhpPsiUtil.isOfType(it, PhpElementTypes.CASE, PhpElementTypes.CASE_DEFAULT)) continue;
            return false;
        }
        if (elements.length > 0) {
            IElementType firstType = elements[0].getNode().getElementType();
            IElementType lastType = elements[elements.length - 1].getNode().getElementType();
            if (firstType == PhpTokenTypes.chRBRACE || lastType == PhpTokenTypes.chLBRACE) {
                return false;
            }
        }
        return true;
    }

    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        if (project == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(3);
        }
        return this.surroundElements(project, elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextRange surroundElements(@NotNull Project project, @NotNull PsiElement[] elements) {
        if (project == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(5);
        }
        T template = this.createStatement(project, elements);
        PsiElement lastElement = elements[elements.length - 1];
        PsiElement container = lastElement.getParent();
        PsiElement statement = container.addAfter(template, lastElement);
        PsiElement insertInto = this.getInsertInto(statement);
        PsiElement anchor = insertInto.getLastChild();
        for (PsiElement element : elements) {
            if (element instanceof PsiWhiteSpace) continue;
            PsiElement childCopy = element.copy();
            element.delete();
            insertInto.addBefore(childCopy, anchor);
        }
        this.postProcess(statement);
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(statement);
        PsiFile file = statement.getContainingFile();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = manager.getDocument(file);
        if (document != null) {
            RangeMarker marker = document.createRangeMarker(statement.getTextRange());
            try {
                PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting(file.getViewProvider());
                CodeStyleManager csManager = CodeStyleManager.getInstance((Project)project);
                csManager.reformatText(file, marker.getStartOffset(), marker.getEndOffset());
            }
            finally {
                marker.dispose();
            }
            if (manager.isUncommited(document)) {
                manager.commitDocument(document);
            }
        }
        return this.getSurroundSelectionRange(pointer.getElement());
    }

    @NotNull
    protected T createStatement(@NotNull Project project, @NotNull PsiElement[] elements) {
        if (project == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(6);
        }
        if (elements == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(7);
        }
        Statement statement = PhpPsiElementFactory.createStatement(project, this.getStatementTemplate(project, elements));
        if (statement == null) {
            PhpStatementSurrounder.$$$reportNull$$$0(8);
        }
        return (T)statement;
    }

    @NonNls
    protected abstract String getStatementTemplate(Project var1, PsiElement[] var2);

    protected abstract PsiElement getInsertInto(T var1);

    protected void postProcess(T statement) {
    }

    protected abstract TextRange getSurroundSelectionRange(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/surroundWith/PhpStatementSurrounder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/surroundWith/PhpStatementSurrounder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "surroundElements";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createStatement";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

