/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util.pathmapper;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.util.PhpStringUtil;
import com.jetbrains.php.util.pathmapper.PhpEmptyPathMapper;
import com.jetbrains.php.util.pathmapper.PhpIdenticalPathMapper;
import com.jetbrains.php.util.pathmapper.PhpLocalPathMapper;
import com.jetbrains.php.util.pathmapper.PhpRemotePathMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpPathMapper {
    public static PhpPathMapper create(@NotNull Project project) {
        if (project == null) {
            PhpPathMapper.$$$reportNull$$$0(0);
        }
        return new PhpLocalPathMapper(project);
    }

    public static PhpPathMapper createDefaultMapper() {
        return new PhpIdenticalPathMapper();
    }

    public static PhpPathMapper create(@NotNull PhpServer server) {
        if (server == null) {
            PhpPathMapper.$$$reportNull$$$0(1);
        }
        return new PhpRemotePathMapper(server);
    }

    public static PhpPathMapper create(@NotNull List<PathMappingSettings.PathMapping> mapping) {
        if (mapping == null) {
            PhpPathMapper.$$$reportNull$$$0(2);
        }
        return new PhpRemotePathMapper(mapping);
    }

    public static PhpPathMapper create() {
        return PhpEmptyPathMapper.EMPTY_PATH_MAPPER;
    }

    @Nullable
    public abstract String getRemoteFilePath(@NotNull String var1);

    @Nullable
    public final String getRemoteFilePath(@NotNull VirtualFile localFile) {
        if (localFile == null) {
            PhpPathMapper.$$$reportNull$$$0(3);
        }
        return this.getRemoteFilePath(localFile.getUrl());
    }

    @Nullable
    public abstract String getLocalPath(@NotNull String var1);

    @Nullable
    public abstract VirtualFile getLocalFile(@NotNull String var1);

    @NotNull
    public static String createFilePath(@NotNull String[] localSegmentedPath) {
        if (localSegmentedPath == null) {
            PhpPathMapper.$$$reportNull$$$0(4);
        }
        String string = PhpPathMapper.createFilePath(localSegmentedPath, localSegmentedPath.length);
        if (string == null) {
            PhpPathMapper.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String createFilePath(@NotNull String[] localSegmentedPath, int length) {
        if (localSegmentedPath == null) {
            PhpPathMapper.$$$reportNull$$$0(6);
        }
        if (length > 0) {
            boolean isWindows = FileUtil.isWindowsAbsolutePath((String)localSegmentedPath[0]);
            String separator = isWindows ? "\\" : "/";
            String path = StringUtil.join((String[])localSegmentedPath, (int)0, (int)length, (String)separator);
            String string = !isWindows ? separator + path : path;
            if (string == null) {
                PhpPathMapper.$$$reportNull$$$0(7);
            }
            return string;
        }
        if ("/" == null) {
            PhpPathMapper.$$$reportNull$$$0(8);
        }
        return "/";
    }

    @NotNull
    public static String[] getPath(@NotNull String originalPath) {
        if (originalPath == null) {
            PhpPathMapper.$$$reportNull$$$0(9);
        }
        ArrayList<String> paths = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(originalPath, "/\\");
        while (st.hasMoreTokens()) {
            String segment = st.nextToken();
            if (segment.length() <= 0) continue;
            paths.add(segment);
        }
        String[] stringArray = ArrayUtil.toStringArray(paths);
        if (stringArray == null) {
            PhpPathMapper.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    @NotNull
    public static String[] intersectFromEnd(@NotNull String path1, @NotNull String path2, boolean caseSensitive) {
        if (path1 == null) {
            PhpPathMapper.$$$reportNull$$$0(11);
        }
        if (path2 == null) {
            PhpPathMapper.$$$reportNull$$$0(12);
        }
        String[] stringArray = PhpStringUtil.intersectFromEnd(PhpPathMapper.getPath(path1), PhpPathMapper.getPath(path2), caseSensitive);
        if (stringArray == null) {
            PhpPathMapper.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    @NotNull
    public static String urlToPath(@NotNull String fileUriOrPath) {
        if (fileUriOrPath == null) {
            PhpPathMapper.$$$reportNull$$$0(14);
        }
        String string = PhpPathMapper.createFilePath(PhpPathMapper.getPath(VirtualFileManager.extractPath((String)fileUriOrPath)));
        if (string == null) {
            PhpPathMapper.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSegmentedPath";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/util/pathmapper/PhpPathMapper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUriOrPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/util/pathmapper/PhpPathMapper";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectFromEnd";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteFilePath";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFilePath";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "intersectFromEnd";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "urlToPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

