/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LanguageTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.JspSupportProxy;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;

public class TagPanel
extends AbstractInjectionPanel<AbstractTagInjection> {
    public static final Key<List<String>> URI_MODEL = Key.create((String)"URI_MODEL");
    private JPanel myRoot;
    private EditorTextField myLocalName;
    private ComboBox myNamespace;
    private JCheckBox myWithSubtags;

    public TagPanel(Project project, AbstractTagInjection injection) {
        super(injection, project);
        this.$$$setupUI$$$();
        this.myNamespace.setModel(TagPanel.createNamespaceUriModel(this.myProject));
    }

    public static ComboBoxModel createNamespaceUriModel(Project project) {
        List data = (List)project.getUserData(URI_MODEL);
        if (data != null) {
            return new DefaultComboBoxModel<Object>(data.toArray());
        }
        ArrayList<String> urls = new ArrayList<String>(Arrays.asList(ExternalResourceManager.getInstance().getResourceUrls(null, true)));
        Collections.sort(urls);
        JspSupportProxy jspSupport = JspSupportProxy.getInstance();
        if (jspSupport != null) {
            Module[] modules;
            ArrayList<String> tlds = new ArrayList<String>();
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                String[] tldUris;
                for (String uri : tldUris = (String[])ReadAction.compute(() -> jspSupport.getPossibleTldUris(module))) {
                    if (tlds.contains(uri)) continue;
                    tlds.add(uri);
                }
            }
            Collections.sort(tlds);
            urls.addAll(0, tlds);
        }
        project.putUserData(URI_MODEL, urls);
        return new DefaultComboBoxModel<Object>(urls.toArray());
    }

    @Override
    public JPanel getComponent() {
        return this.myRoot;
    }

    @Override
    protected void resetImpl() {
        this.myLocalName.setText(((AbstractTagInjection)this.myOrigInjection).getTagName());
        this.myNamespace.getEditor().setItem(((AbstractTagInjection)this.myOrigInjection).getTagNamespace());
        this.myWithSubtags.setSelected(((AbstractTagInjection)this.myOrigInjection).isApplyToSubTags());
    }

    @Override
    protected void apply(AbstractTagInjection other) {
        other.setTagName(this.myLocalName.getText());
        other.setTagNamespace(this.getNamespace());
        other.setApplyToSubTags(this.myWithSubtags.isSelected());
    }

    private String getNamespace() {
        String s = (String)this.myNamespace.getEditor().getItem();
        return s != null ? s : "";
    }

    private void createUIComponents() {
        this.myLocalName = new LanguageTextField((Language)RegExpLanguage.INSTANCE, this.myProject, ((AbstractTagInjection)this.myOrigInjection).getTagName());
        this.myNamespace = new ComboBox(200);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"XML Tag", (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Local name:");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Namespace:");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myLocalName;
        jPanel2.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        ComboBox comboBox = this.myNamespace;
        comboBox.setEditable(true);
        jPanel2.add((Component)comboBox, new GridConstraints(1, 1, 1, 2, 8, 1, 7, 0, null, null, null));
        this.myWithSubtags = jCheckBox = new JCheckBox();
        jCheckBox.setText("Sub-tags");
        jCheckBox.setMnemonic('T');
        jCheckBox.setDisplayedMnemonicIndex(4);
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor((Component)editorTextField);
        jLabel2.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

