/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBCommandRunner;
import org.jetbrains.dekaf.core.DBLeasedSession;
import org.jetbrains.dekaf.core.DBQueryRunner;
import org.jetbrains.dekaf.core.DBScriptRunner;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.core.ResultLayout;
import org.jetbrains.dekaf.exceptions.DBSessionIsClosedException;
import org.jetbrains.dekaf.sql.SqlCommand;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.sql.SqlScript;

class DBLeasedSessionWrapper
implements DBLeasedSession {
    private DBLeasedSession myOriginalSession;

    DBLeasedSessionWrapper(@NotNull DBLeasedSession originalSession) {
        this.myOriginalSession = originalSession;
    }

    private void checkIsNotClosed() {
        if (this.myOriginalSession == null) {
            throw new DBSessionIsClosedException("The session is already closed or returned back.");
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.myOriginalSession == null || this.myOriginalSession.isClosed();
    }

    @Override
    public synchronized void close() {
        DBLeasedSession theSessionToClose = this.myOriginalSession;
        this.myOriginalSession = null;
        if (theSessionToClose != null) {
            theSessionToClose.close();
        }
    }

    @Override
    public long ping() {
        this.checkIsNotClosed();
        return this.myOriginalSession.ping();
    }

    @Override
    public void beginTransaction() {
        this.checkIsNotClosed();
        this.myOriginalSession.beginTransaction();
    }

    @Override
    public boolean isInTransaction() {
        return this.myOriginalSession != null && this.myOriginalSession.isInTransaction();
    }

    @Override
    public void commit() {
        this.checkIsNotClosed();
        this.myOriginalSession.commit();
    }

    @Override
    public void rollback() {
        if (this.myOriginalSession == null) {
            return;
        }
        this.myOriginalSession.rollback();
    }

    @Override
    public synchronized <R> R inTransaction(InTransaction<R> operation) {
        this.checkIsNotClosed();
        return this.myOriginalSession.inTransaction(operation);
    }

    @Override
    public synchronized void inTransaction(InTransactionNoResult operation) {
        this.checkIsNotClosed();
        this.myOriginalSession.inTransaction(operation);
    }

    @Override
    @NotNull
    public synchronized DBCommandRunner command(@NotNull SqlCommand command) {
        this.checkIsNotClosed();
        return this.myOriginalSession.command(command);
    }

    @Override
    @NotNull
    public synchronized DBCommandRunner command(@NotNull String commandText) {
        this.checkIsNotClosed();
        return this.myOriginalSession.command(commandText);
    }

    @Override
    @NotNull
    public synchronized <S> DBQueryRunner<S> query(@NotNull SqlQuery<S> query) {
        this.checkIsNotClosed();
        return this.myOriginalSession.query(query);
    }

    @Override
    @NotNull
    public synchronized <S> DBQueryRunner<S> query(@NotNull String queryText, @NotNull ResultLayout<S> layout) {
        this.checkIsNotClosed();
        return this.myOriginalSession.query(queryText, layout);
    }

    @Override
    @NotNull
    public synchronized DBScriptRunner script(@NotNull SqlScript script) {
        this.checkIsNotClosed();
        return this.myOriginalSession.script(script);
    }

    @Override
    @Nullable
    public synchronized <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        this.checkIsNotClosed();
        return this.myOriginalSession.getSpecificService(serviceClass, serviceName);
    }
}

