/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeFilter
implements Filter,
FilterMixin {
    private static final Logger LOG = Logger.getInstance(CompositeFilter.class);
    private final List<Filter> myFilters;
    private boolean myIsAnyHeavy;
    private boolean forceUseAllFilters;
    private final DumbService myDumbService;

    public CompositeFilter(@NotNull Project project) {
        if (project == null) {
            CompositeFilter.$$$reportNull$$$0(0);
        }
        this(project, new ArrayList<Filter>());
    }

    public CompositeFilter(@NotNull Project project, @NotNull List<Filter> filters) {
        if (project == null) {
            CompositeFilter.$$$reportNull$$$0(1);
        }
        if (filters == null) {
            CompositeFilter.$$$reportNull$$$0(2);
        }
        this.myDumbService = DumbService.getInstance(project);
        this.myFilters = filters;
        this.myFilters.forEach(filter -> this.myIsAnyHeavy |= filter instanceof FilterMixin);
    }

    protected CompositeFilter(DumbService dumbService) {
        this.myDumbService = dumbService;
        this.myFilters = new ArrayList<Filter>();
    }

    @Override
    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        List<Filter.ResultItem> resultItems = null;
        for (int i = 0; i < count; ++i) {
            Filter.Result result2;
            ProgressManager.checkCanceled();
            Filter filter = filters.get(i);
            if (dumb && !DumbService.isDumbAware(filter)) continue;
            long t0 = System.currentTimeMillis();
            try {
                result2 = filter.applyFilter(line, entireLength);
            }
            catch (ProcessCanceledException ignore) {
                result2 = null;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + filter + " to '" + line + "'", t);
            }
            resultItems = this.merge(resultItems, result2, entireLength, filter);
            t0 = System.currentTimeMillis() - t0;
            if (t0 > 1000L) {
                LOG.warn(filter.getClass().getSimpleName() + ".applyFilter() took " + t0 + " ms on '''" + line + "'''");
            }
            if (this.shouldStopFiltering(result2)) break;
        }
        return CompositeFilter.createFinalResult(resultItems);
    }

    @Nullable
    private static Filter.Result createFinalResult(@Nullable List<Filter.ResultItem> resultItems) {
        if (resultItems == null) {
            return null;
        }
        if (resultItems.size() == 1) {
            final Filter.ResultItem resultItem = resultItems.get(0);
            return new Filter.Result(resultItem.getHighlightStartOffset(), resultItem.getHighlightEndOffset(), resultItem.getHyperlinkInfo(), resultItem.getHighlightAttributes(), resultItem.getFollowedHyperlinkAttributes()){

                @Override
                public int getHighlighterLayer() {
                    return resultItem.getHighlighterLayer();
                }
            };
        }
        return new Filter.Result(resultItems);
    }

    private boolean shouldStopFiltering(@Nullable Filter.Result result2) {
        return result2 != null && result2.getNextAction() == Filter.NextAction.EXIT && !this.forceUseAllFilters;
    }

    @Nullable
    private List<Filter.ResultItem> merge(@Nullable List<Filter.ResultItem> resultItems, @Nullable Filter.Result newResult, int entireLength, Filter filter) {
        if (newResult != null) {
            if (resultItems == null) {
                resultItems = new ArrayList<Filter.ResultItem>();
            }
            List<Filter.ResultItem> newItems = newResult.getResultItems();
            for (int i = 0; i < newItems.size(); ++i) {
                Filter.ResultItem item = newItems.get(i);
                if (item.getHyperlinkInfo() != null && this.intersects(resultItems, item) || !CompositeFilter.checkOffsetsCorrect(item, entireLength, filter)) continue;
                resultItems.add(item);
            }
        }
        return resultItems;
    }

    private static boolean checkOffsetsCorrect(Filter.ResultItem item, int entireLength, Filter filter) {
        int start = item.getHighlightStartOffset();
        int end = item.getHighlightEndOffset();
        if (end < start || end > entireLength) {
            LOG.error("Filter returned wrong range: start=" + start + "; end=" + end + "; length=" + entireLength + "; filter=" + filter);
            return false;
        }
        return true;
    }

    protected boolean intersects(List<? extends Filter.ResultItem> items, Filter.ResultItem newItem) {
        TextRange newItemTextRange = null;
        for (int i = 0; i < items.size(); ++i) {
            Filter.ResultItem item = items.get(i);
            if (item.getHyperlinkInfo() == null) continue;
            if (newItemTextRange == null) {
                newItemTextRange = new TextRange(newItem.highlightStartOffset, newItem.highlightEndOffset);
            }
            if (!newItemTextRange.intersectsStrict(item.highlightStartOffset, item.highlightEndOffset)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRunHeavy() {
        for (Filter filter : this.myFilters) {
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<FilterMixin.AdditionalHighlight> consumer) {
        if (copiedFragment == null) {
            CompositeFilter.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            CompositeFilter.$$$reportNull$$$0(4);
        }
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        for (int i = 0; i < count; ++i) {
            Filter filter = filters.get(i);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy() || dumb && !DumbService.isDumbAware(filter)) continue;
            ((FilterMixin)((Object)filter)).applyHeavyFilter(copiedFragment, startOffset, startLineNumber, consumer);
        }
    }

    @Override
    @NotNull
    public String getUpdateMessage() {
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        ArrayList<String> updateMessage = new ArrayList<String>();
        int count = filters.size();
        for (int i = 0; i < count; ++i) {
            Filter filter = filters.get(i);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy() || dumb && !DumbService.isDumbAware(filter)) continue;
            updateMessage.add(((FilterMixin)((Object)filter)).getUpdateMessage());
        }
        String string = updateMessage.size() == 1 ? (String)updateMessage.get(0) : "Updating...";
        if (string == null) {
            CompositeFilter.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isEmpty() {
        return this.myFilters.isEmpty();
    }

    public boolean isAnyHeavy() {
        return this.myIsAnyHeavy;
    }

    public void addFilter(@NotNull Filter filter) {
        if (filter == null) {
            CompositeFilter.$$$reportNull$$$0(6);
        }
        this.myFilters.add(filter);
        this.myIsAnyHeavy |= filter instanceof FilterMixin;
    }

    @NotNull
    public List<Filter> getFilters() {
        List<Filter> list = Collections.unmodifiableList(this.myFilters);
        if (list == null) {
            CompositeFilter.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void setForceUseAllFilters(boolean forceUseAllFilters) {
        this.forceUseAllFilters = forceUseAllFilters;
    }

    public String toString() {
        return "CompositeFilter: " + this.myFilters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiedFragment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/CompositeFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/CompositeFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyHeavyFilter";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

