/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DefaultFileNavigationContributor
implements ChooseByNameContributorEx,
DumbAware {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        if (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping) {
            THashSet names = new THashSet(1000);
            IdFilter filter = IdFilter.getProjectIdFilter((Project)project, (boolean)includeNonProjectItems);
            this.processNames((Processor<String>)((Processor)s -> {
                names.add(s);
                return true;
            }), FindSymbolParameters.searchScopeFor(project, includeNonProjectItems), filter);
            if (IdFilter.LOG.isDebugEnabled()) {
                IdFilter.LOG.debug("All names retrieved2:" + names.size());
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)names);
            if (stringArray == null) {
                DefaultFileNavigationContributor.$$$reportNull$$$0(0);
            }
            return stringArray;
        }
        String[] stringArray = FilenameIndex.getAllFilenames(project);
        if (stringArray == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processElementsWithName(name, (Processor<NavigationItem>)processor2, FindSymbolParameters.wrap(pattern, project, includeNonProjectItems));
        NavigationItem[] navigationItemArray = result2.isEmpty() ? NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY : result2.toArray(NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY);
        if (navigationItemArray == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(2);
        }
        return navigationItemArray;
    }

    @Override
    public void processNames(@NotNull Processor<String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        if (processor2 == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(4);
        }
        long started = System.currentTimeMillis();
        FilenameIndex.processAllFileNames(processor2, scope, filter);
        if (IdFilter.LOG.isDebugEnabled()) {
            IdFilter.LOG.debug("All names retrieved:" + (System.currentTimeMillis() - started));
        }
    }

    @Override
    public void processElementsWithName(@NotNull String name, @NotNull Processor<NavigationItem> _processor, @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(5);
        }
        if (_processor == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(7);
        }
        boolean globalSearch = parameters.getSearchScope().isSearchInLibraries();
        Processor processor2 = item -> {
            if (_processor == null) {
                DefaultFileNavigationContributor.$$$reportNull$$$0(9);
            }
            if (!globalSearch && ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)item.getVirtualFile())) {
                return true;
            }
            return _processor.process(item);
        };
        boolean directoriesOnly = DefaultFileNavigationContributor.isDirectoryOnlyPattern(parameters);
        if (!directoriesOnly) {
            FilenameIndex.processFilesByName(name, false, (Processor<? super PsiFileSystemItem>)processor2, parameters.getSearchScope(), parameters.getProject(), parameters.getIdFilter());
        }
        if (directoriesOnly || Registry.is((String)"ide.goto.file.include.directories")) {
            FilenameIndex.processFilesByName(name, true, (Processor<? super PsiFileSystemItem>)processor2, parameters.getSearchScope(), parameters.getProject(), parameters.getIdFilter());
        }
    }

    private static boolean isDirectoryOnlyPattern(@NotNull FindSymbolParameters parameters) {
        String completePattern;
        if (parameters == null) {
            DefaultFileNavigationContributor.$$$reportNull$$$0(8);
        }
        return (completePattern = parameters.getCompletePattern()).endsWith("/") || completePattern.endsWith("\\");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/DefaultFileNavigationContributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_processor";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsByName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/DefaultFileNavigationContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processNames";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryOnlyPattern";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementsWithName$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

