/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockBuilder;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlInjectedLanguageBlockBuilder
extends InjectedLanguageBlockBuilder {
    private final XmlFormattingPolicy myXmlFormattingPolicy;

    public XmlInjectedLanguageBlockBuilder(XmlFormattingPolicy formattingPolicy) {
        this.myXmlFormattingPolicy = formattingPolicy;
    }

    @Override
    @NotNull
    public Block createInjectedBlock(@NotNull ASTNode node, @NotNull Block originalBlock, Indent indent, int offset, TextRange range2, @Nullable Language language) {
        if (node == null) {
            XmlInjectedLanguageBlockBuilder.$$$reportNull$$$0(0);
        }
        if (originalBlock == null) {
            XmlInjectedLanguageBlockBuilder.$$$reportNull$$$0(1);
        }
        AnotherLanguageBlockWrapper anotherLanguageBlockWrapper = new AnotherLanguageBlockWrapper(node, this.myXmlFormattingPolicy, originalBlock, indent, offset, range2);
        if (anotherLanguageBlockWrapper == null) {
            XmlInjectedLanguageBlockBuilder.$$$reportNull$$$0(2);
        }
        return anotherLanguageBlockWrapper;
    }

    @Override
    public Block createBlockBeforeInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range2) {
        return new XmlBlock(node, wrap, alignment, this.myXmlFormattingPolicy, indent, range2);
    }

    @Override
    public Block createBlockAfterInjection(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, TextRange range2) {
        return new XmlBlock(node, wrap, alignment, this.myXmlFormattingPolicy, indent, range2);
    }

    @Override
    public CodeStyleSettings getSettings() {
        return this.myXmlFormattingPolicy.getSettings();
    }

    @Override
    public boolean canProcessFragment(String text, ASTNode injectionHost) {
        IElementType type = injectionHost.getElementType();
        if (type == XmlElementType.XML_TEXT) {
            text = text.trim();
            text = text.replace("<![CDATA[", "");
            text = text.replace("]]>", "");
        } else if (type == XmlElementType.XML_COMMENT) {
            return true;
        }
        return text.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/xml/XmlInjectedLanguageBlockBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/xml/XmlInjectedLanguageBlockBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createInjectedBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInjectedBlock";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

