/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudGitApplicationRuntime;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import org.jetbrains.annotations.Nullable;

public abstract class CloudDeploymentRuntime
extends CloudGitApplicationRuntime {
    private final DeploymentTask myTask;

    public CloudDeploymentRuntime(CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentSource source, DeploymentTask<? extends CloudDeploymentNameConfiguration> task, @Nullable DeploymentLogManager logManager) throws ServerRuntimeException {
        super(serverRuntime, ((CloudDeploymentNameConfiguration)task.getConfiguration()).getDeploymentSourceName(source), logManager);
        this.myTask = task;
    }

    protected DeploymentTask getTask() {
        return this.myTask;
    }

    public void deploy(ServerRuntimeInstance.DeploymentOperationCallback callback2) {
        try {
            CloudRemoteApplication application = this.deploy();
            DeploymentLogManager logManager = this.getLogManager();
            if (logManager != null) {
                LoggingHandler loggingHandler = logManager.getMainLoggingHandler();
                loggingHandler.print("Application is available at ");
                loggingHandler.printHyperlink(application.getWebUrl());
                loggingHandler.print("\n");
            }
            callback2.succeeded((DeploymentRuntime)this);
        }
        catch (ServerRuntimeException e) {
            callback2.errorOccurred(e.getMessage());
        }
    }

    public Project getProject() {
        return this.myTask.getProject();
    }

    public abstract CloudRemoteApplication deploy() throws ServerRuntimeException;
}

