/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.indexing.FileBasedIndexImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndexedFilesListener
implements BulkFileListener {
    private final ManagingFS myManagingFS = ManagingFS.getInstance();
    @Nullable
    private final String myConfigPath = IndexedFilesListener.calcConfigPath(PathManager.getConfigPath());
    @Nullable
    private final String myLogPath = IndexedFilesListener.calcConfigPath(PathManager.getLogPath());

    protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(0);
        }
        if (file2.isDirectory()) {
            ContentIterator iterator = fileOrDir -> {
                this.buildIndicesForFile(fileOrDir, contentChange);
                return true;
            };
            this.iterateIndexableFiles(file2, iterator);
        } else {
            this.buildIndicesForFile(file2, contentChange);
        }
    }

    protected boolean invalidateIndicesForFile(@NotNull VirtualFile file2, boolean contentChange) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(1);
        }
        if (this.isUnderConfigOrSystem(file2)) {
            return false;
        }
        if (file2.isDirectory()) {
            this.doInvalidateIndicesForFile(file2, contentChange);
            if (!FileBasedIndexImpl.isMock(file2) && !this.myManagingFS.wereChildrenAccessed(file2)) {
                return false;
            }
        } else {
            this.doInvalidateIndicesForFile(file2, contentChange);
        }
        return true;
    }

    protected abstract void iterateIndexableFiles(@NotNull VirtualFile var1, @NotNull ContentIterator var2);

    protected abstract void buildIndicesForFile(@NotNull VirtualFile var1, boolean var2);

    protected abstract void doInvalidateIndicesForFile(@NotNull VirtualFile var1, boolean var2);

    protected void invalidateIndicesRecursively(@NotNull VirtualFile file2, final boolean contentChange) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(2);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return IndexedFilesListener.this.invalidateIndicesForFile(file2, contentChange);
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).iterInDbChildren() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/util/indexing/IndexedFilesListener$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            IndexedFilesListener.$$$reportNull$$$0(3);
        }
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.invalidateIndicesRecursively(((VFileContentChangeEvent)vFileEvent).getFile(), true);
                continue;
            }
            if (vFileEvent instanceof VFileDeleteEvent) {
                this.invalidateIndicesRecursively(((VFileDeleteEvent)vFileEvent).getFile(), false);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
            String propertyName = pce.getPropertyName();
            if (propertyName.equals("name")) {
                this.invalidateIndicesRecursively(pce.getFile(), false);
                continue;
            }
            if (!propertyName.equals("encoding")) continue;
            this.invalidateIndicesRecursively(pce.getFile(), true);
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            IndexedFilesListener.$$$reportNull$$$0(4);
        }
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.buildIndicesForFileRecursively(((VFileContentChangeEvent)vFileEvent).getFile(), true);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)vFileEvent;
                VirtualFile copy = ce.getNewParent().findChild(ce.getNewChildName());
                if (copy == null) continue;
                this.buildIndicesForFileRecursively(copy, false);
                continue;
            }
            if (vFileEvent instanceof VFileCreateEvent) {
                VirtualFile newChild = vFileEvent.getFile();
                if (newChild == null) continue;
                this.buildIndicesForFileRecursively(newChild, false);
                continue;
            }
            if (vFileEvent instanceof VFileMoveEvent) {
                this.buildIndicesForFileRecursively(((VFileMoveEvent)vFileEvent).getFile(), false);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
            String propertyName = pce.getPropertyName();
            if (propertyName.equals("name")) {
                this.buildIndicesForFileRecursively(pce.getFile(), false);
                continue;
            }
            if (!propertyName.equals("encoding")) continue;
            this.buildIndicesForFileRecursively(pce.getFile(), true);
        }
    }

    @Nullable
    private static String calcConfigPath(@NotNull String path) {
        if (path == null) {
            IndexedFilesListener.$$$reportNull$$$0(5);
        }
        try {
            String _path = FileUtil.toSystemIndependentName((String)new File(path).getCanonicalPath());
            return _path.endsWith("/") ? _path : _path + "/";
        }
        catch (IOException e) {
            FileBasedIndexImpl.LOG.info((Throwable)e);
            return null;
        }
    }

    private boolean isUnderConfigOrSystem(@NotNull VirtualFile file2) {
        if (file2 == null) {
            IndexedFilesListener.$$$reportNull$$$0(6);
        }
        String filePath = file2.getPath();
        return this.myConfigPath != null && FileUtil.startsWith((String)filePath, (String)this.myConfigPath) || this.myLogPath != null && FileUtil.startsWith((String)filePath, (String)this.myLogPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/IndexedFilesListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildIndicesForFileRecursively";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidateIndicesForFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidateIndicesRecursively";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "calcConfigPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnderConfigOrSystem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

