/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XSourcePositionImpl
implements XSourcePosition {
    private final VirtualFile myFile;

    private XSourcePositionImpl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            XSourcePositionImpl.$$$reportNull$$$0(0);
        }
        this.myFile = file2;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            XSourcePositionImpl.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Nullable
    public static XSourcePositionImpl createByOffset(final @Nullable VirtualFile file2, final int offset) {
        if (file2 == null) {
            return null;
        }
        return new XSourcePositionImpl(file2){
            private final AtomicNotNullLazyValue<Integer> myLine;
            {
                super(file22);
                this.myLine = new AtomicNotNullLazyValue<Integer>(){

                    @NotNull
                    protected Integer compute() {
                        Integer n = (Integer)ReadAction.compute(() -> {
                            Document document = FileDocumentManager.getInstance().getDocument(file2);
                            if (document == null) {
                                return -1;
                            }
                            return DocumentUtil.isValidOffset(offset, document) ? document.getLineNumber(offset) : -1;
                        });
                        if (n == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return n;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XSourcePositionImpl$1$1", "compute"));
                    }
                };
            }

            public int getLine() {
                return (Integer)this.myLine.getValue();
            }

            public int getOffset() {
                return offset;
            }
        };
    }

    @Nullable
    public static XSourcePositionImpl createByElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return null;
        }
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        return new XSourcePositionImpl(file2){
            private final AtomicNotNullLazyValue<XSourcePosition> myDelegate;
            {
                super(file2);
                this.myDelegate = new AtomicNotNullLazyValue<XSourcePosition>(){

                    @NotNull
                    protected XSourcePosition compute() {
                        XSourcePosition xSourcePosition = (XSourcePosition)ReadAction.compute(() -> {
                            PsiElement elem = pointer.getElement();
                            return XSourcePositionImpl.createByOffset(pointer.getVirtualFile(), elem != null ? elem.getTextOffset() : -1);
                        });
                        if (xSourcePosition == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return xSourcePosition;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XSourcePositionImpl$2$1", "compute"));
                    }
                };
            }

            public int getLine() {
                return ((XSourcePosition)this.myDelegate.getValue()).getLine();
            }

            public int getOffset() {
                return ((XSourcePosition)this.myDelegate.getValue()).getOffset();
            }

            @Override
            @NotNull
            public Navigatable createNavigatable(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (this.myDelegate.isComputed()) {
                    Navigatable navigatable = ((XSourcePosition)this.myDelegate.getValue()).createNavigatable(project);
                    if (navigatable == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return navigatable;
                }
                PsiElement elem = pointer.getElement();
                if (elem instanceof Navigatable) {
                    Navigatable navigatable = (Navigatable)elem;
                    if (navigatable == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return navigatable;
                }
                Navigatable navigatable = NonNavigatable.INSTANCE;
                if (navigatable == null) {
                    2.$$$reportNull$$$0(3);
                }
                return navigatable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/xdebugger/impl/XSourcePositionImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/xdebugger/impl/XSourcePositionImpl$2";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createNavigatable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createNavigatable";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Contract(value="null , _ -> null; !null, _ -> !null")
    public static XSourcePositionImpl create(@Nullable VirtualFile file2, int line) {
        return file2 == null ? null : XSourcePositionImpl.create(file2, line, 0);
    }

    @Contract(value="null , _, _ -> null; !null, _, _ -> !null")
    public static XSourcePositionImpl create(final @Nullable VirtualFile file2, final int line, final int column) {
        if (file2 == null) {
            return null;
        }
        return new XSourcePositionImpl(file2){
            private final AtomicNotNullLazyValue<Integer> myOffset;
            {
                super(file22);
                this.myOffset = new AtomicNotNullLazyValue<Integer>(){

                    @NotNull
                    protected Integer compute() {
                        Integer n = (Integer)ReadAction.compute(() -> {
                            int offset;
                            if (file2 instanceof LightVirtualFile || file2 instanceof HttpVirtualFile) {
                                return -1;
                            }
                            Document document = FileDocumentManager.getInstance().getDocument(file2);
                            if (document == null) {
                                return -1;
                            }
                            int l = Math.max(0, line);
                            int c = Math.max(0, column);
                            int n = offset = l < document.getLineCount() ? document.getLineStartOffset(l) + c : -1;
                            if (offset >= document.getTextLength()) {
                                offset = document.getTextLength() - 1;
                            }
                            return offset;
                        });
                        if (n == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return n;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/XSourcePositionImpl$3$1", "compute"));
                    }
                };
            }

            public int getLine() {
                return line;
            }

            public int getOffset() {
                return (Integer)this.myOffset.getValue();
            }
        };
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        if (project == null) {
            XSourcePositionImpl.$$$reportNull$$$0(2);
        }
        OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor(project, this);
        if (openFileDescriptor == null) {
            XSourcePositionImpl.$$$reportNull$$$0(3);
        }
        return openFileDescriptor;
    }

    @NotNull
    public static OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project, @NotNull XSourcePosition position) {
        Navigatable navigatable;
        if (project == null) {
            XSourcePositionImpl.$$$reportNull$$$0(4);
        }
        if (position == null) {
            XSourcePositionImpl.$$$reportNull$$$0(5);
        }
        if ((navigatable = position.createNavigatable(project)) instanceof OpenFileDescriptor) {
            OpenFileDescriptor openFileDescriptor = (OpenFileDescriptor)navigatable;
            if (openFileDescriptor == null) {
                XSourcePositionImpl.$$$reportNull$$$0(6);
            }
            return openFileDescriptor;
        }
        OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor(project, position);
        if (openFileDescriptor == null) {
            XSourcePositionImpl.$$$reportNull$$$0(7);
        }
        return openFileDescriptor;
    }

    @NotNull
    public static OpenFileDescriptor doCreateOpenFileDescriptor(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            XSourcePositionImpl.$$$reportNull$$$0(8);
        }
        if (position == null) {
            XSourcePositionImpl.$$$reportNull$$$0(9);
        }
        OpenFileDescriptor openFileDescriptor = position.getOffset() != -1 ? new OpenFileDescriptor(project, position.getFile(), position.getOffset()) : new OpenFileDescriptor(project, position.getFile(), position.getLine(), 0);
        if (openFileDescriptor == null) {
            XSourcePositionImpl.$$$reportNull$$$0(10);
        }
        return openFileDescriptor;
    }

    public String toString() {
        return "XSourcePositionImpl[" + this.myFile + ":" + this.getLine() + "(" + this.getOffset() + ")]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XSourcePositionImpl";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XSourcePositionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigatable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenFileDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateOpenFileDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNavigatable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createOpenFileDescriptor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCreateOpenFileDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

