/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerPackageInfo {
    private static final Logger LOG = Logger.getInstance(BowerPackageInfo.class);
    private final List<String> myVersions;
    private final JsonObject myLatestContent;

    public BowerPackageInfo(@NotNull List<String> versions, @Nullable JsonObject latestContent) {
        if (versions == null) {
            BowerPackageInfo.$$$reportNull$$$0(0);
        }
        this.myVersions = ImmutableList.copyOf(versions);
        this.myLatestContent = latestContent;
    }

    @NotNull
    public List<String> getVersions() {
        List<String> list = this.myVersions;
        if (list == null) {
            BowerPackageInfo.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public String formatHtmlDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append("<html>");
        buf.append("<head>").append("<style>").append(".line {padding-left:5px}").append("</style>").append("</head>");
        buf.append("<body class='line'>");
        buf.append("<pre>");
        if (this.myLatestContent != null) {
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setIndent("  ");
            jsonWriter.setLenient(true);
            try {
                Streams.write((JsonElement)this.myLatestContent, (JsonWriter)jsonWriter);
                buf.append(stringWriter.toString());
            }
            catch (IOException e) {
                LOG.warn("Can't stringify json", (Throwable)e);
                buf.append("Can't stringify json");
            }
        } else {
            buf.append("No information available");
        }
        buf.append("</pre>");
        buf.append("</body>");
        buf.append("</html>");
        String string = buf.toString();
        if (string == null) {
            BowerPackageInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versions";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerPackageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerPackageInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatHtmlDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

