/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.importer;

import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.importer.EslintRuleMapper;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.util.BeforeAfter;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintConfigWrapper {
    private static final Map<String, EslintRuleMapper> RULES = EslintConfigWrapper.createRules();
    private static final Key<ParameterizedCachedValue<EslintConfigWrapper, PsiFile>> CACHE_KEY = Key.create((String)"Eslint.Import.Code.Style.cache.key");
    private final Map<String, SettingsConvertor> myConfigRules;
    static final SettingsConvertor MISCONFIGURATION = new SettingsConvertor(EslintRuleMapper.RuleState.misconfiguration);
    private static final SettingsConvertor SKIPPED = new SettingsConvertor(EslintRuleMapper.RuleState.skipped);

    private EslintConfigWrapper(@NotNull JsonObject config2) {
        if (config2 == null) {
            EslintConfigWrapper.$$$reportNull$$$0(0);
        }
        this.myConfigRules = EslintConfigWrapper.parseConfig(config2);
    }

    @Nullable
    public static EslintConfigWrapper getForFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            EslintConfigWrapper.$$$reportNull$$$0(1);
        }
        if (!psiFile.isPhysical()) {
            return EslintConfigWrapper.createImporter(psiFile);
        }
        return (EslintConfigWrapper)CachedValuesManager.getManager((Project)psiFile.getProject()).getParameterizedCachedValue((UserDataHolder)psiFile, CACHE_KEY, param -> {
            if (psiFile == null) {
                EslintConfigWrapper.$$$reportNull$$$0(12);
            }
            return CachedValueProvider.Result.create((Object)EslintConfigWrapper.createImporter(psiFile), (Object[])new Object[]{psiFile});
        }, false, (Object)psiFile);
    }

    @Nullable
    private static EslintConfigWrapper createImporter(@NotNull PsiFile psiFile) {
        JsonObject rootObject;
        if (psiFile == null) {
            EslintConfigWrapper.$$$reportNull$$$0(2);
        }
        return (rootObject = EslintUtil.getConfigRootObject(psiFile)) != null ? new EslintConfigWrapper(rootObject) : null;
    }

    public boolean hasDataToImport(@NotNull Project project) {
        if (project == null) {
            EslintConfigWrapper.$$$reportNull$$$0(3);
        }
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)project);
        CodeStyleSettings settings = settingsManager.getCurrentSettings();
        CommonCodeStyleSettings common = settings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
        JSCodeStyleSettings custom = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
        if (this.myConfigRules.isEmpty()) {
            return false;
        }
        return this.myConfigRules.values().stream().anyMatch(convertor -> EslintRuleMapper.RuleState.ok.equals((Object)convertor.validate(common, custom)));
    }

    public Set<String> modifySettings(@NotNull Project project) {
        if (project == null) {
            EslintConfigWrapper.$$$reportNull$$$0(4);
        }
        HashSet<String> modifiedRules = new HashSet<String>();
        WriteAction.run(() -> {
            if (project == null) {
                EslintConfigWrapper.$$$reportNull$$$0(11);
            }
            CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)project);
            if (!settingsManager.USE_PER_PROJECT_SETTINGS) {
                settingsManager.setMainProjectCodeStyle(settingsManager.getCurrentSettings().clone());
                settingsManager.USE_PER_PROJECT_SETTINGS = true;
            }
            CodeStyleSettings settings = settingsManager.getCurrentSettings();
            CommonCodeStyleSettings common = settings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
            JSCodeStyleSettings custom = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
            for (Map.Entry<String, SettingsConvertor> entry : this.myConfigRules.entrySet()) {
                SettingsConvertor convertor = entry.getValue();
                if (!EslintRuleMapper.RuleState.ok.equals((Object)convertor.validate(common, custom)) || !EslintRuleMapper.RuleState.ok.equals((Object)convertor.apply(common, custom))) continue;
                modifiedRules.add(entry.getKey());
            }
        });
        return modifiedRules;
    }

    @NotNull
    private static Map<String, SettingsConvertor> parseConfig(@NotNull JsonObject config2) {
        JsonProperty property;
        if (config2 == null) {
            EslintConfigWrapper.$$$reportNull$$$0(5);
        }
        if ((property = config2.findProperty("rules")) == null) {
            Map<String, SettingsConvertor> map = Collections.emptyMap();
            if (map == null) {
                EslintConfigWrapper.$$$reportNull$$$0(6);
            }
            return map;
        }
        JsonObject rulesObject = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class);
        if (rulesObject == null) {
            Map<String, SettingsConvertor> map = Collections.emptyMap();
            if (map == null) {
                EslintConfigWrapper.$$$reportNull$$$0(7);
            }
            return map;
        }
        HashMap<String, SettingsConvertor> result2 = new HashMap<String, SettingsConvertor>();
        List list = rulesObject.getPropertyList();
        for (JsonProperty rule : list) {
            String name = StringUtil.unquoteString((String)rule.getName());
            if (StringUtil.isEmptyOrSpaces((String)name) || rule.getValue() == null) continue;
            result2.put(name, EslintConfigWrapper.getSettingsConvertor(name, rule));
        }
        HashMap<String, SettingsConvertor> hashMap = result2;
        if (hashMap == null) {
            EslintConfigWrapper.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    private static SettingsConvertor getSettingsConvertor(@NotNull String name, @NotNull JsonProperty rule) {
        if (name == null) {
            EslintConfigWrapper.$$$reportNull$$$0(9);
        }
        if (rule == null) {
            EslintConfigWrapper.$$$reportNull$$$0(10);
        }
        EslintRuleMapper mapper = RULES.get(name);
        JsonValue value = rule.getValue();
        assert (value != null);
        if (mapper == null) {
            return new SettingsConvertor(EslintRuleMapper.RuleState.skipped);
        }
        if (rule.getValue() == null) {
            return MISCONFIGURATION;
        }
        return mapper.parseSettings(value);
    }

    private static Map<String, EslintRuleMapper> createRules() {
        return ContainerUtil.set((Object[])new EslintRuleMapper[]{new ArrayBracketNewLine(), new ArrayBracketSpacing(), new ArrayElementNewLine(), new ArrowSpacing(), new BraceStyle(), new CommaDangle(), new CommaSpacing(), new Curly(), new DotLocation(), new EolLast(), new FuncCallSpacing(), new Indent(), new IndentLegacy(), new KeySpacing(), new KeywordSpacing(), new LinebreakStyle(), new MaxLen(), new MultilineTernary(), new NewlinePerChainedCall(), new NoMultipleEmptyLines(), new NoTabs(), new NoTrailingSpaces(), new ObjectCurlyNewline(), new ObjectCurlySpacing(), new OneVarDeclarationPerLine(), new ObjectPropertyNewLine(), new Quotes(), new RestSpreadSpacing(), new Semi(), new SemiSpacing(), new SortImports(), new SpaceBeforeBlocks(), new SpaceBeforeFunctionParen(), new SpaceInParens(), new SpaceInfixOps(), new SpaceUnaryOps(), new SpacedComment(), new YieldStarSpacing(), new TemplateCurlySpacing()}).stream().collect(Collectors.toMap(EslintRuleMapper::getName, Function.identity()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/importer/EslintConfigWrapper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintConfigWrapper";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getForFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createImporter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasDataToImport";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "modifySettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseConfig";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsConvertor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modifySettings$2";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getForFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class SettingsConvertor {
        @NotNull
        private final PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings> myApplier;
        @NotNull
        private final PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings> myValidator;
        @NotNull
        protected EslintRuleMapper.RuleState myState;

        SettingsConvertor(@NotNull EslintRuleMapper.RuleState state) {
            if (state == null) {
                SettingsConvertor.$$$reportNull$$$0(0);
            }
            this.myState = state;
            this.myValidator = (s, custom) -> false;
            this.myApplier = (s, custom) -> {};
        }

        SettingsConvertor(@NotNull PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings> validator, @NotNull PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings> applier) {
            if (validator == null) {
                SettingsConvertor.$$$reportNull$$$0(1);
            }
            if (applier == null) {
                SettingsConvertor.$$$reportNull$$$0(2);
            }
            this.myState = EslintRuleMapper.RuleState.ok;
            this.myValidator = validator;
            this.myApplier = applier;
        }

        public EslintRuleMapper.RuleState validate(@NotNull CommonCodeStyleSettings common, @NotNull JSCodeStyleSettings custom) {
            if (common == null) {
                SettingsConvertor.$$$reportNull$$$0(3);
            }
            if (custom == null) {
                SettingsConvertor.$$$reportNull$$$0(4);
            }
            if (!EslintRuleMapper.RuleState.ok.equals((Object)this.myState)) {
                return this.myState;
            }
            return this.myValidator.process((Object)common, (Object)custom) ? EslintRuleMapper.RuleState.ok : EslintRuleMapper.RuleState.sameSettings;
        }

        public EslintRuleMapper.RuleState apply(@NotNull CommonCodeStyleSettings common, @NotNull JSCodeStyleSettings custom) {
            if (common == null) {
                SettingsConvertor.$$$reportNull$$$0(5);
            }
            if (custom == null) {
                SettingsConvertor.$$$reportNull$$$0(6);
            }
            if (!EslintRuleMapper.RuleState.ok.equals((Object)this.myState)) {
                return this.myState;
            }
            this.myApplier.consume((Object)common, (Object)custom);
            return this.myState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "validator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "applier";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "common";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "custom";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintConfigWrapper$SettingsConvertor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validate";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SpaceBeforeBlocks
    extends EslintRuleMapper {
        protected SpaceBeforeBlocks() {
            super("space-before-blocks");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            SubGroupOption functions = new SubGroupOption("functions");
            SubGroupOption keywords = new SubGroupOption("keywords");
            SubGroupOption classes = new SubGroupOption("classes");
            if (values != null && !values.isEmpty()) {
                JsonObject config2 = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (config2 != null) {
                    boolean hasErrors = Stream.of(functions, keywords, classes).anyMatch(group -> {
                        JsonProperty functionsProperty = config2.findProperty(((SubGroupOption)group).myOptionName);
                        if (functionsProperty == null) {
                            return false;
                        }
                        JsonValue value = functionsProperty.getValue();
                        if (value == null) {
                            return true;
                        }
                        Boolean option = this.getAlwaysNeverOption(Collections.singletonList(value), true);
                        if (option == null) {
                            return true;
                        }
                        ((SubGroupOption)group).myValue = option;
                        return false;
                    });
                    if (hasErrors) {
                        return MISCONFIGURATION;
                    }
                } else {
                    Boolean option = this.getAlwaysNeverOption(values, true);
                    if (option == null) {
                        return MISCONFIGURATION;
                    }
                    functions.myValue = (keywords.myValue = (classes.myValue = option));
                }
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_METHOD_LBRACE != functions.myValue || common.SPACE_BEFORE_IF_LBRACE != keywords.myValue || common.SPACE_BEFORE_ELSE_LBRACE != keywords.myValue || common.SPACE_BEFORE_FOR_LBRACE != keywords.myValue || common.SPACE_BEFORE_WHILE_LBRACE != keywords.myValue || common.SPACE_BEFORE_DO_LBRACE != keywords.myValue || common.SPACE_BEFORE_SWITCH_LBRACE != keywords.myValue || common.SPACE_BEFORE_TRY_LBRACE != keywords.myValue || common.SPACE_BEFORE_CATCH_LBRACE != keywords.myValue || common.SPACE_BEFORE_FINALLY_LBRACE != keywords.myValue || custom.SPACE_BEFORE_CLASS_LBRACE != classes.myValue), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_METHOD_LBRACE = functions.myValue;
                common.SPACE_BEFORE_IF_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_ELSE_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_FOR_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_WHILE_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_DO_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_SWITCH_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_TRY_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_CATCH_LBRACE = keywords.myValue;
                common.SPACE_BEFORE_FINALLY_LBRACE = keywords.myValue;
                custom.SPACE_BEFORE_CLASS_LBRACE = classes.myValue;
            }));
        }

        private static class SubGroupOption {
            private final String myOptionName;
            private Boolean myValue;

            SubGroupOption(String optionName) {
                this.myOptionName = optionName;
                this.myValue = true;
            }
        }
    }

    private static class OneVarDeclarationPerLine
    extends EslintRuleMapper {
        protected OneVarDeclarationPerLine() {
            super("one-var-declaration-per-line");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.VAR_DECLARATION_WRAP != 2), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.VAR_DECLARATION_WRAP = 2;
            }));
        }
    }

    private static class ObjectPropertyNewLine
    extends EslintRuleMapper {
        protected ObjectPropertyNewLine() {
            super("object-property-newline");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            if (values != null && !values.isEmpty()) {
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (object == null) {
                    return MISCONFIGURATION;
                }
                Boolean multiplePropertiesPerLine = ObjectPropertyNewLine.getBooleanOptionValue(object, "allowMultiplePropertiesPerLine", false);
                if (multiplePropertiesPerLine == null) {
                    return MISCONFIGURATION;
                }
                if (multiplePropertiesPerLine.booleanValue()) {
                    return SKIPPED;
                }
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.OBJECT_LITERAL_WRAP != 2), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.OBJECT_LITERAL_WRAP = 2;
            }));
        }
    }

    private static class Indent
    extends EslintRuleMapper {
        Indent() {
            super("indent");
        }

        protected Indent(String name) {
            super(name);
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Integer indentSize = values == null || values.size() == 0 ? Integer.valueOf(4) : Indent.getInteger(values.get(0));
            if (indentSize != null) {
                return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> {
                    CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                    assert (indentOptions != null);
                    return indentSize != indentOptions.INDENT_SIZE || indentSize != indentOptions.CONTINUATION_INDENT_SIZE;
                }), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                    CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                    assert (indentOptions != null);
                    indentOptions.INDENT_SIZE = indentSize;
                    indentOptions.CONTINUATION_INDENT_SIZE = indentSize;
                }));
            }
            JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
            if (literal != null && "tab".equals(StringUtil.unquoteString((String)literal.getValue()))) {
                return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> {
                    CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                    assert (indentOptions != null);
                    return !indentOptions.USE_TAB_CHARACTER;
                }), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                    CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                    assert (indentOptions != null);
                    indentOptions.USE_TAB_CHARACTER = true;
                }));
            }
            return MISCONFIGURATION;
        }
    }

    private static class IndentLegacy
    extends Indent {
        IndentLegacy() {
            super("indent-legacy");
        }
    }

    private static class Quotes
    extends EslintRuleMapper {
        protected Quotes() {
            super("quotes");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            boolean isDouble = true;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (literal != null) {
                    String text = StringUtil.unquoteString((String)literal.getValue());
                    if ("single".equals(text)) {
                        isDouble = false;
                    } else if (!"double".equals(text)) {
                        return MISCONFIGURATION;
                    }
                } else {
                    return MISCONFIGURATION;
                }
            }
            boolean finalIsDouble = isDouble;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> finalIsDouble != custom.USE_DOUBLE_QUOTES || !custom.FORCE_QUOTE_STYlE), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.USE_DOUBLE_QUOTES = finalIsDouble;
                custom.FORCE_QUOTE_STYlE = true;
            }));
        }
    }

    private static class Semi
    extends EslintRuleMapper {
        protected Semi() {
            super("semi");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean isOn = this.getAlwaysNeverOption(values, true);
            if (isOn == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> isOn != custom.USE_SEMICOLON_AFTER_STATEMENT || !custom.FORCE_SEMICOLON_STYLE), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.USE_SEMICOLON_AFTER_STATEMENT = isOn;
                custom.FORCE_SEMICOLON_STYLE = true;
            }));
        }
    }

    private static class SortImports
    extends EslintRuleMapper {
        protected SortImports() {
            super("sort-imports");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            boolean sortMembers = true;
            if (values != null && !values.isEmpty()) {
                JsonObject config2 = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (config2 == null) {
                    return MISCONFIGURATION;
                }
                Boolean option = SortImports.getBooleanOptionValue(config2, "ignoreMemberSort", false);
                if (option == null) {
                    return MISCONFIGURATION;
                }
                sortMembers = option == false;
            }
            boolean finalSortMembers = sortMembers;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> finalSortMembers != custom.IMPORT_SORT_MEMBERS || !custom.IMPORT_SORT_MODULE_NAME), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.IMPORT_SORT_MEMBERS = finalSortMembers;
                custom.IMPORT_SORT_MODULE_NAME = true;
            }));
        }
    }

    private static class ArrowSpacing
    extends EslintRuleMapper {
        protected ArrowSpacing() {
            super("arrow-spacing");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            BeforeAfter<Boolean> beforeAfter = ArrowSpacing.getBeforeAfter(values, true, true);
            if (beforeAfter == null) {
                return MISCONFIGURATION;
            }
            if (beforeAfter.getBefore() != beforeAfter.getAfter()) {
                return SKIPPED;
            }
            boolean haveSpaces = Boolean.TRUE.equals(beforeAfter.getBefore());
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> haveSpaces != custom.SPACE_AROUND_ARROW_FUNCTION_OPERATOR), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACE_AROUND_ARROW_FUNCTION_OPERATOR = haveSpaces;
            }));
        }
    }

    private static class SpacedComment
    extends EslintRuleMapper {
        protected SpacedComment() {
            super("spaced-comment");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean isOn = this.getAlwaysNeverOption(values, true);
            if (isOn == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> isOn != common.LINE_COMMENT_ADD_SPACE), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                if (isOn.booleanValue()) {
                    common.LINE_COMMENT_AT_FIRST_COLUMN = false;
                }
                common.LINE_COMMENT_ADD_SPACE = isOn;
            }));
        }
    }

    private static class MaxLen
    extends EslintRuleMapper {
        protected MaxLen() {
            super("max-len");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Integer rightMargin = null;
            Integer tabWidth = null;
            if (values != null && values.size() != 0) {
                rightMargin = MaxLen.getInteger(values.get(0));
                if (rightMargin != null) {
                    if (values.size() > 1 && (tabWidth = MaxLen.getInteger(values.get(1))) == null) {
                        return MISCONFIGURATION;
                    }
                } else {
                    JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                    if (object != null) {
                        JsonProperty tabWidthProperty;
                        JsonProperty code = object.findProperty("code");
                        if (code != null && code.getValue() != null) {
                            rightMargin = MaxLen.getInteger(code.getValue());
                        }
                        if ((tabWidthProperty = object.findProperty("tabWidth")) != null && tabWidthProperty.getValue() != null && (tabWidth = MaxLen.getInteger(tabWidthProperty.getValue())) == null) {
                            return MISCONFIGURATION;
                        }
                    } else {
                        return MISCONFIGURATION;
                    }
                }
            }
            rightMargin = rightMargin == null ? 80 : rightMargin;
            tabWidth = tabWidth == null ? 4 : tabWidth;
            int finalRightMargin = rightMargin;
            Integer finalTabWidth = tabWidth;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.RIGHT_MARGIN != finalRightMargin || common.getIndentOptions() != null && common.getIndentOptions().TAB_SIZE != finalTabWidth), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.RIGHT_MARGIN = finalRightMargin;
                CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                if (indentOptions != null) {
                    indentOptions.TAB_SIZE = finalTabWidth;
                }
            }));
        }
    }

    private static class NoTabs
    extends EslintRuleMapper {
        NoTabs() {
            super("no-tabs");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> {
                CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                assert (indentOptions != null);
                return indentOptions.USE_TAB_CHARACTER;
            }), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                CommonCodeStyleSettings.IndentOptions indentOptions = common.getIndentOptions();
                assert (indentOptions != null);
                indentOptions.USE_TAB_CHARACTER = false;
            }));
        }
    }

    private static class NoTrailingSpaces
    extends EslintRuleMapper {
        protected NoTrailingSpaces() {
            super("no-trailing-spaces");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> {
                EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
                return editorSettings != null && !"Whole".equals(editorSettings.getStripTrailingSpaces());
            }), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
                assert (editorSettings != null);
                editorSettings.setStripTrailingSpaces("Whole");
            }));
        }
    }

    private static class NoMultipleEmptyLines
    extends EslintRuleMapper {
        protected NoMultipleEmptyLines() {
            super("no-multiple-empty-lines");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Integer blankLines = null;
            if (values != null && values.size() != 0) {
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (object != null) {
                    JsonProperty code = object.findProperty("max");
                    if (code != null && code.getValue() != null) {
                        blankLines = NoMultipleEmptyLines.getInteger(code.getValue());
                    }
                } else {
                    return MISCONFIGURATION;
                }
            }
            blankLines = blankLines == null ? 2 : blankLines;
            int finalBlankLines = blankLines;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.KEEP_BLANK_LINES_IN_CODE != finalBlankLines), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.KEEP_BLANK_LINES_IN_CODE = finalBlankLines;
            }));
        }
    }

    private static class MultilineTernary
    extends EslintRuleMapper {
        protected MultilineTernary() {
            super("multiline-ternary");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean isOn = this.getAlwaysNeverOption(values, true);
            if (isOn == null) {
                return MISCONFIGURATION;
            }
            int option = isOn != false ? 2 : 0;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.TERNARY_OPERATION_WRAP != option), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.TERNARY_OPERATION_WRAP = option;
            }));
        }
    }

    private static class NewlinePerChainedCall
    extends EslintRuleMapper {
        protected NewlinePerChainedCall() {
            super("newline-per-chained-call");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.METHOD_CALL_CHAIN_WRAP != 2), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.METHOD_CALL_CHAIN_WRAP = 2;
            }));
        }
    }

    private static class LinebreakStyle
    extends EslintRuleMapper {
        protected LinebreakStyle() {
            super("linebreak-style");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            boolean isLf = true;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (literal != null) {
                    String text = StringUtil.unquoteString((String)literal.getValue());
                    if ("windows".equals(text)) {
                        isLf = false;
                    } else if (!"unix".equals(text)) {
                        return MISCONFIGURATION;
                    }
                } else {
                    return MISCONFIGURATION;
                }
            }
            LineSeparator separator = isLf ? LineSeparator.LF : LineSeparator.CRLF;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> !separator.getSeparatorString().equals(common.getRootSettings().getLineSeparator())), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.getRootSettings().LINE_SEPARATOR = separator.getSeparatorString();
            }));
        }
    }

    private static class KeywordSpacing
    extends EslintRuleMapper {
        private static Map<String, SettingsConvertor> beforeMap(boolean value) {
            return ContainerUtil.map2Map((Collection)ContainerUtil.set((Object[])new Pair[]{Pair.create((Object)"else", (Object)new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_ELSE_KEYWORD != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_ELSE_KEYWORD = value;
            }))), Pair.create((Object)"while", (Object)new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_WHILE_KEYWORD != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_WHILE_KEYWORD = value;
            }))), Pair.create((Object)"catch", (Object)new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_CATCH_KEYWORD != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_CATCH_KEYWORD = value;
            }))), Pair.create((Object)"finally", (Object)new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_FINALLY_KEYWORD != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_FINALLY_KEYWORD = value;
            })))}));
        }

        private static Map<String, SettingsConvertor> afterMap(boolean value) {
            return ContainerUtil.map2Map((Collection)ContainerUtil.set((Object[])new Pair[]{Pair.create((Object)"if", (Object)new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_IF_PARENTHESES != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_IF_PARENTHESES = value;
            }))), Pair.create((Object)"for", (Object)new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_FOR_PARENTHESES != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_FOR_PARENTHESES = value;
            }))), Pair.create((Object)"while", (Object)new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_WHILE_PARENTHESES != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_WHILE_PARENTHESES = value;
            }))), Pair.create((Object)"switch", (Object)new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_SWITCH_PARENTHESES != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_SWITCH_PARENTHESES = value;
            }))), Pair.create((Object)"catch", (Object)new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_CATCH_PARENTHESES != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_CATCH_PARENTHESES = value;
            })))}));
        }

        protected KeywordSpacing() {
            super("keyword-spacing");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Map<String, SettingsConvertor> beforeTrue = KeywordSpacing.beforeMap(true);
            Map<String, SettingsConvertor> afterTrue = KeywordSpacing.afterMap(true);
            Map<String, SettingsConvertor> beforeFalse = KeywordSpacing.beforeMap(false);
            Map<String, SettingsConvertor> afterFalse = KeywordSpacing.afterMap(false);
            Map<String, SettingsConvertor> beforeMap = KeywordSpacing.beforeMap(true);
            Map<String, SettingsConvertor> afterMap = KeywordSpacing.afterMap(true);
            if (values != null && !values.isEmpty()) {
                JsonProperty overrides;
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (object == null) {
                    return MISCONFIGURATION;
                }
                BeforeAfter<Boolean> beforeAfter = KeywordSpacing.getBeforeAfter(object, true, true);
                if (beforeAfter == null) {
                    return MISCONFIGURATION;
                }
                if (!Boolean.TRUE.equals(beforeAfter.getBefore())) {
                    beforeMap = beforeFalse;
                }
                if (!Boolean.TRUE.equals(beforeAfter.getAfter())) {
                    afterMap = afterFalse;
                }
                if ((overrides = object.findProperty("overrides")) != null) {
                    JsonObject overridesObj = (JsonObject)ObjectUtils.tryCast((Object)overrides.getValue(), JsonObject.class);
                    if (overridesObj == null) {
                        return MISCONFIGURATION;
                    }
                    if (KeywordSpacing.fillMapFromOverrides("before", beforeMap, beforeTrue, beforeFalse, overridesObj)) {
                        return MISCONFIGURATION;
                    }
                    if (KeywordSpacing.fillMapFromOverrides("after", afterMap, afterTrue, afterFalse, overridesObj)) {
                        return MISCONFIGURATION;
                    }
                }
            }
            Collection<SettingsConvertor> beforeConvertors = beforeMap.values();
            Collection<SettingsConvertor> afterConvertors = afterMap.values();
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> beforeConvertors.stream().anyMatch(c -> EslintRuleMapper.RuleState.ok.equals((Object)c.validate((CommonCodeStyleSettings)common, (JSCodeStyleSettings)((Object)custom)))) || afterConvertors.stream().anyMatch(c -> EslintRuleMapper.RuleState.ok.equals((Object)c.validate((CommonCodeStyleSettings)common, (JSCodeStyleSettings)((Object)custom))))), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                beforeConvertors.forEach(c -> c.apply((CommonCodeStyleSettings)common, (JSCodeStyleSettings)((Object)custom)));
                afterConvertors.forEach(c -> c.apply((CommonCodeStyleSettings)common, (JSCodeStyleSettings)((Object)custom)));
            }));
        }

        private static boolean fillMapFromOverrides(@NotNull String propName, @NotNull Map<String, SettingsConvertor> map, @NotNull Map<String, SettingsConvertor> mapTrue, @NotNull Map<String, SettingsConvertor> mapFalse, @NotNull JsonObject overridesObj) {
            if (propName == null) {
                KeywordSpacing.$$$reportNull$$$0(0);
            }
            if (map == null) {
                KeywordSpacing.$$$reportNull$$$0(1);
            }
            if (mapTrue == null) {
                KeywordSpacing.$$$reportNull$$$0(2);
            }
            if (mapFalse == null) {
                KeywordSpacing.$$$reportNull$$$0(3);
            }
            if (overridesObj == null) {
                KeywordSpacing.$$$reportNull$$$0(4);
            }
            return overridesObj.getPropertyList().stream().filter(p -> {
                if (mapTrue == null) {
                    KeywordSpacing.$$$reportNull$$$0(9);
                }
                return mapTrue.containsKey(StringUtil.unquoteString((String)p.getName()));
            }).map(p -> {
                JsonObject pObj;
                if (propName == null) {
                    KeywordSpacing.$$$reportNull$$$0(5);
                }
                if (map == null) {
                    KeywordSpacing.$$$reportNull$$$0(6);
                }
                if (mapTrue == null) {
                    KeywordSpacing.$$$reportNull$$$0(7);
                }
                if (mapFalse == null) {
                    KeywordSpacing.$$$reportNull$$$0(8);
                }
                if ((pObj = (JsonObject)ObjectUtils.tryCast((Object)p.getValue(), JsonObject.class)) == null) {
                    return false;
                }
                Boolean option = KeywordSpacing.getBooleanOptionValue(pObj, propName, true);
                if (option == null) {
                    return false;
                }
                String name = StringUtil.unquoteString((String)p.getName());
                map.put(name, option != false ? (SettingsConvertor)mapTrue.get(name) : (SettingsConvertor)mapFalse.get(name));
                return true;
            }).anyMatch(value -> value == false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propName";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 2: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapTrue";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapFalse";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "overridesObj";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/importer/EslintConfigWrapper$KeywordSpacing";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillMapFromOverrides";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$fillMapFromOverrides$25";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$fillMapFromOverrides$24";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class KeySpacing
    extends EslintRuleMapper {
        private static final String BEFORE_COLON = "beforeColon";
        private static final String AFTER_COLON = "afterColon";

        KeySpacing() {
            super("key-spacing");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean beforeColon = false;
            Boolean afterColon = true;
            Boolean alignIsColon = null;
            if (values != null && values.size() > 0) {
                JsonObject config2 = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (config2 == null) {
                    return MISCONFIGURATION;
                }
                beforeColon = KeySpacing.getBooleanOptionValue(config2, BEFORE_COLON, false);
                afterColon = KeySpacing.getBooleanOptionValue(config2, AFTER_COLON, true);
                JsonProperty alignProperty = config2.findProperty("align");
                if (alignProperty != null) {
                    JsonObject alignObject = (JsonObject)ObjectUtils.tryCast((Object)alignProperty.getValue(), JsonObject.class);
                    if (alignObject != null) {
                        alignIsColon = true;
                        JsonProperty on = alignObject.findProperty("on");
                        if (on != null && (alignIsColon = this.readValueAsStringWithTwoVariants(on.getValue(), "colon", "value")) == null) {
                            return MISCONFIGURATION;
                        }
                        if (alignObject.findProperty(BEFORE_COLON) != null) {
                            beforeColon = KeySpacing.getBooleanOptionValue(alignObject, BEFORE_COLON, false);
                        }
                        if (alignObject.findProperty(AFTER_COLON) != null) {
                            afterColon = KeySpacing.getBooleanOptionValue(alignObject, AFTER_COLON, true);
                        }
                    } else {
                        alignIsColon = this.readValueAsStringWithTwoVariants(alignProperty.getValue(), "colon", "value");
                        if (alignIsColon == null) {
                            return MISCONFIGURATION;
                        }
                    }
                }
            }
            if (beforeColon == null || afterColon == null) {
                return MISCONFIGURATION;
            }
            Boolean finalBeforeColon = beforeColon;
            Boolean finalAfterColon = afterColon;
            Integer finalAlign = alignIsColon == null ? null : Integer.valueOf(alignIsColon != false ? 2 : 1);
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACE_BEFORE_PROPERTY_COLON != finalBeforeColon || custom.SPACE_AFTER_PROPERTY_COLON != finalAfterColon || finalAlign != null && custom.ALIGN_OBJECT_PROPERTIES != finalAlign), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACE_BEFORE_PROPERTY_COLON = finalBeforeColon;
                custom.SPACE_AFTER_PROPERTY_COLON = finalAfterColon;
                if (finalAlign != null) {
                    custom.ALIGN_OBJECT_PROPERTIES = finalAlign;
                }
            }));
        }
    }

    private static class CommaDangle
    extends EslintRuleMapper {
        protected CommaDangle() {
            super("comma-dangle");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            JSCodeStyleSettings.TrailingCommaOption option = JSCodeStyleSettings.TrailingCommaOption.Remove;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (literal != null) {
                    String text = StringUtil.unquoteString((String)literal.getValue());
                    if ("never".equals(text)) {
                        option = JSCodeStyleSettings.TrailingCommaOption.Remove;
                    } else if ("always".equals(text)) {
                        option = JSCodeStyleSettings.TrailingCommaOption.Keep;
                    } else if ("always-multiline".equals(text)) {
                        option = JSCodeStyleSettings.TrailingCommaOption.WhenMultiline;
                    } else if ("only-multiline".equals(text)) {
                        option = JSCodeStyleSettings.TrailingCommaOption.WhenMultiline;
                    } else {
                        if (!"ignore".equals(text)) return MISCONFIGURATION;
                        option = JSCodeStyleSettings.TrailingCommaOption.Keep;
                    }
                } else if (values.get(0) instanceof JsonObject) {
                    return SKIPPED;
                }
            }
            JSCodeStyleSettings.TrailingCommaOption finalOption = option;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.ENFORCE_TRAILING_COMMA != finalOption), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.ENFORCE_TRAILING_COMMA = finalOption;
            }));
        }
    }

    private static class ArrayBracketSpacing
    extends EslintRuleMapper {
        protected ArrayBracketSpacing() {
            super("array-bracket-spacing");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean isOn = this.getAlwaysNeverOption(values, false);
            if (isOn == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACE_WITHIN_ARRAY_INITIALIZER_BRACKETS != isOn), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACE_WITHIN_ARRAY_INITIALIZER_BRACKETS = isOn;
            }));
        }
    }

    private static class ArrayElementNewLine
    extends EslintRuleMapper {
        protected ArrayElementNewLine() {
            super("array-element-newline");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean isOn = this.getArrayLineBreakRulesOption(values);
            if (isOn == null) {
                return MISCONFIGURATION;
            }
            int value = isOn != false ? 2 : 0;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.ARRAY_INITIALIZER_WRAP != value), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.ARRAY_INITIALIZER_WRAP = value;
            }));
        }
    }

    private static class ArrayBracketNewLine
    extends EslintRuleMapper {
        protected ArrayBracketNewLine() {
            super("array-bracket-newline");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean isOn = this.getArrayLineBreakRulesOption(values);
            if (isOn == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE != isOn || common.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE != isOn), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = isOn;
                common.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = isOn;
            }));
        }
    }

    private static class BraceStyle
    extends EslintRuleMapper {
        protected BraceStyle() {
            super("brace-style");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Style style = Style.oneTrueBraceStyle;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (literal != null) {
                    String text = StringUtil.unquoteString((String)literal.getValue());
                    if (Style.allman.getText().equals(text)) {
                        style = Style.allman;
                    } else if (Style.stroustrup.getText().equals(text)) {
                        style = Style.stroustrup;
                    } else if (!Style.oneTrueBraceStyle.getText().equals(text)) {
                        return MISCONFIGURATION;
                    }
                } else {
                    return MISCONFIGURATION;
                }
            }
            Style finalStyle = style;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> {
                int braceStyle = finalStyle.getBeginBraceStyle();
                return braceStyle != common.BRACE_STYLE || braceStyle != common.METHOD_BRACE_STYLE || braceStyle != custom.FUNCTION_EXPRESSION_BRACE_STYLE || braceStyle != common.CLASS_BRACE_STYLE || common.ELSE_ON_NEW_LINE != finalStyle.isElseOnNewLine();
            }), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                int braceStyle;
                common.BRACE_STYLE = braceStyle = finalStyle.getBeginBraceStyle();
                common.METHOD_BRACE_STYLE = braceStyle;
                custom.FUNCTION_EXPRESSION_BRACE_STYLE = braceStyle;
                common.CLASS_BRACE_STYLE = braceStyle;
                common.ELSE_ON_NEW_LINE = finalStyle.isElseOnNewLine();
            }));
        }

        private static enum Style {
            oneTrueBraceStyle("1tbs", 1, false),
            stroustrup("stroustrup", 1, true),
            allman("allman", 2, true);

            private final String myText;
            private final int myBeginBraceStyle;
            private final boolean myElseOnNewLine;

            private Style(String text, int style, boolean line) {
                this.myText = text;
                this.myBeginBraceStyle = style;
                this.myElseOnNewLine = line;
            }

            public String getText() {
                return this.myText;
            }

            public int getBeginBraceStyle() {
                return this.myBeginBraceStyle;
            }

            public boolean isElseOnNewLine() {
                return this.myElseOnNewLine;
            }
        }
    }

    private static class CommaSpacing
    extends EslintRuleMapper {
        protected CommaSpacing() {
            super("comma-spacing");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            BeforeAfter<Boolean> beforeAfter = CommaSpacing.getBeforeAfter(values, false, true);
            if (beforeAfter == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> (Boolean)beforeAfter.getBefore() != common.SPACE_BEFORE_COMMA || (Boolean)beforeAfter.getAfter() != common.SPACE_AFTER_COMMA), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_COMMA = (Boolean)beforeAfter.getBefore();
                common.SPACE_AFTER_COMMA = (Boolean)beforeAfter.getAfter();
            }));
        }
    }

    private static class EolLast
    extends EslintRuleMapper {
        protected EolLast() {
            super("eol-last");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean option = this.getAlwaysNeverOption(values, true);
            if (option == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> EditorSettingsExternalizable.getInstance().isEnsureNewLineAtEOF() != option.booleanValue()), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> EditorSettingsExternalizable.getInstance().setEnsureNewLineAtEOF(option.booleanValue())));
        }
    }

    private static class Curly
    extends EslintRuleMapper {
        protected Curly() {
            super("curly");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Option option = Option.all;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral value = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (value == null) {
                    return MISCONFIGURATION;
                }
                String text = StringUtil.unquoteString((String)value.getValue());
                option = Arrays.stream(Option.values()).filter(o -> o.getText().equals(text)).findFirst().orElse(null);
                if (option == null) {
                    return MISCONFIGURATION;
                }
            }
            int selected = option.getValue();
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.IF_BRACE_FORCE != selected || common.FOR_BRACE_FORCE != selected || common.WHILE_BRACE_FORCE != selected || common.DOWHILE_BRACE_FORCE != selected), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.IF_BRACE_FORCE = selected;
                common.FOR_BRACE_FORCE = selected;
                common.WHILE_BRACE_FORCE = selected;
                common.DOWHILE_BRACE_FORCE = selected;
            }));
        }

        private static enum Option {
            all("all", 3),
            multi("multi", 1),
            multiLine("multi-line", 1),
            multiOrNest("multi-or-nest", 1);

            private final String myText;
            private final int myValue;

            private Option(String text, int value) {
                this.myText = text;
                this.myValue = value;
            }

            public String getText() {
                return this.myText;
            }

            public int getValue() {
                return this.myValue;
            }
        }
    }

    private static class DotLocation
    extends EslintRuleMapper {
        protected DotLocation() {
            super("dot-location");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            boolean isOnNewLine = false;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral value = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (value == null) {
                    return MISCONFIGURATION;
                }
                String text = StringUtil.unquoteString((String)value.getValue());
                if ("property".equals(text)) {
                    isOnNewLine = true;
                } else if (!"object".equals(text)) {
                    return MISCONFIGURATION;
                }
            }
            boolean finalIsOnNewLine = isOnNewLine;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.CHAINED_CALL_DOT_ON_NEW_LINE != finalIsOnNewLine), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.CHAINED_CALL_DOT_ON_NEW_LINE = finalIsOnNewLine;
            }));
        }
    }

    private static class TemplateCurlySpacing
    extends EslintRuleMapper {
        private TemplateCurlySpacing() {
            super("template-curly-spacing");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean option = this.getAlwaysNeverOption(values, false);
            if (option == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACES_WITHIN_INTERPOLATION_EXPRESSIONS != option), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACES_WITHIN_INTERPOLATION_EXPRESSIONS = option;
            }));
        }
    }

    private static class RestSpreadSpacing
    extends EslintRuleMapper {
        protected RestSpreadSpacing() {
            super("rest-spread-spacing");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean option = this.getAlwaysNeverOption(values, false);
            if (option == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACE_AFTER_DOTS_IN_REST_PARAMETER != option), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACE_AFTER_DOTS_IN_REST_PARAMETER = option;
            }));
        }
    }

    private static class YieldStarSpacing
    extends EslintRuleMapper {
        protected YieldStarSpacing() {
            super("yield-star-spacing");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            BeforeAfter beforeAfter;
            if (values != null && !values.isEmpty()) {
                JsonStringLiteral literal = (JsonStringLiteral)ObjectUtils.tryCast((Object)values.get(0), JsonStringLiteral.class);
                if (literal != null) {
                    switch (StringUtil.unquoteString((String)literal.getValue())) {
                        case "after": {
                            beforeAfter = new BeforeAfter((Object)false, (Object)true);
                            break;
                        }
                        case "before": {
                            beforeAfter = new BeforeAfter((Object)true, (Object)false);
                            break;
                        }
                        case "both": {
                            beforeAfter = new BeforeAfter((Object)true, (Object)true);
                            break;
                        }
                        case "neither": {
                            beforeAfter = new BeforeAfter((Object)false, (Object)false);
                            break;
                        }
                        default: {
                            return MISCONFIGURATION;
                        }
                    }
                } else {
                    beforeAfter = YieldStarSpacing.getBeforeAfter(values, false, true);
                    if (beforeAfter == null) {
                        return MISCONFIGURATION;
                    }
                }
            } else {
                beforeAfter = new BeforeAfter((Object)false, (Object)true);
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACE_BEFORE_GENERATOR_MULT != (Boolean)beforeAfter.getBefore() || custom.SPACE_AFTER_GENERATOR_MULT != (Boolean)beforeAfter.getAfter()), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACE_BEFORE_GENERATOR_MULT = (Boolean)beforeAfter.getBefore();
                custom.SPACE_AFTER_GENERATOR_MULT = (Boolean)beforeAfter.getAfter();
            }));
        }
    }

    private static class ObjectCurlyNewline
    extends EslintRuleMapper {
        protected ObjectCurlyNewline() {
            super("object-curly-newline");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean option = true;
            if (values != null && !values.isEmpty() && (option = this.readOption(values)) == null) {
                JsonValue objectExpression;
                JsonObject config2 = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (config2 == null) {
                    return MISCONFIGURATION;
                }
                JsonProperty property = config2.findProperty("ObjectExpression");
                JsonValue jsonValue = objectExpression = property == null ? null : (JsonValue)ObjectUtils.tryCast((Object)property.getValue(), JsonValue.class);
                if (objectExpression != null) {
                    option = this.readOption(Collections.singletonList(objectExpression));
                    if (option == null) {
                        return MISCONFIGURATION;
                    }
                } else {
                    return SKIPPED;
                }
            }
            int optionValue = option != false ? 2 : 0;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.OBJECT_LITERAL_WRAP != optionValue), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.OBJECT_LITERAL_WRAP = optionValue;
            }));
        }

        @Nullable
        private Boolean readOption(@NotNull List<JsonValue> values) {
            JsonBooleanLiteral multiline;
            Boolean option;
            if (values == null) {
                ObjectCurlyNewline.$$$reportNull$$$0(0);
            }
            if ((option = this.getAlwaysNeverOption(values, true)) != null) {
                return option;
            }
            JsonObject config2 = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
            if (config2 == null) {
                return null;
            }
            JsonProperty property = config2.findProperty("multiline");
            JsonBooleanLiteral jsonBooleanLiteral = multiline = property == null ? null : (JsonBooleanLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonBooleanLiteral.class);
            if (multiline != null) {
                return multiline.getValue();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/lang/javascript/linter/eslint/importer/EslintConfigWrapper$ObjectCurlyNewline", "readOption"));
        }
    }

    private static class ObjectCurlySpacing
    extends EslintRuleMapper {
        protected ObjectCurlySpacing() {
            super("object-curly-spacing");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean option = this.getAlwaysNeverOption(values, false);
            if (option == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> custom.SPACES_WITHIN_OBJECT_LITERAL_BRACES != option || custom.SPACES_WITHIN_IMPORTS != option), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                custom.SPACES_WITHIN_OBJECT_LITERAL_BRACES = option;
                custom.SPACES_WITHIN_IMPORTS = option;
            }));
        }
    }

    private static class SemiSpacing
    extends EslintRuleMapper {
        protected SemiSpacing() {
            super("semi-spacing");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            BeforeAfter<Boolean> beforeAfter = SemiSpacing.getBeforeAfter(values, false, true);
            if (beforeAfter == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_SEMICOLON != (Boolean)beforeAfter.getBefore()), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_SEMICOLON = (Boolean)beforeAfter.getBefore();
            }));
        }
    }

    private static class SpaceBeforeFunctionParen
    extends EslintRuleMapper {
        protected SpaceBeforeFunctionParen() {
            super("space-before-function-paren");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean forArrow;
            Boolean forAnonymous;
            Boolean forNamed;
            Boolean option = this.getAlwaysNeverOption(values, true);
            if (option == null) {
                JsonObject obj;
                JsonObject jsonObject = obj = values != null && !values.isEmpty() && values.get(0) instanceof JsonObject ? (JsonObject)values.get(0) : null;
                if (obj == null) {
                    return MISCONFIGURATION;
                }
                forNamed = this.getAlwaysNeverOption(obj.findProperty("named"), true);
                forAnonymous = this.getAlwaysNeverOption(obj.findProperty("anonymous"), true);
                forArrow = this.getAlwaysNeverOption(obj.findProperty("asyncArrow"), true);
            } else {
                forNamed = option;
                forAnonymous = option;
                forArrow = option;
            }
            if (forAnonymous == null || forNamed == null || forArrow == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_METHOD_PARENTHESES != forNamed || custom.SPACE_BEFORE_FUNCTION_LEFT_PARENTH != forAnonymous || custom.SPACE_BEFORE_ASYNC_ARROW_LPAREN != forArrow), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_METHOD_PARENTHESES = forNamed;
                custom.SPACE_BEFORE_FUNCTION_LEFT_PARENTH = forAnonymous;
                custom.SPACE_BEFORE_ASYNC_ARROW_LPAREN = forArrow;
            }));
        }
    }

    private static class SpaceInParens
    extends EslintRuleMapper {
        protected SpaceInParens() {
            super("space-in-parens");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean option = this.getAlwaysNeverOption(values, false);
            if (option == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_WITHIN_METHOD_CALL_PARENTHESES != option || common.SPACE_WITHIN_PARENTHESES != option || common.SPACE_WITHIN_METHOD_PARENTHESES != option), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_WITHIN_METHOD_CALL_PARENTHESES = option;
                common.SPACE_WITHIN_PARENTHESES = option;
                common.SPACE_WITHIN_METHOD_PARENTHESES = option;
            }));
        }
    }

    private static class SpaceInfixOps
    extends EslintRuleMapper {
        protected SpaceInfixOps() {
            super("space-infix-ops");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            boolean skipBitwise = false;
            if (values != null && !values.isEmpty()) {
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (object == null) {
                    return MISCONFIGURATION;
                }
                JsonProperty int32Hint = object.findProperty("int32Hint");
                if (int32Hint != null) {
                    JsonBooleanLiteral literal = (JsonBooleanLiteral)ObjectUtils.tryCast((Object)int32Hint.getValue(), JsonBooleanLiteral.class);
                    if (literal == null) {
                        return MISCONFIGURATION;
                    }
                    skipBitwise = literal.getValue();
                }
            }
            boolean finalSkipBitwise = skipBitwise;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> !common.SPACE_AROUND_ASSIGNMENT_OPERATORS || !common.SPACE_AROUND_LOGICAL_OPERATORS || !common.SPACE_AROUND_EQUALITY_OPERATORS || !common.SPACE_AROUND_RELATIONAL_OPERATORS || finalSkipBitwise == common.SPACE_AROUND_BITWISE_OPERATORS || !common.SPACE_AROUND_ADDITIVE_OPERATORS || !common.SPACE_AROUND_MULTIPLICATIVE_OPERATORS || !common.SPACE_AROUND_SHIFT_OPERATORS), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
                common.SPACE_AROUND_LOGICAL_OPERATORS = true;
                common.SPACE_AROUND_EQUALITY_OPERATORS = true;
                common.SPACE_AROUND_RELATIONAL_OPERATORS = true;
                common.SPACE_AROUND_BITWISE_OPERATORS = !finalSkipBitwise;
                common.SPACE_AROUND_ADDITIVE_OPERATORS = true;
                common.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
                common.SPACE_AROUND_SHIFT_OPERATORS = true;
            }));
        }
    }

    private static class SpaceUnaryOps
    extends EslintRuleMapper {
        protected SpaceUnaryOps() {
            super("space-unary-ops");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean nonWords = false;
            if (values != null && !values.isEmpty()) {
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)values.get(0), JsonObject.class);
                if (object == null) {
                    return MISCONFIGURATION;
                }
                nonWords = SpaceUnaryOps.getBooleanOptionValue(object, "nonwords", false);
                if (nonWords == null) {
                    return MISCONFIGURATION;
                }
            }
            Boolean finalNonWords = nonWords;
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_AROUND_UNARY_OPERATOR != finalNonWords), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_AROUND_UNARY_OPERATOR = finalNonWords;
            }));
        }
    }

    private static class FuncCallSpacing
    extends EslintRuleMapper {
        protected FuncCallSpacing() {
            super("func-call-spacing");
        }

        @Override
        protected SettingsConvertor create(@Nullable List<JsonValue> values) {
            Boolean isOn = this.getAlwaysNeverOption(values, false);
            if (isOn == null) {
                return MISCONFIGURATION;
            }
            return new SettingsConvertor((PairProcessor<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairProcessor)(common, custom) -> common.SPACE_BEFORE_METHOD_CALL_PARENTHESES != isOn), (PairConsumer<? super CommonCodeStyleSettings, ? super JSCodeStyleSettings>)((PairConsumer)(common, custom) -> {
                common.SPACE_BEFORE_METHOD_CALL_PARENTHESES = isOn;
            }));
        }
    }
}

