/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.actions.ruleset.CurrentFileStyleCreator;
import com.intellij.psi.css.actions.ruleset.ExistingFileStyleCreator;
import com.intellij.psi.css.actions.ruleset.ExistingFileStyleCreatorWithChooser;
import com.intellij.psi.css.actions.ruleset.NewFileStyleCreator;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CssSelectTargetPopupFactory
extends BaseListPopupStep<StyleCreator> {
    private CssSelectTargetPopupFactory() {
    }

    @NotNull
    public static ListPopup createSelectTargetPopup(@NotNull String text, @NotNull PsiFile file, boolean suggestCurrentFile, @NotNull Pass<StyleCreator> chooseItemCallback) {
        PsiDirectory parentDirectory;
        if (text == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(1);
        }
        if (chooseItemCallback == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(2);
        }
        DefaultActionGroup group = new DefaultActionGroup("", true);
        if (suggestCurrentFile) {
            group.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new CurrentFileStyleCreator(file)));
        }
        if ((parentDirectory = file.getContainingDirectory()) != null) {
            group.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new NewFileStyleCreator(file)));
        }
        group.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new ExistingFileStyleCreatorWithChooser(file)));
        HashSet filesToIgnore = ContainerUtil.newHashSet();
        CssSelectTargetPopupFactory.addCreatorsForLinkedFiles(file, group, filesToIgnore, chooseItemCallback);
        CssSelectTargetPopupFactory.addCreatorsForOpenFiles(file, group, filesToIgnore, chooseItemCallback);
        CssSelectTargetPopupFactory.addCreatorsForRecentFiles(file, group, filesToIgnore, chooseItemCallback);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(text, (ActionGroup)group, SimpleDataContext.getProjectContext((Project)file.getProject()), false, null, 10);
        if (listPopup == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    private static void addCreatorsForLinkedFiles(@NotNull PsiFile file, @NotNull DefaultActionGroup rootGroup, @NotNull Set<VirtualFile> filesToIgnore, @NotNull Pass<StyleCreator> chooseItemCallback) {
        if (file == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(4);
        }
        if (rootGroup == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(5);
        }
        if (filesToIgnore == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(6);
        }
        if (chooseItemCallback == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(7);
        }
        if (file instanceof XmlFile) {
            CssResolver resolver = CssResolveManager.getInstance().getNewResolver();
            resolver.setStrictResolveMode(true);
            resolver.setUseAgentStylesheet(false);
            StylesheetFile[] stylesheetFiles = resolver.resolveStyleSheets((XmlFile)file, null);
            DefaultActionGroup linkedFilesGroup = new DefaultActionGroup("", true);
            linkedFilesGroup.addSeparator("Linked Files");
            if (!LanguageUtil.isInTemplateLanguageFile((PsiElement)file)) {
                for (StylesheetFile stylesheetFile : stylesheetFiles) {
                    linkedFilesGroup.add(CssSelectTargetPopupFactory.wrapWithAction(chooseItemCallback, new ExistingFileStyleCreator(file, stylesheetFile)));
                    filesToIgnore.add(stylesheetFile.getVirtualFile());
                }
            }
            if (linkedFilesGroup.getChildrenCount() > 0) {
                rootGroup.addAll((ActionGroup)linkedFilesGroup);
            }
        }
    }

    private static void addCreatorsForRecentFiles(@NotNull PsiFile contextFile, @NotNull DefaultActionGroup rootGroup, @NotNull Set<VirtualFile> filesToIgnore, @NotNull Pass<StyleCreator> chooseItemCallback) {
        if (contextFile == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(8);
        }
        if (rootGroup == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(9);
        }
        if (filesToIgnore == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(10);
        }
        if (chooseItemCallback == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(11);
        }
        DefaultActionGroup recentFilesGroup = new DefaultActionGroup("", true);
        recentFilesGroup.addSeparator("Recent Files");
        VirtualFile[] recentEditedFiles = IdeDocumentHistory.getInstance((Project)contextFile.getProject()).getChangedFiles();
        CssSelectTargetPopupFactory.addStylesheetFilesToGroup(recentEditedFiles, contextFile, chooseItemCallback, filesToIgnore, recentFilesGroup);
        if (recentFilesGroup.getChildrenCount() > 0) {
            rootGroup.addAll((ActionGroup)recentFilesGroup);
        }
    }

    private static void addCreatorsForOpenFiles(@NotNull PsiFile contextFile, @NotNull DefaultActionGroup rootGroup, @NotNull Set<VirtualFile> filesToIgnore, @NotNull Pass<StyleCreator> chooseItemCallback) {
        if (contextFile == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(12);
        }
        if (rootGroup == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(13);
        }
        if (filesToIgnore == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(14);
        }
        if (chooseItemCallback == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(15);
        }
        DefaultActionGroup recentFilesGroup = new DefaultActionGroup("", true);
        recentFilesGroup.addSeparator("Open Files");
        VirtualFile[] openFiles = FileEditorManager.getInstance((Project)contextFile.getProject()).getOpenFiles();
        CssSelectTargetPopupFactory.addStylesheetFilesToGroup(openFiles, contextFile, chooseItemCallback, filesToIgnore, recentFilesGroup);
        if (recentFilesGroup.getChildrenCount() > 0) {
            rootGroup.addAll((ActionGroup)recentFilesGroup);
        }
    }

    private static void addStylesheetFilesToGroup(@NotNull VirtualFile[] files, @NotNull PsiFile contextFile, @NotNull Pass<StyleCreator> callback, @NotNull Set<VirtualFile> filesToIgnore, @NotNull DefaultActionGroup targetGroup) {
        if (files == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(16);
        }
        if (contextFile == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(17);
        }
        if (callback == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(18);
        }
        if (filesToIgnore == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(19);
        }
        if (targetGroup == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(20);
        }
        PsiManager psiManager = contextFile.getManager();
        for (VirtualFile virtualFile : files) {
            PsiFile psiFile;
            if (filesToIgnore.contains(virtualFile) || !((psiFile = psiManager.findFile(virtualFile)) instanceof StylesheetFile)) continue;
            targetGroup.add(CssSelectTargetPopupFactory.wrapWithAction(callback, new ExistingFileStyleCreator(contextFile, (StylesheetFile)psiFile)));
            filesToIgnore.add(virtualFile);
        }
    }

    @NotNull
    private static AnAction wrapWithAction(final @NotNull Pass<StyleCreator> pass, final @NotNull StyleCreator creator) {
        if (pass == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(21);
        }
        if (creator == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(22);
        }
        AnAction anAction = new AnAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                e.getPresentation().setText(creator.getName(), false);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                pass.pass((Object)creator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (anAction == null) {
            CssSelectTargetPopupFactory.$$$reportNull$$$0(23);
        }
        return anAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooseItemCallback";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGroup";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToIgnore";
                break;
            }
            case 8: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetGroup";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/ruleset/CssSelectTargetPopupFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectTargetPopup";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSelectTargetPopup";
                break;
            }
            case 3: 
            case 23: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCreatorsForLinkedFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addCreatorsForRecentFiles";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addCreatorsForOpenFiles";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addStylesheetFilesToGroup";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

