/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.resolve;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.impl.YAMLAliasImpl;
import org.jetbrains.yaml.resolve.YAMLLocalResolveUtil;

public class YAMLAliasReference
extends PsiReferenceBase<YAMLAliasImpl> {
    public YAMLAliasReference(YAMLAliasImpl alias) {
        super((PsiElement)alias);
    }

    @Nullable
    public YAMLAnchor resolve() {
        return YAMLLocalResolveUtil.getResolveAliasMap(((YAMLAliasImpl)this.myElement).getContainingFile()).get(this.myElement);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            YAMLAliasReference.$$$reportNull$$$0(0);
        }
        this.getIdentifier().replaceWithText(newElementName);
        return this.myElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = TextRange.from((int)this.getIdentifier().getStartOffsetInParent(), (int)this.getIdentifier().getTextLength());
        if (textRange == null) {
            YAMLAliasReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Contract(pure=true)
    @NotNull
    private LeafPsiElement getIdentifier() {
        LeafPsiElement leafPsiElement = Objects.requireNonNull(((YAMLAliasImpl)this.myElement).getIdentifierPsi(), "Reference should not be created for aliases without name");
        if (leafPsiElement == null) {
            YAMLAliasReference.$$$reportNull$$$0(2);
        }
        return leafPsiElement;
    }

    @NotNull
    public Object[] getVariants() {
        Collection<YAMLAnchor> defs = YAMLLocalResolveUtil.getFirstAnchorDefs(((YAMLAliasImpl)this.myElement).getContainingFile().getOriginalFile());
        Object[] objectArray = defs.toArray();
        if (objectArray == null) {
            YAMLAliasReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/resolve/YAMLAliasReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/resolve/YAMLAliasReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

