/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.dialects.mysql.MysqlDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;

public class MysqlDefinitionProvider
extends AbstractDefinitionProvider {
    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            MysqlDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.SCHEMA || kind == ObjectKind.VIEW || kind == ObjectKind.ROUTINE || kind == ObjectKind.TRIGGER || kind == ObjectKind.TABLE;
    }

    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection2, @NotNull PairConsumer<DasObject, Object> consumer2) {
        if (objects == null) {
            MysqlDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            MysqlDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            MysqlDefinitionProvider.$$$reportNull$$$0(3);
        }
        try (ReusableSmartStatement<String> statement = SmartStatements.poweredBy(connection2).simple().reuse();){
            for (DasObject dasObject : objects) {
                Object result2 = statement.execute(MysqlDefinitionProvider.getQuery(dasObject), (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.resultsTransformer(rs -> !rs.next() ? null : rs.getString(MysqlDefinitionProvider.getColumn(object)))).any();
                consumer2.consume((Object)dasObject, result2);
            }
        }
    }

    private static int getColumn(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            MysqlDefinitionProvider.$$$reportNull$$$0(4);
        }
        if ((kind = object.getKind()) == ObjectKind.TRIGGER || kind == ObjectKind.ROUTINE) {
            return 3;
        }
        return 2;
    }

    private static String getQuery(@NotNull DasObject obj) {
        if (obj == null) {
            MysqlDefinitionProvider.$$$reportNull$$$0(5);
        }
        MysqlDialect dialect = MysqlDialect.INSTANCE;
        ObjectKind kind = obj.getKind();
        StringBuilder res2 = new StringBuilder("SHOW CREATE ");
        if (kind == ObjectKind.ROUTINE) {
            res2.append(obj instanceof DasRoutine && ((DasRoutine)obj).getRoutineKind() == DasRoutine.Kind.FUNCTION ? "FUNCTION" : "PROCEDURE");
        } else {
            res2.append(kind.name());
        }
        res2.append(" ");
        if (kind != ObjectKind.SCHEMA) {
            res2.append(dialect.quoteIdentifier(DasUtil.getSchema((DasObject)obj), true, false)).append(".");
        }
        res2.append(dialect.quoteIdentifier(obj.getName(), true, false));
        return res2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/mysql/MysqlDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getColumn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getQuery";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

