/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.cassandra.CassandraReservedKeywords;
import com.intellij.sql.dialects.cassandra.CassandraTokens;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassandraDialect
extends SqlLanguageDialectEx {
    public static final CassandraDialect INSTANCE = new CassandraDialect();

    @Override
    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, "timeuuid", "timeuuid", (SqlLanguageDialectEx)this);
    }

    public CassandraDialect() {
        super("CassandraQL");
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.CASSANDRA;
        if (dbms == null) {
            CassandraDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            CassandraDialect.$$$reportNull$$$0(1);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            CassandraDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            CassandraDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            CassandraDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element2, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            CassandraDialect.$$$reportNull$$$0(5);
        }
        if (type == ObjectKind.OBJECT_ATTRIBUTE && expectedTypes.contains(ObjectKind.COLUMN)) {
            return true;
        }
        return super.isResolveTargetAccepted(element2, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            CassandraDialect.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            CassandraDialect.$$$reportNull$$$0(7);
        }
        return super.processReservedEntitiesWithType(name, element2, resolve, processor);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            CassandraDialect.$$$reportNull$$$0(8);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "double";
            }
            case STRING: {
                return "text";
            }
            case DATE_TIME: 
            case DATE: {
                return "date";
            }
            case INTERVAL: {
                return "duration";
            }
            case COLLECTION: {
                return "list";
            }
            case SETOF: {
                return "set";
            }
            case BYTES: 
            case ARRAY: {
                return "blob";
            }
        }
        return super.getDefaultTypeName(cat);
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        String fixed;
        if (typeName == null) {
            CassandraDialect.$$$reportNull$$$0(9);
        }
        if ((fixed = StringUtil.toUpperCase((String)typeName)).startsWith("SET<")) {
            SqlType.Category category = SqlType.Category.SETOF;
            if (category == null) {
                CassandraDialect.$$$reportNull$$$0(10);
            }
            return category;
        }
        if (fixed.startsWith("MAP<")) {
            SqlType.Category category = SqlType.Category.COLLECTION;
            if (category == null) {
                CassandraDialect.$$$reportNull$$$0(11);
            }
            return category;
        }
        if (fixed.startsWith("LIST<")) {
            SqlType.Category category = SqlType.Category.ARRAY;
            if (category == null) {
                CassandraDialect.$$$reportNull$$$0(12);
            }
            return category;
        }
        if (fixed.startsWith("TUPLE<")) {
            SqlType.Category category = SqlType.Category.COLLECTION;
            if (category == null) {
                CassandraDialect.$$$reportNull$$$0(13);
            }
            return category;
        }
        if (fixed.startsWith("FROZEN<")) {
            SqlType.Category category = SqlType.Category.UNKNOWN;
            if (category == null) {
                CassandraDialect.$$$reportNull$$$0(14);
            }
            return category;
        }
        if (fixed.contains("TIMEUUID")) {
            SqlType.Category category = SqlType.Category.TIMESTAMP;
            if (category == null) {
                CassandraDialect.$$$reportNull$$$0(15);
            }
            return category;
        }
        if (fixed.contains("DURATION")) {
            SqlType.Category category = SqlType.Category.INTERVAL;
            if (category == null) {
                CassandraDialect.$$$reportNull$$$0(16);
            }
            return category;
        }
        if (fixed.contains("BLOB")) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                CassandraDialect.$$$reportNull$$$0(17);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            CassandraDialect.$$$reportNull$$$0(18);
        }
        return category;
    }

    @Override
    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        DasNamespace namespace = CassandraDialect.getDefaultNamespace(dataSource, null);
        if (namespace != null) {
            SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, new TreePatternNode.Group[0]);
        }
        TreePattern treePattern = this.getSchemaBaseImports(dataSource, dsNames, false);
        if (treePattern == null) {
            CassandraDialect.$$$reportNull$$$0(19);
        }
        return treePattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cassandra/CassandraDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cassandra/CassandraDialect";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(CassandraTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        static final TokenSet ourClosingTokens;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens(CassandraTokens.class);
            ourReservedKeywords = SqlTokenRegistry.getTokens(CassandraReservedKeywords.class);
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_NOT, SqlTokens.SQL_IN, SqlTokens.SQL_OP_MODULO});
            ourClosingTokens = SqlTokens.STATEMENT_SEPARATORS;
        }
    }
}

