/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.EndIncElementPattern;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.Shape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCodeFlowBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\nJ\u001f\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0015\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0010\u00a2\u0006\u0002\b\u0017J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0014J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020!H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/sql/formatter/model/SqlCodeFlowBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "countOfElements", "", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "determineRole", "node", "Lcom/intellij/lang/ASTNode;", "determineRole$intellij_database_sql_impl", "flowPatterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getNewLineIdent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "preserveUserLineBreaks", "", "userRequiresExpand", "Companion", "intellij.database.sql.impl"})
public class SqlCodeFlowBlock
extends SqlRangeBlock {
    private int countOfElements;
    @NotNull
    private static final Map<IElementType, FlowPattern> patterns;
    public static final Companion Companion;

    @Override
    @NotNull
    protected Map<IElementType, FlowPattern> flowPatterns() {
        return patterns;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BlockRole determineRole$intellij_database_sql_impl(@NotNull ASTNode node) {
        BlockRole blockRole;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (node instanceof SqlStatement) {
            blockRole = BlockRole.ELEMENT;
        } else {
            void what$iv;
            void $receiver$iv;
            BlockRole blockRole2 = super.determineRole$intellij_database_sql_impl(node);
            BlockRole blockRole3 = BlockRole.NOTHING;
            BlockRole with$iv = BlockRole.ELEMENT;
            blockRole = Intrinsics.areEqual((Object)$receiver$iv, (Object)what$iv) ? with$iv : blockRole2;
        }
        return blockRole;
    }

    @Override
    public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        if (role == BlockRole.ELEMENT) {
            int n = this.countOfElements;
            this.countOfElements = n + 1;
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    public boolean userRequiresExpand() {
        return this.countOfElements >= 2 && this.getContext().getSql().IMP_COMMON_WRAP_EVERY_STATEMENT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean preserveUserLineBreaks() {
        int n = this.getNestedNodes().size();
        if (this.countOfElements < 2) {
            return false;
        }
        if (this.getContext().getSql().IMP_COMMON_WRAP_EVERY_STATEMENT) {
            return true;
        }
        int n2 = 1;
        int n3 = n;
        while (n2 < n3) {
            void i2;
            ASTNode node1 = this.getNestedNodes().get((int)(i2 - true));
            ASTNode node2 = this.getNestedNodes().get((int)i2);
            if (node2 instanceof SqlStatement && this.getContext().textContainsBetween(node1, node2, '\n')) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    protected void configureFormattingAttributes() {
        WrapType wt = this.getContext().getSql().IMP_COMMON_WRAP_EVERY_STATEMENT ? WrapType.CHOP_DOWN_IF_LONG : WrapType.NORMAL;
        Wrap w = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, wt, false, 2, null);
        JBIterable jBIterable = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).skip(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"nestedBlocks.filter(BlockRole.ELEMENT).skip(1)");
        Iterable $receiver$iv = (Iterable)jBIterable;
        for (Object element$iv : $receiver$iv) {
            SqlBlock it = (SqlBlock)element$iv;
            it.setMyWrap(w);
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        if (this.getShape() == Shape.COLLAPSE) {
            return super.decideSpacing$intellij_database_sql_impl(block1, block2);
        }
        if (block2.getShape() == Shape.EXPAND) {
            return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
        }
        if (block1.getRole() == BlockRole.ELEMENT && block2.getRole() == BlockRole.DELIMITER) {
            return this.getContext().makeNoSpace(false);
        }
        if (block2.getRole() == BlockRole.DELIMITER) {
            return SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null);
        }
        if (block2.getRole() == BlockRole.ELEMENT && this.getContext().getSql().IMP_COMMON_WRAP_EVERY_STATEMENT) {
            return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
        }
        SqlBlock stmtBlock1 = null;
        if (block1.getRole() == BlockRole.ELEMENT) {
            stmtBlock1 = block1;
        } else {
            for (SqlBlock b2 : this.getNestedBlocks()) {
                if (b2.getRole() == BlockRole.ELEMENT) {
                    stmtBlock1 = b2;
                }
                if (!Intrinsics.areEqual((Object)b2, (Object)block1)) continue;
                break;
            }
        }
        SqlBlock sqlBlock = stmtBlock1;
        if ((sqlBlock != null ? sqlBlock.getShape() : null) == Shape.EXPAND) {
            return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
        }
        return this.getContext().makeAutoSpacing(true);
    }

    @Override
    @Nullable
    public String getNewLineIdent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkParameterIsNotNull((Object)blocks, (String)"blocks");
        BlockRole r1 = blocks.getRole1();
        return r1 == BlockRole.DELIMITER ? null : SqlFormattingContext.currIndentOf$default(this.getContext(), (Block)this, false, true, 2, null);
    }

    static {
        Companion = new Companion(null);
        patterns = MapsKt.mapOf((Pair)TuplesKt.to((Object)SqlCompositeElementTypes.SQL_START_TRANSACTION_STATEMENT, (Object)new EndIncElementPattern(SetsKt.setOf((Object[])new SqlCompositeElementType[]{SqlCompositeElementTypes.SQL_COMMIT_STATEMENT, SqlCompositeElementTypes.SQL_ROLLBACK_STATEMENT}), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE))));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlCodeFlowBlock$Companion;", "", "()V", "patterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/Map;", "intellij.database.sql.impl"})
    public static final class Companion {
        @NotNull
        public final Map<IElementType, FlowPattern> getPatterns() {
            return patterns;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

