/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlQualificationIntentionBase;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SqlUnqualifyIdentifierIntention
extends SqlQualificationIntentionBase {
    @NotNull
    public String getFamilyName() {
        if ("Unqualify identifier" == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(0);
        }
        return "Unqualify identifier";
    }

    @NotNull
    private static JBIterable<SqlReferenceExpression> getTopmostQualifiedRefs(@NotNull PsiFile file, @NotNull Caret caret) {
        if (file == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(1);
        }
        if (caret == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(2);
        }
        JBIterable jBIterable = SqlUnqualifyIdentifierIntention.getTopmostIdentifiers(file, caret).filterMap(identifier -> {
            SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)identifier.getParent(), SqlReferenceExpression.class);
            if (ref == null) {
                return null;
            }
            return ref.getParent() instanceof SqlReferenceExpression ? ref : null;
        });
        if (jBIterable == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(4);
        }
        if (!(file instanceof SqlFile)) {
            return false;
        }
        return !JBIterable.from((Iterable)editor.getCaretModel().getAllCarets()).flatten(c2 -> SqlUnqualifyIdentifierIntention.getTopmostQualifiedRefs(file, c2)).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(5);
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        int depth = 999;
        LinkedHashSet refs = ContainerUtil.newLinkedHashSet();
        for (SqlReferenceExpression ref : JBIterable.from((Iterable)editor.getCaretModel().getAllCarets()).flatten(c2 -> SqlUnqualifyIdentifierIntention.getTopmostQualifiedRefs(file, c2))) {
            int d2 = SqlUnqualifyIdentifierIntention.getDepth(language, SqlUnqualifyIdentifierIntention.getKind(ref.resolve()));
            if (depth < d2) continue;
            if (depth > d2) {
                depth = d2;
                refs.clear();
            }
            refs.add(ref);
        }
        if (!refs.isEmpty()) {
            this.performUnqualification(editor.getDocument(), file, refs);
        }
    }

    private void performUnqualification(@NotNull Document document, @NotNull PsiFile file, @NotNull Set<SqlReferenceExpression> refs) {
        if (document == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(6);
        }
        if (file == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(7);
        }
        if (refs == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(8);
        }
        ArrayList markers = ContainerUtil.newArrayList();
        for (SqlReferenceExpression ref : refs) {
            SqlIdentifier identifier;
            SqlReferenceExpression parent2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getParent(), SqlReferenceExpression.class);
            if (parent2 == null || (identifier = parent2.getIdentifier()) == null) continue;
            TextRange ir = identifier.getTextRange();
            TextRange pr = parent2.getTextRange();
            if (!pr.contains(ir)) continue;
            if (ir.getStartOffset() != pr.getStartOffset()) {
                markers.add(document.createRangeMarker(pr.getStartOffset(), ir.getStartOffset()));
            }
            if (ir.getEndOffset() == pr.getEndOffset()) continue;
            markers.add(document.createRangeMarker(ir.getEndOffset(), pr.getEndOffset()));
        }
        WriteCommandAction.runWriteCommandAction((Project)file.getProject(), (String)this.getText(), (String)this.getText(), () -> {
            if (document == null) {
                SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(9);
            }
            for (RangeMarker marker : markers) {
                document.deleteString(marker.getStartOffset(), marker.getEndOffset());
            }
        }, (PsiFile[])new PsiFile[]{file});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostQualifiedRefs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostQualifiedRefs";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performUnqualification";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performUnqualification$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

