/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.psi.Axis;
import org.intellij.lang.xpath.psi.PrefixedName;
import org.intellij.lang.xpath.psi.XPathAxisSpecifier;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathStep;
import org.intellij.lang.xpath.psi.impl.PrefixReferenceImpl;
import org.intellij.lang.xpath.psi.impl.PrefixedNameImpl;
import org.intellij.lang.xpath.psi.impl.ReferenceBase;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathNodeTestImpl
extends XPathElementImpl
implements XPathNodeTest {
    public XPathNodeTestImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public XPathStep getStep() {
        XPathStep step = (XPathStep)PsiTreeUtil.getParentOfType((PsiElement)this, XPathStep.class);
        assert (step != null) : this.unexpectedPsiAssertion();
        XPathStep xPathStep = step;
        if (xPathStep == null) {
            XPathNodeTestImpl.$$$reportNull$$$0(0);
        }
        return xPathStep;
    }

    @Override
    public boolean isNameTest() {
        return this.getNode().findChildByType(XPathTokenTypes.NCNAME) != null || this.getNode().findChildByType(XPathTokenTypes.STAR) != null;
    }

    @Override
    @Nullable
    public PrefixedName getQName() {
        ASTNode[] nodes = this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{XPathTokenTypes.NCNAME}));
        if (nodes.length == 0) {
            ASTNode node = this.getNode().findChildByType(XPathTokenTypes.STAR);
            if (node != null) {
                return new PrefixedNameImpl(null, node);
            }
        } else {
            if (nodes.length == 1) {
                ASTNode star = this.getNode().findChildByType(XPathTokenTypes.STAR);
                if (star != null) {
                    return star.getTextRange().getStartOffset() > nodes[0].getTextRange().getStartOffset() ? new PrefixedNameImpl(nodes[0], star) : new PrefixedNameImpl(star, nodes[0]);
                }
                return new PrefixedNameImpl(nodes[0]);
            }
            if (nodes.length == 2) {
                return new PrefixedNameImpl(nodes[0], nodes[1]);
            }
        }
        return null;
    }

    public int getTextOffset() {
        PrefixedNameImpl qName = (PrefixedNameImpl)this.getQName();
        if (qName != null) {
            return qName.getLocalNode().getStartOffset();
        }
        return super.getTextOffset();
    }

    @Override
    @NotNull
    public XPathNodeTest.PrincipalType getPrincipalType() {
        XPathStep step = this.getStep();
        XPathAxisSpecifier axisSpecifier = step.getAxisSpecifier();
        if (axisSpecifier == null) {
            XPathNodeTest.PrincipalType principalType = XPathNodeTest.PrincipalType.UNKNOWN;
            if (principalType == null) {
                XPathNodeTestImpl.$$$reportNull$$$0(1);
            }
            return principalType;
        }
        Axis axis = axisSpecifier.getAxis();
        if (axis == Axis.ATTRIBUTE) {
            XPathNodeTest.PrincipalType principalType = XPathNodeTest.PrincipalType.ATTRIBUTE;
            if (principalType == null) {
                XPathNodeTestImpl.$$$reportNull$$$0(2);
            }
            return principalType;
        }
        if (axis == Axis.NAMESPACE) {
            XPathNodeTest.PrincipalType principalType = XPathNodeTest.PrincipalType.NAMESPACE;
            if (principalType == null) {
                XPathNodeTestImpl.$$$reportNull$$$0(3);
            }
            return principalType;
        }
        XPathNodeTest.PrincipalType principalType = XPathNodeTest.PrincipalType.ELEMENT;
        if (principalType == null) {
            XPathNodeTestImpl.$$$reportNull$$$0(4);
        }
        return principalType;
    }

    @Nullable
    public PsiReference getReference() {
        ASTNode name = this.getNode().findChildByType(XPathTokenTypes.NCNAME);
        if (name != null) {
            return new Reference(this, name);
        }
        return null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PrefixedName prefixedName = this.getQName();
        if (prefixedName != null && prefixedName.getPrefix() != null && this.getReference() != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{this.getReference(), new PrefixReferenceImpl(this, ((PrefixedNameImpl)prefixedName).getPrefixNode())};
            if (psiReferenceArray == null) {
                XPathNodeTestImpl.$$$reportNull$$$0(5);
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = super.getReferences();
        if (psiReferenceArray == null) {
            XPathNodeTestImpl.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathNodeTest(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/xpath/psi/impl/XPathNodeTestImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStep";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrincipalType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class Reference
    extends ReferenceBase {
        Reference(XPathNodeTest element, ASTNode nameNode) {
            super(element, nameNode);
        }

        @NotNull
        public Object[] getVariants() {
            if (EMPTY_ARRAY == null) {
                Reference.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathNodeTestImpl$Reference", "getVariants"));
        }
    }
}

