/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.IntArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.inspections.RemoveTableColumnFix;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinExamplesBlock;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCell;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;

public class CucumberTableInspection
extends GherkinInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CucumberBundle.message("unused.or.missing.columns.in.cucumber.tables", new Object[0]);
        if (string == null) {
            CucumberTableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("CucumberTableInspection" == null) {
            CucumberTableInspection.$$$reportNull$$$0(1);
        }
        return "CucumberTableInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CucumberTableInspection.$$$reportNull$$$0(2);
        }
        GherkinElementVisitor gherkinElementVisitor = new GherkinElementVisitor(){

            @Override
            public void visitScenarioOutline(GherkinScenarioOutline outline) {
                List<GherkinExamplesBlock> examples = outline.getExamplesBlocks();
                if (examples.size() > 0) {
                    Collection columnNames = CucumberTableInspection.collectUsedColumnNames(outline);
                    for (GherkinExamplesBlock block : examples) {
                        CucumberTableInspection.checkTable(block.getTable(), columnNames, holder);
                    }
                }
            }
        };
        if (gherkinElementVisitor == null) {
            CucumberTableInspection.$$$reportNull$$$0(3);
        }
        return gherkinElementVisitor;
    }

    private static void checkTable(GherkinTable table, Collection<String> columnNames, ProblemsHolder holder) {
        GherkinTableRow row;
        GherkinTableRow gherkinTableRow = row = table != null ? table.getHeaderRow() : null;
        if (row == null) {
            return;
        }
        List<GherkinTableCell> cells = row.getPsiCells();
        IntArrayList unusedIndices = new IntArrayList();
        int cellsSize = cells.size();
        for (int i = 0; i < cellsSize; ++i) {
            String columnName = cells.get(i).getText().trim();
            if (columnNames.contains(columnName)) continue;
            unusedIndices.add(i);
        }
        if (!unusedIndices.isEmpty()) {
            CucumberTableInspection.highlightUnusedColumns(row, unusedIndices, holder);
            for (GherkinTableRow tableRow : table.getDataRows()) {
                CucumberTableInspection.highlightUnusedColumns(tableRow, unusedIndices, holder);
            }
        }
    }

    private static void highlightUnusedColumns(GherkinTableRow row, IntArrayList unusedIndices, ProblemsHolder holder) {
        List<GherkinTableCell> cells = row.getPsiCells();
        int cellsCount = cells.size();
        GherkinTable table = (GherkinTable)row.getParent();
        for (int i : unusedIndices.toArray()) {
            if (i >= cellsCount || cells.get(i).getTextLength() <= 0) continue;
            holder.registerProblem((PsiElement)cells.get(i), CucumberBundle.message("unused.table.column", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveTableColumnFix(table, i)});
        }
    }

    private static Collection<String> collectUsedColumnNames(GherkinScenarioOutline outline) {
        HashSet<String> result = new HashSet<String>();
        for (GherkinStep step : outline.getSteps()) {
            result.addAll(step.getParamsSubstitutions());
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/CucumberTableInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/CucumberTableInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

